/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.lunch_box;

import com.beansgalaxy.backpacks.traits.abstract_traits.IMutableSelectionTrait;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.SlotSelectorData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class LunchBoxMutable
extends MutableBundleLike<LunchBoxTraits>
implements IMutableSelectionTrait {
    private final SlotSelectorData selection;

    public LunchBoxMutable(LunchBoxTraits traits, ComponentHolder holder) {
        super(traits, holder);
        this.selection = new SlotSelectorData(holder, this::getItemStacks);
    }

    @Override
    public void push() {
        super.push();
        this.selection.push();
    }

    @Override
    public boolean isAcceptableSelection(ItemStack stack) {
        return ((LunchBoxTraits)this.traits).canItemFit(this.holder, stack);
    }

    @Override
    public int getSelectedSlot(Player player) {
        return this.selection.getSelectedSlot(player);
    }

    @Override
    public void growSelectedSlot(int slot) {
        this.selection.growSelectedSlot(slot);
    }

    @Override
    public void limitSelectedSlot(int index) {
        this.selection.limitSelectedSlot(index, this.getItemStacks().size());
    }

    @Override
    public void setSelectedSlot(Player player, int slot) {
        this.selection.setSelectedSlot(player, slot);
    }
}

