/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.lunch_box;

import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.IDraggingTrait;
import com.beansgalaxy.backpacks.traits.abstract_traits.ISlotSelectorTrait;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxClient;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxMutable;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class LunchBoxTraits
extends BundleLikeTraits
implements ISlotSelectorTrait,
IDraggingTrait {
    public static final String NAME = "lunch";

    public LunchBoxTraits(ModSound sound, int size) {
        super(sound, size);
    }

    public LunchBoxClient client() {
        return LunchBoxClient.INSTANCE;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Nullable
    public static LunchBoxTraits get(ItemStack stack) {
        LunchBoxTraits traits = (LunchBoxTraits)stack.get(Traits.LUNCH_BOX);
        if (traits != null) {
            return traits;
        }
        ReferenceTrait reference = (ReferenceTrait)stack.get(Traits.REFERENCE);
        if (reference == null) {
            return null;
        }
        Optional<GenericTraits> optional = reference.getTrait();
        if (optional.isEmpty()) {
            return null;
        }
        GenericTraits genericTraits = optional.get();
        if (genericTraits instanceof LunchBoxTraits) {
            LunchBoxTraits lunch = (LunchBoxTraits)genericTraits;
            return lunch;
        }
        return null;
    }

    public static void ifPresent(ItemStack lunchBox, Consumer<LunchBoxTraits> ifPresent) {
        LunchBoxTraits boxTraits = (LunchBoxTraits)lunchBox.get(Traits.LUNCH_BOX);
        if (boxTraits != null) {
            ifPresent.accept(boxTraits);
            return;
        }
        ReferenceTrait referenceTrait = (ReferenceTrait)lunchBox.get(Traits.REFERENCE);
        if (referenceTrait == null) {
            return;
        }
        referenceTrait.getTrait().ifPresent(traits -> {
            if (traits instanceof LunchBoxTraits) {
                LunchBoxTraits lunchBoxTraits = (LunchBoxTraits)traits;
                ifPresent.accept(lunchBoxTraits);
            }
        });
    }

    public static void selectionIsPresent(ItemStack lunchBox, LivingEntity entity, Consumer<ItemStack> ifPresent) {
        LunchBoxTraits.ifPresent(lunchBox, traits -> {
            int n;
            LunchBoxMutable mutable = traits.mutable(ComponentHolder.of(lunchBox));
            if (mutable.isEmpty()) {
                return;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                n = mutable.getSelectedSlot(player);
            } else {
                n = 0;
            }
            int selectedSlotSafe = n;
            ItemStack food = mutable.getItemStacks().get(selectedSlotSafe);
            ifPresent.accept(food);
        });
    }

    public static void selectionIsPresent(ItemStack lunchBox, Player player, Consumer<ItemStack> ifPresent) {
        LunchBoxTraits.ifPresent(lunchBox, traits -> {
            LunchBoxMutable mutable = traits.mutable(ComponentHolder.of(lunchBox));
            if (mutable.isEmpty()) {
                return;
            }
            int selectedSlotSafe = mutable.getSelectedSlot(player);
            ItemStack food = mutable.getItemStacks().get(selectedSlotSafe);
            ifPresent.accept(food);
        });
    }

    public void finishUsingItem(ComponentHolder holder, ItemStack backpack, Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack consumedStack;
        int n;
        LunchBoxMutable mutable = this.mutable(holder);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            n = mutable.getSelectedSlot(player);
        } else {
            n = 0;
        }
        int selectedSlot = n;
        List<ItemStack> itemStacks = mutable.getItemStacks();
        ItemStack stack = itemStacks.get(selectedSlot);
        ItemStack copy = stack.copyWithCount(1);
        stack.shrink(1);
        if (stack.isEmpty()) {
            itemStacks.remove(selectedSlot);
        }
        if (!(consumedStack = copy.finishUsingItem(level, entity)).isEmpty()) {
            for (int i = 0; i < itemStacks.size(); ++i) {
                ItemStack nonEdible = itemStacks.get(i);
                if (nonEdible.isEmpty()) {
                    itemStacks.remove(i);
                    continue;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)nonEdible, (ItemStack)consumedStack)) continue;
                ItemStack removed = itemStacks.remove(i);
                consumedStack.grow(removed.getCount());
                mutable.limitSelectedSlot(i);
            }
            if (!consumedStack.isEmpty()) {
                itemStacks.addFirst(consumedStack);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    mutable.setSelectedSlot(player, mutable.getSelectedSlot(player));
                }
                mutable.growSelectedSlot(0);
            }
        }
        mutable.push();
        cir.setReturnValue((Object)backpack);
    }

    @Override
    public void use(Level level, Player player, InteractionHand hand, ComponentHolder holder, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        LunchBoxMutable mutable = this.mutable(holder);
        if (mutable.isEmpty()) {
            return;
        }
        int selected = mutable.getSelectedSlot(player);
        ItemStack first = mutable.getItemStacks().get(selected);
        FoodProperties $$4 = (FoodProperties)first.get(DataComponents.FOOD);
        if ($$4 != null && player.canEat($$4.canAlwaysEat())) {
            player.startUsingItem(hand);
            ItemStack backpack = player.getItemInHand(hand);
            cir.setReturnValue((Object)InteractionResultHolder.consume((Object)backpack));
        }
    }

    @Override
    public boolean canItemFit(ComponentHolder holder, ItemStack inserted) {
        return inserted.has(DataComponents.FOOD) && super.canItemFit(holder, inserted);
    }

    @Override
    public LunchBoxMutable mutable(ComponentHolder holder) {
        return new LunchBoxMutable(this, holder);
    }

    public String toString() {
        return "LunchBoxTraits{size=" + this.size() + ", sound=" + String.valueOf((Object)this.sound()) + "}";
    }

    @Override
    public TraitComponentKind<? extends GenericTraits> kind() {
        return Traits.LUNCH_BOX;
    }
}

