/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util;

import net.minecraft.core.Direction;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CollidingVertexMap {
    final AABB starting_box;
    final Level level;
    final Vec3 cursor;
    public AABB box;
    Direction direction;
    Vec3[] clipped = new Vec3[4];
    Vec3[] hanging = new Vec3[4];
    int pointer = 0;

    public CollidingVertexMap(AABB box, Direction direction, Level level, Vec3 cursor) {
        this.direction = direction;
        this.level = level;
        this.box = box;
        this.starting_box = box;
        this.cursor = cursor;
        this.updateCords();
    }

    private void updateCords() {
        Vec3[] clip;
        Vec3[] hang;
        switch (this.direction) {
            case NORTH: {
                hang = new Vec3[]{new Vec3(this.box.minX, this.box.maxY, this.box.minZ), new Vec3(this.box.maxX, this.box.maxY, this.box.minZ), new Vec3(this.box.maxX, this.box.minY, this.box.minZ), new Vec3(this.box.minX, this.box.minY, this.box.minZ)};
                clip = new Vec3[]{new Vec3(this.box.minX, this.box.maxY, this.box.maxZ), new Vec3(this.box.maxX, this.box.maxY, this.box.maxZ), new Vec3(this.box.maxX, this.box.minY, this.box.maxZ), new Vec3(this.box.minX, this.box.minY, this.box.maxZ)};
                break;
            }
            case SOUTH: {
                clip = new Vec3[]{new Vec3(this.box.minX, this.box.maxY, this.box.minZ), new Vec3(this.box.maxX, this.box.maxY, this.box.minZ), new Vec3(this.box.maxX, this.box.minY, this.box.minZ), new Vec3(this.box.minX, this.box.minY, this.box.minZ)};
                hang = new Vec3[]{new Vec3(this.box.minX, this.box.maxY, this.box.maxZ), new Vec3(this.box.maxX, this.box.maxY, this.box.maxZ), new Vec3(this.box.maxX, this.box.minY, this.box.maxZ), new Vec3(this.box.minX, this.box.minY, this.box.maxZ)};
                break;
            }
            case EAST: {
                hang = new Vec3[]{new Vec3(this.box.maxX, this.box.maxY, this.box.maxZ), new Vec3(this.box.maxX, this.box.maxY, this.box.minZ), new Vec3(this.box.maxX, this.box.minY, this.box.minZ), new Vec3(this.box.maxX, this.box.minY, this.box.maxZ)};
                clip = new Vec3[]{new Vec3(this.box.minX, this.box.maxY, this.box.maxZ), new Vec3(this.box.minX, this.box.maxY, this.box.minZ), new Vec3(this.box.minX, this.box.minY, this.box.minZ), new Vec3(this.box.minX, this.box.minY, this.box.maxZ)};
                break;
            }
            case WEST: {
                clip = new Vec3[]{new Vec3(this.box.maxX, this.box.maxY, this.box.maxZ), new Vec3(this.box.maxX, this.box.maxY, this.box.minZ), new Vec3(this.box.maxX, this.box.minY, this.box.minZ), new Vec3(this.box.maxX, this.box.minY, this.box.maxZ)};
                hang = new Vec3[]{new Vec3(this.box.minX, this.box.maxY, this.box.maxZ), new Vec3(this.box.minX, this.box.maxY, this.box.minZ), new Vec3(this.box.minX, this.box.minY, this.box.minZ), new Vec3(this.box.minX, this.box.minY, this.box.maxZ)};
                break;
            }
            case UP: 
            case DOWN: {
                clip = new Vec3[]{new Vec3(this.box.maxX, this.box.minY, this.box.maxZ), new Vec3(this.box.maxX, this.box.minY, this.box.minZ), new Vec3(this.box.minX, this.box.minY, this.box.minZ), new Vec3(this.box.minX, this.box.minY, this.box.maxZ)};
                hang = new Vec3[]{new Vec3(this.box.maxX, this.box.maxY, this.box.maxZ), new Vec3(this.box.maxX, this.box.maxY, this.box.minZ), new Vec3(this.box.minX, this.box.maxY, this.box.minZ), new Vec3(this.box.minX, this.box.maxY, this.box.maxZ)};
                break;
            }
            default: {
                return;
            }
        }
        this.clipped = clip;
        this.hanging = hang;
    }

    public boolean areClippedPointsStable() {
        this.pointer = 0;
        while (this.pointer < 4) {
            Vec3 v = this.clipped[this.pointer];
            Vec3 offs = new Vec3(0.1, 0.1, 0.1);
            Iterable blockCollisions = this.level.getBlockCollisions(null, new AABB(v.add(offs), v.subtract(offs)));
            boolean noCollision = true;
            block1: for (VoxelShape collision : blockCollisions) {
                for (AABB ab : collision.toAabbs()) {
                    boolean minX = v.x >= ab.minX;
                    boolean maxX = v.x <= ab.maxX;
                    boolean minY = v.y >= ab.minY;
                    boolean maxY = v.y <= ab.maxY;
                    boolean minZ = v.z >= ab.minZ;
                    boolean maxZ = v.z <= ab.maxZ;
                    boolean contains = minX && maxX && minY && maxY && minZ && maxZ;
                    if (!contains) continue;
                    noCollision = false;
                    continue block1;
                }
            }
            if (noCollision) {
                return false;
            }
            ++this.pointer;
        }
        return true;
    }

    public void stabilizeHangingPoints() {
        Vec3 vFace;
        int i;
        Vec3[] face;
        Vec3 size = new Vec3(0.21875, 0.28125, 0.21875);
        AABB aabb = new AABB(this.cursor.add(size), this.cursor.subtract(size));
        Vec3 center = aabb.getCenter();
        Vec3 px = new Vec3(aabb.maxX, center.y, center.z);
        Vec3 nx = new Vec3(aabb.minX, center.y, center.z);
        Vec3 pz = new Vec3(center.x, center.y, aabb.maxZ);
        Vec3 nz = new Vec3(center.x, center.y, aabb.minZ);
        Vec3[] pair = switch (this.direction) {
            case Direction.NORTH -> {
                face = new Vec3[]{nz};
                yield new Vec3[]{pz};
            }
            case Direction.SOUTH -> {
                face = new Vec3[]{pz};
                yield new Vec3[]{nz};
            }
            case Direction.EAST -> {
                face = new Vec3[]{px};
                yield new Vec3[]{nx};
            }
            case Direction.WEST -> {
                face = new Vec3[]{nx};
                yield new Vec3[]{px};
            }
            default -> {
                face = new Vec3[]{nx, nz, px, pz};
                yield new Vec3[]{px, pz, nx, nz};
            }
        };
        int index = -1;
        for (i = 0; i < face.length; ++i) {
            vFace = face[i];
            BlockHitResult lineOfSightToCursor = this.level.clip(new ClipContext(vFace, this.cursor, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
            boolean noLineOfSight = HitResult.Type.BLOCK.equals((Object)lineOfSightToCursor.getType());
            if (noLineOfSight || this.doesCollide(vFace)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            i = index;
            do {
                BlockHitResult clip;
                boolean hasLinOfSight;
                vFace = face[i];
                Vec3 vPair = pair[i];
                if (this.doesCollide(vFace)) continue;
                BlockHitResult lineOfSightToCursor = this.level.clip(new ClipContext(vFace, this.cursor, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
                boolean bl = hasLinOfSight = !HitResult.Type.BLOCK.equals((Object)lineOfSightToCursor.getType());
                if (!hasLinOfSight || !HitResult.Type.BLOCK.equals((Object)(clip = this.level.clip(new ClipContext(vFace, vPair, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()))).getType())) continue;
                Vec3 location = clip.getLocation();
                Vec3 offset = location.subtract(vPair);
                if (!(Math.abs(offset.x) + Math.abs(offset.y) + Math.abs(offset.z) > 0.001)) continue;
                for (int j = 0; j < face.length; ++j) {
                    face[j] = face[j].add(offset);
                    pair[j] = pair[j].add(offset);
                }
                aabb = aabb.move(offset);
            } while ((i = (i + 1) % face.length) != index);
        }
        AABB start = aabb.move(0.0, 1.0, 0.0);
        AABB zone = start.expandTowards(0.0, -1.0, 0.0);
        Iterable iterable = this.level.getCollisions(null, zone);
        double yOff = 1.0 + Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)start, (Iterable)iterable, (double)-1.0);
        this.box = aabb = aabb.move(0.0, yOff, 0.0);
        this.updateCords();
    }

    private boolean doesCollide(Vec3 v) {
        Vec3 offs = new Vec3(0.1, 0.1, 0.1);
        Iterable blockCollisions = this.level.getBlockCollisions(null, new AABB(v.add(offs), v.subtract(offs)));
        for (VoxelShape collision : blockCollisions) {
            for (AABB ab : collision.toAabbs()) {
                boolean contains = v.x >= ab.minX && v.x <= ab.maxX && v.y >= ab.minY && v.y <= ab.maxY && v.z >= ab.minZ && v.z <= ab.maxZ;
                if (!contains) continue;
                return true;
            }
        }
        return false;
    }

    public void pushClippedPoints() {
        this.pointer = 0;
        while (this.pointer < 4) {
            Vec3 tl = this.clipped[this.pointer];
            Vec3 tr = this.clipped[(this.pointer + 1) % 4];
            Vec3 bl = this.clipped[(this.pointer + 3) % 4];
            boolean doesCollide = this.doesCollide(tl);
            if (!doesCollide) {
                BlockHitResult clip2 = this.level.clip(new ClipContext(tl, tr, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
                BlockHitResult clip0 = this.level.clip(new ClipContext(tl, bl, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
                boolean clip2Missed = HitResult.Type.MISS.equals((Object)clip2.getType());
                boolean clip0Missed = HitResult.Type.MISS.equals((Object)clip0.getType());
                if (!clip2Missed || !clip0Missed) {
                    Vec3 offset;
                    if (!clip2Missed && !clip0Missed) {
                        Vec3 zeroed2 = clip2.getLocation().subtract(tl);
                        Vec3 zeroed0 = clip0.getLocation().subtract(tl);
                        Vec3 zeroed = zeroed2.add(zeroed0);
                        double absZ = Math.abs(zeroed.z);
                        double absX = Math.abs(zeroed.x);
                        offset = this.direction.getAxis().isVertical() ? (absX < absZ ? new Vec3(zeroed.x, 0.0, 0.0) : new Vec3(0.0, 0.0, zeroed.z)) : (Math.max(absZ, absX) < Math.abs(zeroed.y) ? new Vec3(zeroed.x, 0.0, zeroed.z) : new Vec3(0.0, zeroed.y, 0.0));
                    } else {
                        BlockHitResult clip = clip2Missed ? clip0 : clip2;
                        offset = clip.getLocation().subtract(tl);
                    }
                    if (!(Math.abs(offset.x) + Math.abs(offset.y) + Math.abs(offset.z) < 0.001)) {
                        this.move(offset);
                    }
                }
            }
            ++this.pointer;
        }
    }

    void move(Vec3 offset) {
        this.box = this.box.move(offset);
        this.updateCords();
    }

    public void pushHangingPoints() {
        Vec3 br;
        int success = 0;
        Vec3[] list = new Vec3[]{null, null, null, null};
        int count = 0;
        this.pointer = 0;
        while (this.pointer < 4) {
            BlockHitResult clip2;
            br = this.hanging[(this.pointer + 2) % 4];
            if (!this.doesCollide(br) && (clip2 = this.level.clip(new ClipContext(br, this.cursor, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()))).getType().equals((Object)HitResult.Type.MISS)) {
                list[this.pointer] = br;
                ++count;
            }
            ++this.pointer;
        }
        if (count == 3) {
            this.pointer = 0;
            while (this.pointer < 4) {
                br = list[this.pointer];
                if (br != null) {
                    Vec3 tl = this.hanging[this.pointer];
                    Vec3 tr = this.hanging[(this.pointer + 1) % 4];
                    Vec3 bl = this.hanging[(this.pointer + 3) % 4];
                    BlockHitResult clipR = this.level.clip(new ClipContext(tr, tl, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
                    Vec3 contactR = clipR.getLocation();
                    BlockHitResult clipL = this.level.clip(new ClipContext(bl, tl, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
                    Vec3 contactL = clipL.getLocation();
                    Vec3 offsR = tl.subtract(contactR).multiply(-1.0, -1.0, -1.0);
                    Vec3 offsL = tl.subtract(contactL).multiply(-1.0, -1.0, -1.0);
                    Vec3 zeroed = offsR.add(offsL);
                    double absZ = Math.abs(zeroed.z);
                    double absX = Math.abs(zeroed.x);
                    Vec3 offs = this.direction.getAxis().isVertical() ? (absX < absZ ? new Vec3(zeroed.x, 0.0, 0.0) : new Vec3(0.0, 0.0, zeroed.z)) : (Math.max(absZ, absX) < Math.abs(zeroed.y) ? new Vec3(zeroed.x, 0.0, zeroed.z) : new Vec3(0.0, zeroed.y, 0.0));
                    this.move(offs);
                }
                ++this.pointer;
            }
        } else {
            this.pointer = 0;
            while (this.pointer < 4 && success < 2) {
                br = list[this.pointer];
                if (br != null) {
                    Vec3 offs;
                    Vec3 contact;
                    BlockHitResult clip2;
                    Vec3 tr = this.hanging[(this.pointer + 1) % 4];
                    Vec3 bl = this.hanging[(this.pointer + 3) % 4];
                    int steps = 0;
                    Vec3 offset = Vec3.ZERO;
                    if (this.doesCollide(tr)) {
                        clip2 = this.level.clip(new ClipContext(br, tr, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
                        contact = clip2.getLocation();
                        offs = tr.subtract(contact).multiply(-1.0, -1.0, -1.0);
                        offset = offset.add(offs);
                        ++steps;
                    }
                    if (this.doesCollide(bl)) {
                        clip2 = this.level.clip(new ClipContext(br, bl, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
                        contact = clip2.getLocation();
                        offs = bl.subtract(contact).multiply(-1.0, -1.0, -1.0);
                        offset = offset.add(offs);
                        ++steps;
                    }
                    if (Vec3.ZERO != offset) {
                        this.move(offset);
                        success += steps;
                    }
                }
                ++this.pointer;
            }
        }
    }
}

