/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util;

import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ComponentHolder {
    public static ComponentHolder of(Slot slot) {
        return new SlotTraitHolder(slot);
    }

    public static ComponentHolder of(ItemStack stack) {
        return new ItemStackTraitHolder(stack);
    }

    public static ComponentHolder of(ItemStack stack, Player player) {
        return new StackReturningTraitHolder(stack, player);
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> var1);

    public <T> void set(DataComponentType<? super T> var1, T var2);

    @Nullable
    public <T> T get(DataComponentType<? extends T> var1);

    default public boolean has(DataComponentType<?> type) {
        return this.get(type) != null;
    }

    default public void setChanged() {
    }

    @NotNull
    default public <T> T getOrElse(DataComponentType<? extends T> type, Supplier<T> orElse) {
        T t = this.get(type);
        return t == null ? orElse.get() : t;
    }

    default public <T> T getOrDefault(DataComponentType<T> type, T defau) {
        T t = this.get(type);
        if (t == null) {
            return defau;
        }
        return t;
    }

    public static class SlotTraitHolder
    implements ComponentHolder {
        private final Slot slot;

        public SlotTraitHolder(Slot slot) {
            this.slot = slot;
        }

        @Override
        @Nullable
        public <T> T remove(DataComponentType<? extends T> type) {
            return (T)this.slot.getItem().remove(type);
        }

        @Override
        public <T> void set(DataComponentType<? super T> type, T trait) {
            this.slot.getItem().set(type, trait);
        }

        @Override
        @Nullable
        public <T> T get(DataComponentType<? extends T> type) {
            return (T)this.slot.getItem().get(type);
        }
    }

    public static class ItemStackTraitHolder
    implements ComponentHolder {
        private final ItemStack stack;

        private ItemStackTraitHolder(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public <T> T remove(DataComponentType<? extends T> type) {
            return (T)this.stack.remove(type);
        }

        @Override
        public <T> void set(DataComponentType<? super T> type, T trait) {
            this.stack.set(type, trait);
        }

        @Override
        public <T> T get(DataComponentType<? extends T> type) {
            return (T)this.stack.get(type);
        }
    }

    public static class StackReturningTraitHolder
    implements ComponentHolder {
        private final ItemStack stack;
        private final Player player;

        public StackReturningTraitHolder(ItemStack stack, Player player) {
            this.stack = stack;
            this.player = player;
        }

        @Override
        @Nullable
        public <T> T remove(DataComponentType<? extends T> type) {
            int count = this.stack.getCount();
            if (count > 1) {
                ItemStack copy = this.stack.copyWithCount(1);
                Object remove = copy.remove(type);
                if (remove == null) {
                    return null;
                }
                this.player.addItem(copy);
                this.stack.shrink(1);
                return (T)remove;
            }
            return (T)this.stack.remove(type);
        }

        @Override
        public <T> void set(DataComponentType<? super T> type, T data) {
            int count = this.stack.getCount();
            if (count > 1) {
                ItemStack copy = this.stack.copyWithCount(1);
                copy.set(type, data);
                this.player.addItem(copy);
                this.stack.shrink(1);
            } else {
                this.stack.set(type, data);
            }
        }

        @Override
        public <T> T get(DataComponentType<? extends T> pComponent) {
            return (T)this.stack.get(pComponent);
        }
    }
}

