/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.platform.Services;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public enum ModSound implements StringRepresentable
{
    HARD(0),
    SOFT(1),
    VWOOMP(2),
    CRUNCH(3),
    CLAY(4);

    private final byte i;
    public static Codec<ModSound> CODEC;
    public static final MapCodec<ModSound> MAP_CODEC;
    public static StreamCodec<? super ByteBuf, ModSound> STREAM_CODEC;

    private ModSound(int i) {
        this.i = (byte)i;
    }

    public SoundEvent get(Type type) {
        return ModSound.get(this, type);
    }

    public static SoundEvent get(ModSound sound, Type type) {
        switch (sound.ordinal()) {
            case 1: {
                switch (type.ordinal()) {
                    case 1: {
                        return Events.LEATHER_PLACE.get();
                    }
                    case 0: {
                        return Events.LEATHER_EQUIP.get();
                    }
                    case 2: {
                        return Events.LEATHER_HIT.get();
                    }
                    case 3: {
                        return Events.LEATHER_BREAK.get();
                    }
                    case 4: {
                        return Events.LEATHER_INSERT.get();
                    }
                    case 5: {
                        return Events.LEATHER_TAKE.get();
                    }
                    case 6: {
                        return Events.LEATHER_OPEN.get();
                    }
                    case 7: {
                        return Events.LEATHER_CLOSE.get();
                    }
                }
                break;
            }
            case 0: {
                switch (type.ordinal()) {
                    case 1: {
                        return Events.METAL_PLACE.get();
                    }
                    case 0: {
                        return Events.METAL_EQUIP.get();
                    }
                    case 2: {
                        return Events.METAL_HIT.get();
                    }
                    case 3: {
                        return Events.METAL_BREAK.get();
                    }
                    case 4: {
                        return Events.METAL_INSERT.get();
                    }
                    case 5: {
                        return Events.METAL_TAKE.get();
                    }
                    case 6: {
                        return Events.METAL_OPEN.get();
                    }
                    case 7: {
                        return Events.METAL_CLOSE.get();
                    }
                }
                break;
            }
            case 2: {
                switch (type.ordinal()) {
                    case 1: {
                        return Events.ENDER_PLACE.get();
                    }
                    case 0: {
                        return Events.ENDER_EQUIP.get();
                    }
                    case 2: {
                        return Events.ENDER_HIT.get();
                    }
                    case 3: {
                        return Events.ENDER_BREAK.get();
                    }
                    case 6: {
                        return Events.ENDER_OPEN.get();
                    }
                    case 7: {
                        return Events.ENDER_CLOSE.get();
                    }
                    case 5: {
                        return Events.ENDER_TAKE.get();
                    }
                    case 4: {
                        return Events.ENDER_INSERT.get();
                    }
                }
                break;
            }
            case 3: {
                switch (type.ordinal()) {
                    case 1: {
                        return Events.WINGED_PLACE.get();
                    }
                    case 0: {
                        return Events.WINGED_EQUIP.get();
                    }
                    case 2: {
                        return Events.WINGED_HIT.get();
                    }
                    case 3: {
                        return Events.WINGED_BREAK.get();
                    }
                    case 4: {
                        return Events.LEATHER_INSERT.get();
                    }
                    case 5: {
                        return Events.LEATHER_TAKE.get();
                    }
                    case 6: {
                        return Events.WINGED_OPEN.get();
                    }
                    case 7: {
                        return Events.WINGED_CLOSE.get();
                    }
                }
                break;
            }
            case 4: {
                switch (type.ordinal()) {
                    case 2: {
                        return Events.POT_HIT.get();
                    }
                    case 4: {
                        return Events.POT_INSERT.get();
                    }
                    case 5: {
                        return Events.POT_TAKE.get();
                    }
                }
            }
        }
        return type.defau;
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    public void at(Entity entity, Type type, float volume, float pitch) {
        entity.playSound(this.get(type), volume, pitch);
    }

    public void at(Entity entity, Type type) {
        this.at(entity, type, 1.0f, 1.0f);
    }

    public void atClient(Player player, Type type, float volume, float pitch) {
        if (player.level().isClientSide) {
            CommonClient.playSound(this.get(type), volume, pitch);
        }
    }

    public void toClient(Player player, Type type, float volume, float pitch) {
        if (!player.level().isClientSide) {
            player.playNotifySound(this.get(type), SoundSource.PLAYERS, volume, pitch);
        }
    }

    public void atClient(Player player, Type type) {
        this.atClient(player, type, 1.0f, 1.0f);
    }

    static {
        CODEC = new StringRepresentable.StringRepresentableCodec((StringRepresentable[])ModSound.values(), in -> {
            for (ModSound value : ModSound.values()) {
                if (!value.getSerializedName().equals(in)) continue;
                return value;
            }
            return HARD;
        }, Enum::ordinal);
        MAP_CODEC = CODEC.fieldOf("sound").orElse((Object)SOFT);
        STREAM_CODEC = ByteBufCodecs.BYTE.map(in -> {
            for (ModSound value : ModSound.values()) {
                if (value.i != in) continue;
                return value;
            }
            return HARD;
        }, in -> in.i);
    }

    public static enum Type {
        EQUIP((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value()),
        PLACE(SoundEvents.ITEM_FRAME_PLACE),
        HIT(SoundEvents.PLAYER_ATTACK_WEAK),
        BREAK(SoundEvents.PLAYER_ATTACK_CRIT),
        INSERT(SoundEvents.BUNDLE_INSERT),
        REMOVE(SoundEvents.BUNDLE_REMOVE_ONE),
        OPEN(SoundEvents.CHEST_OPEN),
        CLOSE(SoundEvents.CHEST_CLOSE);

        private final SoundEvent defau;

        private Type(SoundEvent defau) {
            this.defau = defau;
        }
    }

    public static enum Events {
        LEATHER_PLACE("leather_place"),
        LEATHER_EQUIP("leather_equip"),
        LEATHER_HIT("leather_hit"),
        LEATHER_BREAK("leather_break"),
        LEATHER_INSERT("leather_insert"),
        LEATHER_TAKE("leather_take"),
        LEATHER_OPEN("leather_open"),
        LEATHER_CLOSE("leather_close"),
        METAL_PLACE("metal_place"),
        METAL_EQUIP("metal_equip"),
        METAL_HIT("metal_hit"),
        METAL_BREAK("metal_break"),
        METAL_INSERT("metal_insert"),
        METAL_TAKE("metal_take"),
        METAL_OPEN("metal_open"),
        METAL_CLOSE("metal_close"),
        ENDER_PLACE("ender_place"),
        ENDER_EQUIP("ender_equip"),
        ENDER_HIT("ender_hit"),
        ENDER_BREAK("ender_break"),
        ENDER_INSERT("ender_insert"),
        ENDER_TAKE("ender_take"),
        ENDER_OPEN("ender_open"),
        ENDER_CLOSE("ender_close"),
        WINGED_PLACE("winged_place"),
        WINGED_EQUIP("winged_equip"),
        WINGED_HIT("winged_hit"),
        WINGED_BREAK("winged_break"),
        WINGED_OPEN("winged_open"),
        WINGED_CLOSE("winged_close"),
        POT_HIT("pot_hit"),
        POT_INSERT("pot_insert"),
        POT_TAKE("pot_take"),
        LOCK("lock_backpack"),
        UNLOCK("unlock_backpack");

        public final SoundEvent event;

        private Events(String id) {
            ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)id);
            SoundEvent event = SoundEvent.createVariableRangeEvent((ResourceLocation)location);
            this.event = Services.PLATFORM.register(id, event);
        }

        public SoundEvent get() {
            return this.event;
        }

        private Playable playable(float volume, float pitch) {
            return new Playable(this.get(), volume, pitch);
        }

        public static void register() {
        }

        public record Playable(SoundEvent event, float volume, float pitch) {
        }
    }
}

