/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util;

import com.beansgalaxy.backpacks.components.SlotSelection;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SlotSelectorData {
    private final ComponentHolder holder;
    private final Supplier<List<ItemStack>> getItemStacks;
    private SlotSelection value;
    private boolean isDirty;

    public SlotSelectorData(ComponentHolder holder, Supplier<List<ItemStack>> getItemStacks) {
        this.holder = holder;
        this.value = holder.get(ITraitData.SLOT_SELECTION);
        this.getItemStacks = getItemStacks;
    }

    public int getSelectedSlot(Player player) {
        return this.get().get(player);
    }

    public void growSelectedSlot(int slot) {
        this.markDirty();
        this.get().grow(slot);
    }

    public void limitSelectedSlot(int index, int size) {
        this.markDirty();
        this.get().limit(index, size);
    }

    public void setSelectedSlot(Player player, int slot) {
        this.markDirty();
        this.get().set(player, slot);
    }

    public boolean isEmpty(SlotSelection data) {
        List<ItemStack> stacks = this.getItemStacks.get();
        return stacks == null || stacks.isEmpty();
    }

    public SlotSelection get() {
        if (this.value == null) {
            this.markDirty();
            this.value = new SlotSelection();
        }
        return this.value;
    }

    private void markDirty() {
        this.isDirty = true;
    }

    public void push() {
        List<ItemStack> stacks = this.getItemStacks.get();
        if (stacks == null || stacks.size() <= 1) {
            this.holder.remove(ITraitData.SLOT_SELECTION);
        } else if (this.isDirty) {
            int size = stacks.size();
            if (this.value != null) {
                this.value.ceil(size - 1);
            }
            this.holder.set(ITraitData.SLOT_SELECTION, this.value);
        }
    }
}

