/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class SplitText {
    private final FormattedCharSequence sequence;
    private final List<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
    private ImmutableList.Builder<Sink> current = ImmutableList.builder();
    FormattedCharSequence SPACE = FormattedCharSequence.forward((String)" ", (Style)Style.EMPTY);

    public SplitText(FormattedCharSequence sequence) {
        this.sequence = sequence;
    }

    public List<FormattedCharSequence> split() {
        this.sequence.accept((pPositionInCurrentSequence, pStyle, pCodePoint) -> {
            if (Character.isWhitespace(pCodePoint)) {
                this.dump();
            } else {
                this.current.add((Object)new Sink(pStyle, pCodePoint));
            }
            return true;
        });
        this.buildCurrent(this.lines::add);
        return this.lines;
    }

    private void dump() {
        this.buildCurrent(this.lines::add);
        this.current = ImmutableList.builder();
    }

    private void buildCurrent(Consumer<FormattedCharSequence> addText) {
        ImmutableList build = this.current.build();
        if (build.isEmpty() || this.onlyWhiteSpace((ImmutableList<Sink>)build)) {
            return;
        }
        FormattedCharSequence formatted = charSink -> {
            for (int i = 0; i < build.size(); ++i) {
                Sink sink = (Sink)build.get(i);
                if (charSink.accept(i, sink.style, sink.code)) continue;
                return false;
            }
            return true;
        };
        addText.accept(formatted);
    }

    private boolean onlyWhiteSpace(ImmutableList<Sink> build) {
        for (Sink sink : build) {
            if (Character.isWhitespace(sink.code)) continue;
            return false;
        }
        return true;
    }

    public int noCropWidth(Font font, int width, List<FormattedCharSequence> list) {
        if (this.lines.isEmpty()) {
            return width;
        }
        int size = this.lines.size();
        if (size > 2) {
            return this.smartArrange(font, width, list);
        }
        FormattedCharSequence sequence = size == 1 ? this.lines.getFirst() : FormattedCharSequence.composite((FormattedCharSequence[])new FormattedCharSequence[]{this.lines.get(0), this.SPACE, this.lines.get(1)});
        list.add(sequence);
        int fWidth = font.width(sequence);
        return Math.max(fWidth, width);
    }

    private int simpleArrange(Font font, int width, List<FormattedCharSequence> list) {
        FormattedCharSequence currentLine = this.lines.getFirst();
        for (int i = 1; i < this.lines.size(); ++i) {
            FormattedCharSequence line = this.lines.get(i);
            FormattedCharSequence[] formattedCharSequenceArray = new FormattedCharSequence[]{currentLine, this.SPACE, line};
            FormattedCharSequence pair = FormattedCharSequence.composite((FormattedCharSequence[])formattedCharSequenceArray);
            int pairWidth = font.width(pair);
            if ((double)pairWidth > (double)width * 1.2) {
                int currentWidth = font.width(currentLine);
                if (currentWidth > width) {
                    width = currentWidth;
                }
                list.add(currentLine);
                currentLine = line;
                continue;
            }
            currentLine = pair;
        }
        int currentWidth = font.width(currentLine);
        if (currentWidth > width) {
            width = currentWidth;
        }
        list.add(currentLine);
        return width;
    }

    private int smartArrange(Font font, int width, List<FormattedCharSequence> list) {
        int max = this.lines.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().orElse(0);
        int newWidth = Math.max(width, max);
        int sWidth = font.width(this.SPACE) / 2;
        Iterator iterator = Lists.reverse(this.lines).iterator();
        ArrayList aggressive = Lists.newArrayList((Object[])new FormattedCharSequence[]{(FormattedCharSequence)iterator.next()});
        FormattedCharSequence current = (FormattedCharSequence)iterator.next();
        FormattedCharSequence next = (FormattedCharSequence)iterator.next();
        while (!FormattedCharSequence.EMPTY.equals((Object)current)) {
            FormattedCharSequence pair;
            int c;
            int nWidth = font.width(next);
            int cWidth = font.width(current);
            int lWidth = font.width((FormattedCharSequence)aggressive.getFirst());
            int nextWidth = nWidth + sWidth + cWidth;
            int lastWidth = lWidth + sWidth + cWidth;
            int target = (nextWidth + lastWidth + cWidth + newWidth) / 4;
            int n = Math.abs(nextWidth - target);
            int l = Math.abs(lastWidth - target) - 7;
            int min = Math.min(l, Math.min(c = Math.abs(cWidth - target), n));
            if (min == l) {
                pair = FormattedCharSequence.composite((FormattedCharSequence[])new FormattedCharSequence[]{current, this.SPACE, (FormattedCharSequence)aggressive.getFirst()});
                aggressive.set(0, pair);
                current = next;
                next = iterator.hasNext() ? (FormattedCharSequence)iterator.next() : FormattedCharSequence.EMPTY;
                continue;
            }
            if (min == n) {
                if (FormattedCharSequence.EMPTY.equals((Object)next)) {
                    aggressive.add(current);
                    break;
                }
                pair = FormattedCharSequence.composite((FormattedCharSequence[])new FormattedCharSequence[]{next, this.SPACE, current});
                aggressive.add(pair);
                if (!iterator.hasNext()) break;
                current = (FormattedCharSequence)iterator.next();
                next = iterator.hasNext() ? (FormattedCharSequence)iterator.next() : FormattedCharSequence.EMPTY;
                continue;
            }
            aggressive.set(0, current);
            current = next;
            next = iterator.hasNext() ? (FormattedCharSequence)iterator.next() : FormattedCharSequence.EMPTY;
        }
        int maxWidth = newWidth;
        for (int i = aggressive.size() - 1; i >= 0; --i) {
            FormattedCharSequence sequence = (FormattedCharSequence)aggressive.get(i);
            int seqWidth = font.width(sequence);
            if (seqWidth > maxWidth) {
                maxWidth = seqWidth;
            }
            list.add(sequence);
        }
        return maxWidth;
    }

    private int aggressiveArrange(Font font, int width, List<FormattedCharSequence> list) {
        int i;
        int max = this.lines.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().orElse(0);
        int newWidth = Math.max(width, max);
        ArrayList<FormattedCharSequence> aggressive = new ArrayList<FormattedCharSequence>();
        FormattedCharSequence currentLine = this.lines.getLast();
        for (i = this.lines.size() - 2; i >= 0; --i) {
            FormattedCharSequence line = this.lines.get(i);
            FormattedCharSequence pair = FormattedCharSequence.composite((FormattedCharSequence[])new FormattedCharSequence[]{line, this.SPACE, currentLine});
            int pairWidth = font.width(pair);
            if (pairWidth < newWidth) {
                currentLine = pair;
                continue;
            }
            newWidth = pairWidth;
            aggressive.add(pair);
            if (--i < 0) {
                currentLine = null;
                break;
            }
            currentLine = this.lines.get(i);
        }
        if (currentLine != null) {
            int currentWidth = font.width(currentLine);
            if (currentWidth > newWidth) {
                newWidth = currentWidth;
            }
            aggressive.add(currentLine);
        }
        for (i = aggressive.size() - 1; i >= 0; --i) {
            list.add((FormattedCharSequence)aggressive.get(i));
        }
        return newWidth;
    }

    private record Sink(Style style, int code) {
    }
}

