/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util;

import java.util.function.UnaryOperator;
import net.minecraft.util.Mth;

public class Tint {
    private int rgba;

    public Tint(int rgb) {
        this.rgba = rgb | 0xFF000000;
    }

    public Tint(int rgba, boolean hasAlpha) {
        this.rgba = rgba;
    }

    public HSV HSV() {
        return new HSV(this);
    }

    public HSL HSL() {
        return new HSL(this);
    }

    public void setRGBA(int rgba) {
        this.rgba = rgba;
    }

    private void setRGB(double r, double g, double b) {
        this.rgba = (Mth.floor((double)(r * 255.0)) & 0xFF) << 16 | (Mth.floor((double)(g * 255.0)) & 0xFF) << 8 | Mth.floor((double)(b * 255.0)) & 0xFF;
    }

    private int setRGB(int r, int g, int b) {
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    private int setRGB(double r, double g, double b, double a) {
        return (Mth.floor((double)(a * 255.0)) & 0xFF) << 24 | (Mth.floor((double)(r * 255.0)) & 0xFF) << 16 | (Mth.floor((double)(g * 255.0)) & 0xFF) << 8 | Mth.floor((double)(b * 255.0)) & 0xFF;
    }

    private int setRGB(float r, float g, float b, float a) {
        return (Mth.floor((float)(a * 255.0f)) & 0xFF) << 24 | (Mth.floor((float)(r * 255.0f)) & 0xFF) << 16 | (Mth.floor((float)(g * 255.0f)) & 0xFF) << 8 | Mth.floor((float)(b * 255.0f)) & 0xFF;
    }

    public int getRGBA() {
        return this.rgba;
    }

    public Tint setAlpha(byte a) {
        this.rgba = ~a << 16 ^ (this.rgba | 0xFF0000);
        return this;
    }

    public Tint setAlpha(float a) {
        this.rgba |= Mth.floor((float)(a * 255.0f)) << 24;
        return this;
    }

    public double brightness() {
        double r = Math.pow((double)this.getRed() / 255.0, 2.2);
        double b = Math.pow((double)this.getBlue() / 255.0, 4.0);
        double g = Math.pow((double)this.getGreen() / 255.0, 2.2);
        double y = r * 0.2126 + g * 0.7152 + b * 0.0722;
        return y;
    }

    public void modRGB(UnaryOperator<Integer> r, UnaryOperator<Integer> g, UnaryOperator<Integer> b) {
        this.rgba = this.setRGB((Integer)r.apply(this.getRed()), (Integer)g.apply(this.getGreen()), (Integer)b.apply(this.getBlue()));
    }

    private void setRGB(int rgba) {
        this.rgba = rgba;
    }

    public float[] getFloats() {
        float r = (float)(this.rgba >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.rgba >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.rgba & 0xFF) / 255.0f;
        float a = (float)(this.rgba >> 24 & 0xFF) / 255.0f;
        return new float[]{r, g, b, a};
    }

    public int getRed() {
        return this.rgba >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.rgba >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.rgba & 0xFF;
    }

    public int getAlpha() {
        return this.rgba >> 24 & 0xFF;
    }

    public String toString() {
        return "RGBA:[" + this.getRed() + ", " + this.getBlue() + ", " + this.getGreen() + ", " + this.getAlpha() + "]";
    }

    public class HSV {
        private final Tint hsv;
        private double hue;
        private double val;
        private double sat;

        private HSV(Tint hsv) {
            this.hsv = hsv;
            int color = this.hsv.rgba;
            double r = (float)(color >> 16 & 0xFF) / 255.0f;
            double g = (float)(color >> 8 & 0xFF) / 255.0f;
            double b = (float)(color & 0xFF) / 255.0f;
            double cmax = Math.max(r, Math.max(g, b));
            double cmin = Math.min(r, Math.min(g, b));
            double diff = cmax - cmin;
            double h = -1.0;
            if (cmax == cmin) {
                h = 0.0;
            } else if (cmax == r) {
                h = (60.0 * ((g - b) / diff) + 360.0) % 360.0;
            } else if (cmax == g) {
                h = (60.0 * ((b - r) / diff) + 120.0) % 360.0;
            } else if (cmax == b) {
                h = (60.0 * ((r - g) / diff) + 240.0) % 360.0;
            }
            double s = cmax == 0.0 ? 0.0 : diff / cmax;
            this.hue = h;
            this.sat = s;
            this.val = cmax;
        }

        public double getHue() {
            return this.hue;
        }

        public HSV setHue(double hue) {
            this.hue = hue;
            return this;
        }

        public HSV rotate(double degrees) {
            this.hue = (degrees + this.hue) % 360.0;
            return this;
        }

        public double getSat() {
            return this.sat;
        }

        public HSV setSat(double sat) {
            this.sat = Mth.clamp((double)sat, (double)0.0, (double)1.0);
            return this;
        }

        public HSV scaleSat(double scale) {
            this.sat *= Mth.clamp((double)scale, (double)0.0, (double)1.0);
            return this;
        }

        public double getVal() {
            return this.val;
        }

        public HSV setVal(double value) {
            this.val = Mth.clamp((double)value, (double)0.0, (double)1.0);
            return this;
        }

        public HSV scaleVal(double scale) {
            this.val *= Mth.clamp((double)scale, (double)0.0, (double)1.0);
            return this;
        }

        public int rgb() {
            double h = this.hue / 360.0;
            double s = this.sat;
            double v = this.val;
            int i = Mth.floor((double)(h * 6.0));
            double f = h * 6.0 - (double)i;
            double p = v * (1.0 - s);
            double q = v * (1.0 - f * s);
            double t = v * (1.0 - (1.0 - f) * s);
            return switch (i) {
                case 0 -> Tint.this.setRGB(v, t, p, 1.0);
                case 1 -> Tint.this.setRGB(q, v, p, 1.0);
                case 2 -> Tint.this.setRGB(p, v, t, 1.0);
                case 3 -> Tint.this.setRGB(p, q, v, 1.0);
                case 4 -> Tint.this.setRGB(t, p, v, 1.0);
                case 5 -> Tint.this.setRGB(v, p, q, 1.0);
                default -> throw new RuntimeException("Something went wrong when converting from HSV to RGB. Input was " + this.hue + ", " + this.sat + ", " + this.val);
            };
        }

        public void push() {
            this.hsv.setRGB(this.rgb());
        }

        public String toString() {
            return "HSV:[" + this.hue + ", " + this.sat + ", " + this.val + "]";
        }
    }

    public class HSL {
        private final Tint tint;
        private double hue;
        private double lum;
        private double sat;

        private HSL(Tint tint) {
            this.tint = tint;
            int color = this.tint.rgba;
            double r = (float)(color >> 16 & 0xFF) / 255.0f;
            double g = (float)(color >> 8 & 0xFF) / 255.0f;
            double b = (float)(color & 0xFF) / 255.0f;
            double max = Math.max(Math.max(r, g), b);
            double min = Math.min(Math.min(r, g), b);
            double c = max - min;
            double h_ = 0.0;
            if (c == 0.0) {
                h_ = 0.0;
            } else if (max == r) {
                h_ = (g - b) / c;
                if (h_ < 0.0) {
                    h_ += 6.0;
                }
            } else if (max == g) {
                h_ = (b - r) / c + 2.0;
            } else if (max == b) {
                h_ = (r - g) / c + 4.0;
            }
            double h = 60.0 * h_;
            double l = (max + min) * 0.5;
            double s = c == 0.0 ? 0.0 : c / (1.0 - Math.abs(2.0 * l - 1.0));
            this.hue = h;
            this.sat = s;
            this.lum = l;
        }

        public double getHue() {
            return this.hue;
        }

        public HSL setHue(double hue) {
            this.hue = hue;
            return this;
        }

        public HSL rotate(double degrees) {
            this.hue = (degrees + this.hue) % 360.0;
            return this;
        }

        public double getSat() {
            return this.sat;
        }

        public HSL setSat(double sat) {
            this.sat = Mth.clamp((double)sat, (double)0.0, (double)1.0);
            return this;
        }

        public HSL scaleSat(double scale) {
            this.sat *= Mth.clamp((double)scale, (double)0.0, (double)1.0);
            return this;
        }

        public double getLum() {
            return this.lum;
        }

        public HSL setLum(double value) {
            this.lum = Mth.clamp((double)value, (double)0.0, (double)1.0);
            return this;
        }

        public HSL scaleVal(double scale) {
            this.lum *= Mth.clamp((double)scale, (double)0.0, (double)1.0);
            return this;
        }

        public int rgb() {
            double h = this.hue;
            double s = this.sat;
            double l = this.lum;
            double c = (1.0 - Math.abs(2.0 * l - 1.0)) * s;
            double h_ = h / 60.0;
            double h_mod2 = h_;
            if (h_mod2 >= 4.0) {
                h_mod2 -= 4.0;
            } else if (h_mod2 >= 2.0) {
                h_mod2 -= 2.0;
            }
            double x = c * (1.0 - Math.abs(h_mod2 - 1.0));
            int i = Mth.floor((double)h_);
            double m = l - 0.5 * c;
            c += m;
            x += m;
            return switch (i) {
                case 0 -> Tint.this.setRGB(c, x, m, 1.0);
                case 1 -> Tint.this.setRGB(x, c, m, 1.0);
                case 2 -> Tint.this.setRGB(m, c, x, 1.0);
                case 3 -> Tint.this.setRGB(m, x, c, 1.0);
                case 4 -> Tint.this.setRGB(x, m, c, 1.0);
                default -> Tint.this.setRGB(c, m, x, 1.0);
            };
        }

        public void push() {
            this.tint.setRGB(this.rgb());
        }

        public Tint pushToNew() {
            return new Tint(this.rgb()).setAlpha((float)this.tint.getAlpha() / 255.0f);
        }

        public String toString() {
            return "HSL:[" + this.hue + ", " + this.sat + ", " + this.lum + "]";
        }

        public void modLum(UnaryOperator<Double> mod) {
            this.lum = (Double)mod.apply(this.lum);
        }

        public void modHue(UnaryOperator<Double> mod) {
            this.hue = (Double)mod.apply(this.hue);
        }
    }

    public class LCH {
        private double l = 0.0;
        private double a = 0.0;
        private double b = 0.0;

        double linear(int x) {
            if ((double)x >= 0.0031308) {
                return 1.055 * Math.pow(x, 0.4166666666666667) - 0.055;
            }
            return 12.92 * (double)x;
        }

        double non_linear(double x) {
            if (x >= 0.04045) {
                return Math.pow((x + 0.055) / 1.055, 2.4);
            }
            return x / (double)12.92f;
        }

        private LCH() {
            double r = this.linear(Tint.this.rgba >> 16 & 0xFF);
            double g = this.linear(Tint.this.rgba >> 8 & 0xFF);
            double b = this.linear(Tint.this.rgba & 0xFF);
            double l = 0.4122214615345001 * r + 0.5363325476646423 * g + 0.05144599452614784 * b;
            double m = (double)0.2119035f * r + 0.6806995272636414 * g + 0.10739696025848389 * b;
            double s = 0.08830246329307556 * r + 0.2817188501358032 * g + 0.6299787163734436 * b;
            double l_ = Math.cbrt(l);
            double m_ = Math.cbrt(m);
            double s_ = Math.cbrt(s);
            this.l = 0.21045425534248352 * l_ + 0.7936177849769592 * m_ - 0.004072046838700771 * s_;
            this.a = 1.9779984951019287 * l_ - 2.4285922050476074 * m_ + 0.4505937099456787 * s_;
            this.b = 0.025904037058353424 * l_ + 0.7827717661857605 * m_ - 0.8086757659912109 * s_;
        }

        public int rgb() {
            double l_ = this.l + 0.3963377773761749 * this.a + 0.21580375730991364 * this.b;
            double m_ = this.l - 0.10556134581565857 * this.a - 0.0638541728258133 * this.b;
            double s_ = this.l - 0.08948417752981186 * this.a - 1.2914855480194092 * this.b;
            double l = l_ * l_ * l_;
            double m = m_ * m_ * m_;
            double s = s_ * s_ * s_;
            int r = (int)(this.non_linear(4.076741695404053 * l - 3.307711601257324 * m + 0.23096993565559387 * s) * 255.0);
            int g = (int)(this.non_linear((double)-1.268438f * l + 2.609757423400879 * m - 0.34131938219070435 * s) * 255.0);
            int b = (int)(this.non_linear(-0.004196086432784796 * l - 0.7034186124801636 * m + 1.7076146602630615 * s) * 255.0);
            return Tint.this.setRGB(r, g, b);
        }

        public void push() {
            Tint.this.rgba = this.rgb();
        }
    }
}

