/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util.data_fixers;

import com.beansgalaxy.backpacks.components.ender.EmptyEnderItem;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.bundle.BundleTraits;
import com.beansgalaxy.backpacks.util.ModSound;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.CustomData;

public class BPack2ItemFix
extends DataFix {
    public BPack2ItemFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        return this.writeFixAndRead("backpacks-2 to backpacks-3 items", this.getInputSchema().getType(References.ITEM_STACK), this.getOutputSchema().getType(References.ITEM_STACK), p_331180_ -> {
            Optional<Dynamic> optional = ItemStackData.read(p_331180_).map(data -> {
                this.fixItemStack((ItemStackData<?>)data);
                return data.write();
            });
            return (Dynamic)DataFixUtils.orElse(optional, (Object)p_331180_);
        });
    }

    private void fixItemStack(ItemStackData<?> data) {
        String item;
        switch (item = data.item) {
            case "beansbackpacks:metal_backpack": {
                String backpack_id;
                Optional optional = data.components.get("minecraft:custom_data").result();
                if (optional.isEmpty()) {
                    data.item = "beansbackpacks:iron_backpack";
                    break;
                }
                Dynamic dynamic = (Dynamic)optional.get();
                DataResult parse = CustomData.CODEC.parse(dynamic);
                if (parse.isError()) {
                    data.components.remove("minecraft:custom_data");
                    data.item = "beansbackpacks:iron_backpack";
                    break;
                }
                CustomData customData = (CustomData)parse.getOrThrow();
                CompoundTag compoundTag = customData.copyTag();
                switch (backpack_id = compoundTag.getString("backpack_id")) {
                    case "gold": {
                        data.item = "beansbackpacks:gold_backpack";
                        break;
                    }
                    case "netherite": {
                        data.item = "beansbackpacks:netherite_backpack";
                        break;
                    }
                    default: {
                        data.item = "beansbackpacks:iron_backpack";
                    }
                }
                compoundTag.remove("backpack_id");
                if (!compoundTag.isEmpty()) break;
                data.components.remove("minecraft:custom_data");
                break;
            }
            case "beansbackpacks:winged_backpack": {
                data.item = "minecraft:elytra";
                Stream<Dynamic<?>> stream = Stream.of(data.write());
                Dynamic itemList = data.components.createList(stream);
                data.setComponent("beansbackpacks:data_item_list", itemList);
                data.item = "beansbackpacks:backpack";
                data.removeComponent("minecraft:enchantments");
                data.encode("beansbackpacks:bundle", Traits.BUNDLE.codec(), new BundleTraits(ModSound.CRUNCH, 5)).encode("minecraft:item_name", DataComponents.ITEM_NAME.codec(), Component.translatable((String)"item.beansbackpacks.legacy.winged_backpack")).encode("minecraft:rarity", DataComponents.RARITY.codec(), Rarity.UNCOMMON);
                break;
            }
            case "beansbackpacks:ender_backpack": {
                data.item = "beansbackpacks:empty_ender_pouch";
                data.encode("beansbackpacks:empty_ender", Traits.EMPTY_ENDER.codec(), new EmptyEnderItem.UnboundEnderTraits(EnderStorage.LEGACY_ENDER_LOCATION)).encode("minecraft:item_name", DataComponents.ITEM_NAME.codec(), Component.translatable((String)"item.beansbackpacks.legacy.ender_backpack"));
            }
        }
    }

    static class ItemStackData<T> {
        private String item;
        private final int count;
        private Dynamic<T> components;
        private final Dynamic<T> remainder;

        private ItemStackData(String pItem, int pCount, Dynamic<T> pNbt) {
            this.item = NamespacedSchema.ensureNamespaced((String)pItem);
            this.count = pCount;
            this.components = pNbt.get("components").orElseEmptyMap();
            this.remainder = pNbt.remove("components");
        }

        public static Optional<? extends ItemStackData<?>> read(Dynamic<?> pTag) {
            return pTag.get("id").asString().apply2stable((p_331191_, p_330701_) -> new ItemStackData((String)p_331191_, p_330701_.intValue(), pTag.remove("id").remove("count")), pTag.get("count").asNumber()).result();
        }

        public void setComponent(String pComponent, Dynamic<?> pValue) {
            this.components = this.components.set(pComponent, pValue);
        }

        public void setComponent(String pComponent, OptionalDynamic<?> pValue) {
            pValue.result().ifPresent(p_332105_ -> {
                this.components = this.components.set(pComponent, p_332105_);
            });
        }

        public void removeComponent(String pComponent) {
            this.components = this.components.remove(pComponent);
        }

        public Dynamic<?> write() {
            Dynamic dynamic = this.remainder.emptyMap().set("id", this.remainder.createString(this.item)).set("count", this.remainder.createInt(this.count));
            if (!this.components.equals((Object)this.remainder.emptyMap())) {
                dynamic = dynamic.set("components", this.components);
            }
            return ItemStackData.mergeRemainder(dynamic, this.remainder);
        }

        private static <T> Dynamic<T> mergeRemainder(Dynamic<T> pTag, Dynamic<?> pRemainder) {
            DynamicOps dynamicops = pTag.getOps();
            return dynamicops.getMap(pTag.getValue()).flatMap(p_330670_ -> dynamicops.mergeToMap(pRemainder.convert(dynamicops).getValue(), p_330670_)).map(p_331482_ -> new Dynamic(dynamicops, p_331482_)).result().orElse(pTag);
        }

        public boolean is(String pItem) {
            return this.item.equals(pItem);
        }

        public boolean is(Set<String> pItems) {
            return pItems.contains(this.item);
        }

        public <M> ItemStackData<T> encode(String name, Codec<M> codec, M defaultInstance) {
            DynamicOps ops = this.components.getOps();
            DataResult encode = codec.encodeStart(ops, defaultInstance);
            if (encode.isSuccess()) {
                Object value = encode.getOrThrow();
                Dynamic dynamic = new Dynamic(ops, value);
                this.setComponent(name, dynamic);
            } else {
                encode.ifError(error -> System.out.println(error.message()));
            }
            return this;
        }
    }
}

