/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util.data_fixers;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BPack2PlayerFix
extends DataFix {
    public BPack2PlayerFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        return this.writeFixAndRead("backpacks-2 to backpacks-3 Back Slot", this.getInputSchema().getType(References.PLAYER), this.getOutputSchema().getType(References.PLAYER), this::fixPlayerBackSlot);
    }

    private <T> Dynamic<T> fixPlayerBackSlot(Dynamic<T> player) {
        AtomicReference backSlot = new AtomicReference();
        AtomicReference contents = new AtomicReference();
        Dynamic updated = player.update("Inventory", inventory -> {
            Dynamic cast = inventory.castTyped(player.getOps());
            return this.removeBackSlot(cast, backSlot, contents);
        });
        Dynamic itemStack = (Dynamic)backSlot.get();
        if (itemStack != null) {
            Dynamic<T> backStack = this.saveContents((Dynamic)contents.get(), BPack2PlayerFix.updateVersion(itemStack));
            Dynamic back = updated.emptyMap().set("back", backStack);
            return updated.set("beansbackpacks", back);
        }
        return updated;
    }

    public static <T> Dynamic<T> updateVersion(Dynamic<T> dynamic) {
        DataFixer dataFixer = DataFixers.getDataFixer();
        int version = SharedConstants.getCurrentVersion().getDataVersion().getVersion();
        return dataFixer.update(References.ITEM_STACK, dynamic, 3469, version);
    }

    @Nullable
    private <T> Stream<? extends Dynamic<T>> itemsFromContents(Dynamic<T> stacks) {
        DynamicOps ops = stacks.getOps();
        DataResult result = ops.getStream(stacks.getValue());
        if (result.isError()) {
            return null;
        }
        return ((Stream)result.getOrThrow()).map(item -> BPack2PlayerFix.updateVersion(new Dynamic(ops, item)));
    }

    private <T> Dynamic<T> saveContents(Dynamic<T> contents, Dynamic<T> itemStack) {
        Stream<Dynamic<T>> itemList;
        String trait;
        if (contents == null) {
            return itemStack;
        }
        Optional<Stream> optional1 = contents.get("Items").result().map(this::itemsFromContents);
        if (optional1.isEmpty()) {
            return itemStack;
        }
        Stream<Dynamic<Dynamic<Dynamic<Dynamic<T>>>>> items = optional1.get();
        Dynamic components = itemStack.get("components").orElseEmptyMap();
        Optional optional = components.get(trait = "beansbackpacks:data_item_list").result();
        Stream<Dynamic<Dynamic<Dynamic<Dynamic<T>>>>> stream1 = optional.isEmpty() ? items : ((itemList = this.itemsFromContents((Dynamic)optional.get())) == null ? items : Stream.concat(itemList, items));
        Dynamic item_list = components.createList((Stream)stream1);
        Dynamic set = components.set(trait, item_list);
        return itemStack.set("components", set);
    }

    @NotNull
    private <T> Dynamic<T> removeBackSlot(Dynamic<T> inventory, AtomicReference<Dynamic<T>> backSlot, AtomicReference<Dynamic<T>> contents) {
        DynamicOps ops = inventory.getOps();
        DataResult result = ops.getStream(inventory.getValue());
        if (result.isError()) {
            return inventory;
        }
        Stream stream = (Stream)result.getOrThrow();
        Stream<Object> filter = stream.filter(value -> {
            Dynamic slot = new Dynamic(ops, value);
            Optional optBackSlot = slot.get("BackSlot").result();
            if (optBackSlot.isEmpty()) {
                return true;
            }
            backSlot.set((Dynamic)optBackSlot.get());
            Optional optContents = slot.get("Contents").result();
            optContents.ifPresent(contents::set);
            return false;
        });
        Object list = ops.createList(filter);
        return new Dynamic(ops, list);
    }
}

