/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util.data_fixers;

import com.beansgalaxy.backpacks.util.data_fixers.BPack2PlayerFix;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.item.ItemStack;

public class LegacyEnder {
    public final HashMap<UUID, List<ItemStack>> MAP = new HashMap();

    public void fromNbt(CompoundTag tag) {
        if (tag.contains("EnderData")) {
            CompoundTag entries = tag.getCompound("EnderData");
            for (String key : entries.getAllKeys()) {
                UUID uuid = UUID.fromString(key);
                CompoundTag dataTags = entries.getCompound(key);
                List<ItemStack> stacks = LegacyEnder.readStackNbt(dataTags);
                this.MAP.put(uuid, stacks);
            }
            this.MAP.remove(null);
        }
    }

    public static List<ItemStack> readStackNbt(CompoundTag nbt) {
        ListTag nbtList = nbt.getList("Items", 10);
        Dynamic dynamic = new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)nbtList);
        Dynamic updated = BPack2PlayerFix.updateVersion(dynamic);
        DataResult result = ItemStack.CODEC.listOf().parse(updated);
        if (result.isError()) {
            return List.of();
        }
        return (List)result.getOrThrow();
    }
}

