/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util.data_fixers;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.components.ender.EmptyEnderItem;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.items.ModItems;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.util.data_fixers.BPack2PlayerFix;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.component.DyedItemColor;

public class RecoverLocalData {
    public static void readEntity(BackpackEntity entity, CompoundTag tag) {
        ItemStack backpack;
        RegistryAccess access = entity.registryAccess();
        entity.setDirection(Direction.from3DDataValue((int)tag.getByte("facing")));
        entity.setNoGravity(tag.getBoolean("hanging"));
        EntityType type = entity.getType();
        if (type == CommonClass.LEGACY_ENDER_ENTITY) {
            backpack = ModItems.EMPTY_ENDER_POUCH.get().getDefaultInstance();
            backpack.set(Traits.EMPTY_ENDER, (Object)new EmptyEnderItem.UnboundEnderTraits(EnderStorage.LEGACY_ENDER_LOCATION));
        } else {
            CompoundTag localDataTag = tag.getCompound("local_data");
            LocalData localData = new LocalData(localDataTag);
            backpack = localData.toStack(access, tag);
        }
        entity.getEntityData().set(BackpackEntity.ITEM_STACK, (Object)backpack);
    }

    public static ArrayList<ItemStack> readStackNbt(CompoundTag nbt, RegistryAccess access) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ListTag nbtList = nbt.getList("Items", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.getCompound(i);
            RegistryOps context = access.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            Dynamic dynamic = new Dynamic((DynamicOps)context, (Object)nbtCompound);
            Dynamic updated = BPack2PlayerFix.updateVersion(dynamic);
            ItemStack.CODEC.parse(updated).ifSuccess(stack -> {
                if (!stack.isEmpty()) {
                    list.add((ItemStack)stack);
                }
            });
        }
        return list;
    }

    public static class LocalData {
        public final Kind kind;
        public final String backpack_id;
        public int color = 0xFFFFFF;
        private CompoundTag trim = new CompoundTag();

        public LocalData(CompoundTag tag) {
            String kindString = tag.getString("kind");
            this.kind = Kind.fromName(kindString);
            this.backpack_id = tag.getString("backpack_id");
            if (!tag.contains("empty") || !tag.getBoolean("empty")) {
                this.color = tag.getInt("color");
                this.trim = tag.getCompound("Trim");
            }
        }

        public ItemStack toStack(RegistryAccess access, CompoundTag tag) {
            ItemStack backpack;
            switch (this.kind.ordinal()) {
                case 1: {
                    backpack = switch (this.backpack_id) {
                        case "gold" -> ModItems.GOLD_BACKPACK.get().getDefaultInstance();
                        case "netherite" -> ModItems.NETHERITE_BACKPACK.get().getDefaultInstance();
                        default -> ModItems.IRON_BACKPACK.get().getDefaultInstance();
                    };
                    RegistryOps ops = access.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                    ArmorTrim.CODEC.parse((DynamicOps)ops, (Object)this.trim).ifSuccess(armorTrim -> backpack.set(DataComponents.TRIM, armorTrim));
                    ArrayList<ItemStack> stacks = RecoverLocalData.readStackNbt(tag, access);
                    backpack.set(ITraitData.ITEM_STACKS, stacks);
                    break;
                }
                case 0: 
                case 6: {
                    backpack = ModItems.LEATHER_BACKPACK.get().getDefaultInstance();
                    DyedItemColor itemColor = new DyedItemColor(this.color, true);
                    backpack.set(DataComponents.DYED_COLOR, (Object)itemColor);
                    ArrayList<ItemStack> stacks = RecoverLocalData.readStackNbt(tag, access);
                    backpack.set(ITraitData.ITEM_STACKS, stacks);
                    break;
                }
                case 2: {
                    backpack = ModItems.LEATHER_BACKPACK.get().getDefaultInstance();
                    DyedItemColor itemColor = new DyedItemColor(this.color, true);
                    backpack.set(DataComponents.DYED_COLOR, (Object)itemColor);
                    ArrayList<ItemStack> stacks = RecoverLocalData.readStackNbt(tag, access);
                    Tag itemTags = tag.get("item_tags");
                    if (itemTags != null) {
                        CompoundTag compoundTag = new CompoundTag();
                        compoundTag.putString("id", "minecraft:elytra");
                        compoundTag.putInt("count", 1);
                        compoundTag.put("tag", itemTags);
                        RegistryOps context = access.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                        Dynamic dynamic = new Dynamic((DynamicOps)context, (Object)compoundTag);
                        Dynamic updated = BPack2PlayerFix.updateVersion(dynamic);
                        DataResult parse = ItemStack.CODEC.parse(updated);
                        if (parse.isSuccess()) {
                            stacks.add((ItemStack)parse.getOrThrow());
                        } else {
                            stacks.add(Items.ELYTRA.getDefaultInstance());
                        }
                    } else {
                        stacks.add(Items.ELYTRA.getDefaultInstance());
                    }
                    backpack.set(ITraitData.ITEM_STACKS, stacks);
                    break;
                }
                case 3: {
                    backpack = ModItems.EMPTY_ENDER_POUCH.get().getDefaultInstance();
                    backpack.set(Traits.EMPTY_ENDER, (Object)new EmptyEnderItem.UnboundEnderTraits(EnderStorage.LEGACY_ENDER_LOCATION));
                    break;
                }
                default: {
                    backpack = ModItems.IRON_BACKPACK.get().getDefaultInstance();
                }
            }
            return backpack;
        }
    }

    public static enum Kind {
        LEATHER,
        METAL,
        WINGED,
        ENDER,
        POT,
        CAULDRON,
        BIG_BUNDLE;


        public static Kind fromName(String string) {
            for (Kind kind : Kind.values()) {
                if (!kind.name().equals(string)) continue;
                return kind;
            }
            return METAL;
        }
    }
}

