/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks;

import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.data.config.ClientConfig;
import com.beansgalaxy.backpacks.items.ModBlocks;
import com.beansgalaxy.backpacks.items.ModItems;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4844;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7298;
import net.minecraft.class_9274;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class CommonClass {
    public static final Supplier<class_1299<BackpackEntity>> BACKPACK_ENTITY = Services.PLATFORM.register("backpack", class_1299.class_1300.method_5903(BackpackEntity::new, (class_1311)class_1311.field_17715).method_17687(0.4375f, 0.5625f).method_55687(0.5f));
    public static final Supplier<class_1299<BackpackEntity>> LEGACY_ENDER_ENTITY = Services.PLATFORM.register("ender_backpack", class_1299.class_1300.method_5903(BackpackEntity::new, (class_1311)class_1311.field_17715).method_17687(0.4375f, 0.5625f).method_55687(0.5f));
    public static final Supplier<class_1299<BackpackEntity>> LEGACY_WINGED_ENTITY = Services.PLATFORM.register("winged_backpack", class_1299.class_1300.method_5903(BackpackEntity::new, (class_1311)class_1311.field_17715).method_17687(0.4375f, 0.5625f).method_55687(0.5f));
    public static final Supplier<class_4168> CHESTER_ACTIVITY = Services.PLATFORM.registerActivity("chester");
    public static final Supplier<class_4168> CHESTER_IDLE_ACTIVITY = Services.PLATFORM.registerActivity("chester_idle");
    public static final Supplier<class_4140<UUID>> BACKPACK_OWNER_MEMORY = Services.PLATFORM.registerMemoryModule("backpack_owner", class_4844.field_25122);
    public static final ClientConfig CLIENT_CONFIG = new ClientConfig();

    public static void init() {
        ModSound.Events.register();
        Traits.register();
        ITraitData.register();
        ModItems.register();
        ModBlocks.register();
    }

    public static class_1269 swapBackWith(class_1531 armorStand, class_1657 player) {
        class_1304 slot = class_1304.field_48824;
        class_1799 backpack = player.method_6118(slot);
        class_1799 standItem = armorStand.method_6118(slot);
        if (backpack.method_7960() && standItem.method_7960()) {
            return class_1269.field_5814;
        }
        armorStand.method_6116(slot, standItem, backpack);
        player.method_6116(slot, backpack, standItem);
        armorStand.method_5673(slot, backpack);
        player.method_5673(slot, standItem);
        return class_1269.field_5812;
    }

    public static class_1269 swapBackWith(class_7298 allay, class_1657 player) {
        class_1304 slot = class_1304.field_48824;
        class_1799 backpack = player.method_6118(slot);
        class_1799 standItem = allay.method_6118(slot);
        if (backpack.method_7960()) {
            if (standItem.method_7960()) {
                return class_1269.field_5814;
            }
            allay.method_18868().method_18875(BACKPACK_OWNER_MEMORY.get());
        } else {
            Optional<GenericTraits> traitsOptional = Traits.get(backpack);
            if (traitsOptional.isEmpty()) {
                return class_1269.field_5814;
            }
            class_1799 itemInHand = allay.method_5998(class_1268.field_5808);
            if (!itemInHand.method_7960() && !player.method_7270(itemInHand)) {
                return class_1269.field_5814;
            }
            class_4095 brain = allay.method_18868();
            brain.method_18878(BACKPACK_OWNER_MEMORY.get(), (Object)player.method_5667());
            brain.method_24526(CHESTER_ACTIVITY.get());
        }
        allay.method_6116(slot, standItem, backpack);
        player.method_6116(slot, backpack, standItem);
        allay.method_5673(slot, backpack);
        player.method_5673(slot, standItem);
        return class_1269.field_5812;
    }

    public static void interactEquippedBackpack(class_1309 owner, class_1657 viewer, CallbackInfoReturnable<class_1269> cir) {
        double maxRadius;
        double radius;
        boolean looking;
        boolean yawMatches;
        class_1799 backpack = owner.method_6118(class_1304.field_48824);
        if (backpack.method_7960()) {
            return;
        }
        double yaw = Math.abs(viewer.field_6241 - owner.field_6283) % 360.0f - 180.0f;
        boolean bl = yawMatches = Math.abs(yaw) > 90.0;
        if (!yawMatches) {
            return;
        }
        Optional<GenericTraits> optional = Traits.get(backpack);
        if (optional.isEmpty()) {
            return;
        }
        double angleRadians = Math.toRadians(owner.field_6283);
        double offset = -0.3;
        double x = owner.method_23317();
        double z = owner.method_23321();
        double offsetX = Math.cos(angleRadians) * offset;
        double offsetZ = Math.sin(angleRadians) * offset;
        double newX = x - offsetZ;
        double newY = owner.method_23320() - 0.45;
        double newZ = z + offsetX;
        class_243 vec3d = viewer.method_5828(1.0f).method_1029();
        class_243 vec3d2 = new class_243(newX - viewer.method_23317(), newY - viewer.method_23320(), newZ - viewer.method_23321());
        double d = -vec3d2.method_1033() + 5.65;
        double e = vec3d.method_1026(vec3d2.method_1029());
        boolean bl2 = looking = e > 1.0 - (radius = d * d * d * d / 625.0) * (maxRadius = 0.05) && viewer.method_6057((class_1297)owner);
        if (!looking) {
            return;
        }
        GenericTraits traits = optional.get();
        traits.onPlayerInteract(owner, viewer, backpack, cir);
    }

    @NotNull
    public static String getTinyNumberFromDigitChar(char c) {
        return switch (c) {
            case '1' -> "\u2081";
            case '2' -> "\u2082";
            case '3' -> "\u2083";
            case '4' -> "\u2084";
            case '5' -> "\u2085";
            case '6' -> "\u2086";
            case '7' -> "\u2087";
            case '8' -> "\u2088";
            case '9' -> "\u2089";
            default -> "\u2080";
        };
    }

    public static void addAttributesToTooltip(Consumer<class_2561> pTooltipAdder, class_9274 slotGroup, MutableBoolean needsLabel, class_1799 backpack) {
        byte size;
        BackpackTraits traits = BackpackTraits.get(backpack);
        if (traits != null && traits.slots().test(slotGroup)) {
            if (needsLabel.isTrue()) {
                pTooltipAdder.accept(class_5244.field_39003);
                pTooltipAdder.accept((class_2561)class_2561.method_43471((String)("item.modifiers." + slotGroup.method_15434())).method_27692(class_124.field_1080));
                needsLabel.setFalse();
            }
            traits.client().appendTooltipLines(traits, pTooltipAdder);
        }
        if (class_9274.field_50127.equals((Object)slotGroup) && (size = UtilityComponent.getSize(backpack)) != 0) {
            if (needsLabel.isTrue()) {
                pTooltipAdder.accept(class_5244.field_39003);
                pTooltipAdder.accept((class_2561)class_2561.method_43471((String)("item.modifiers." + slotGroup.method_15434())).method_27692(class_124.field_1080));
                needsLabel.setFalse();
            }
            class_5250 translatable = class_2561.method_43469((String)"traits.beansbackpacks.equipment.utility", (Object[])new Object[]{size});
            pTooltipAdder.accept((class_2561)translatable.method_27692(class_124.field_1065));
        }
    }
}

