/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.access;

import com.beansgalaxy.backpacks.components.BulkComponent;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.generic.MutableItemStorage;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5630;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8172;
import net.minecraft.class_9062;
import net.minecraft.class_9326;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public interface DecoratedPotEntityAccess {
    public static final int SIZE = 108;

    default public Fraction getWeight() {
        BulkComponent bulk = this.getBulkComponent();
        if (bulk == null) {
            return Traits.getStackWeight(this.item().method_32327());
        }
        Fraction bulkWeight = bulk.weight();
        Fraction stackWeight = Traits.getStackWeight(this.item().method_32327());
        return bulkWeight.add(stackWeight);
    }

    default public float getFullness() {
        return this.getWeight().multiplyBy(Fraction.getFraction((int)1, (int)108)).floatValue();
    }

    default public boolean isFull() {
        return this.getWeight().multiplyBy(Fraction.getFraction((int)1, (int)108)).compareTo(Fraction.ONE) > -1;
    }

    default public class_1799 takeFromFocus() {
        class_1799 returned = this.item().method_32327();
        if (returned.method_7960()) {
            return class_1799.field_8037;
        }
        BulkComponent bulk = this.getBulkComponent();
        if (bulk == null) {
            this.item().method_32332(class_1799.field_8037);
            return returned;
        }
        ArrayList<BulkComponent.ItemlessStack> stacks = new ArrayList<BulkComponent.ItemlessStack>(bulk.stacks());
        class_1799 stack = stacks.removeLast().withItem(bulk.item());
        this.item().method_32332(stack);
        if (stacks.isEmpty()) {
            this.setBulkComponent(null);
            return returned;
        }
        this.tryFillFocusedItem(bulk.item(), stacks);
        return returned;
    }

    default public boolean insertIntoFocus(class_1799 stack) {
        if (!stack.method_7909().method_31568()) {
            return false;
        }
        class_1799 focused = this.item().method_32327();
        if (focused.method_7960()) {
            this.item().method_32332(stack);
            return true;
        }
        class_6880 item = focused.method_41409();
        if (!stack.method_41406(item)) {
            return false;
        }
        class_1937 level = this.getLevel();
        if (level.field_9236) {
            return true;
        }
        BulkComponent bulk = this.getBulkComponent();
        ArrayList<BulkComponent.ItemlessStack> stacks = bulk == null ? new ArrayList<BulkComponent.ItemlessStack>() : new ArrayList<BulkComponent.ItemlessStack>(bulk.stacks());
        BulkComponent.ItemlessStack itemless = new BulkComponent.ItemlessStack(focused.method_57380(), focused.method_7947());
        stacks.addFirst(itemless);
        this.item().method_32332(stack);
        if (stacks.size() > 1) {
            BulkComponent.ItemlessStack first = (BulkComponent.ItemlessStack)stacks.removeFirst();
            int maxSize = first.withItem((class_6880<class_1792>)item).method_7914();
            int count = first.count();
            class_9326 patch = first.patch();
            Iterator<BulkComponent.ItemlessStack> iterator = stacks.iterator();
            while (iterator.hasNext() && count < maxSize) {
                BulkComponent.ItemlessStack next = iterator.next();
                if (!Objects.equals(patch, next.patch())) continue;
                count += next.count();
                iterator.remove();
            }
            if (count > maxSize) {
                stacks.addFirst(new BulkComponent.ItemlessStack(patch, maxSize));
                count -= maxSize;
            }
            stacks.addFirst(new BulkComponent.ItemlessStack(patch, count));
        }
        this.tryFillFocusedItem((class_6880<class_1792>)item, stacks);
        return true;
    }

    default public void tryFillFocusedItem(class_6880<class_1792> item, ArrayList<BulkComponent.ItemlessStack> stacks) {
        class_1799 focused = this.item().method_32327();
        if (focused.method_7960()) {
            focused = stacks.removeFirst().withItem(item);
            this.item().method_32332(focused);
        }
        if (stacks.isEmpty()) {
            this.setBulkComponent(null);
            return;
        }
        int toAdd = focused.method_7914() - focused.method_7947();
        if (toAdd == 0) {
            this.setBulkComponent(new BulkComponent(item, (List<BulkComponent.ItemlessStack>)ImmutableList.copyOf(stacks)));
            return;
        }
        while (toAdd != 0) {
            if (stacks.isEmpty()) {
                this.setBulkComponent(null);
                return;
            }
            class_1799 stack = stacks.removeLast().withItem(item);
            if (!class_1799.method_31577((class_1799)focused, (class_1799)stack)) {
                return;
            }
            int count = Math.min(stack.method_7947(), toAdd);
            stack.method_7934(count);
            focused.method_7933(count);
            toAdd -= count;
            if (stack.method_7960()) continue;
            BulkComponent.ItemlessStack newItemless = new BulkComponent.ItemlessStack(stack.method_57380(), stack.method_7947());
            stacks.add(newItemless);
            this.setBulkComponent(new BulkComponent(item, (List<BulkComponent.ItemlessStack>)ImmutableList.copyOf(stacks)));
            return;
        }
        if (stacks.isEmpty()) {
            this.setBulkComponent(null);
        } else {
            this.setBulkComponent(new BulkComponent(item, (List<BulkComponent.ItemlessStack>)ImmutableList.copyOf(stacks)));
        }
    }

    public static boolean attack(class_1937 level, class_2338 pos, class_1657 player) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof DecoratedPotEntityAccess) {
            DecoratedPotEntityAccess entity = (DecoratedPotEntityAccess)blockEntity;
            class_2338 above = pos.method_10084();
            class_2680 blockState = level.method_8320(above);
            if (blockState.method_26212((class_1922)level, above)) {
                return true;
            }
            class_1799 returned = entity.takeFromFocus();
            if (returned.method_7960()) {
                return false;
            }
            if (!level.field_9236) {
                double d2 = (double)pos.method_10263() + 0.5;
                double d3 = (double)pos.method_10264() + 1.0;
                double d4 = (double)pos.method_10260() + 0.5;
                double d5 = class_3532.method_15366((class_5819)level.field_9229, (double)-0.1, (double)0.1);
                double d6 = 0.2;
                double d7 = class_3532.method_15366((class_5819)level.field_9229, (double)-0.1, (double)0.1);
                class_1542 itementity = new class_1542(level, d2, d3, d4, returned, d5, d6, d7);
                itementity.method_6982(0);
                level.method_8649((class_1297)itementity);
            }
            float fullness = entity.getFullness();
            entity.success(level, pos, player, fullness);
            return true;
        }
        return false;
    }

    public static class_9062 useItemOn(class_1799 inHand, class_1937 level, class_2338 pos, class_1657 player) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof DecoratedPotEntityAccess) {
            DecoratedPotEntityAccess entity = (DecoratedPotEntityAccess)blockEntity;
            class_2338 above = pos.method_10084();
            class_2680 blockState = level.method_8320(above);
            if (blockState.method_26212((class_1922)level, above)) {
                return class_9062.field_47728;
            }
            int toAdd = entity.amountToAdd(inHand);
            if (toAdd <= 0) {
                entity.fail(level, pos, player);
                return class_9062.field_47731;
            }
            class_1799 insert = inHand.method_46651(toAdd);
            boolean success = entity.insertIntoFocus(insert);
            if (level.field_9236) {
                return success ? class_9062.field_47728 : class_9062.field_47731;
            }
            if (success) {
                inHand.method_7934(toAdd);
                entity.success(inHand, level, pos, player, entity.getFullness());
                return class_9062.field_47728;
            }
            entity.fail(level, pos, player);
        }
        return class_9062.field_47731;
    }

    public static class_1269 useWithoutItem(class_1937 level, class_2338 pos, class_1657 player) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof DecoratedPotEntityAccess) {
            DecoratedPotEntityAccess entity = (DecoratedPotEntityAccess)blockEntity;
            class_2338 above = pos.method_10084();
            class_2680 blockState = level.method_8320(above);
            if (blockState.method_26212((class_1922)level, above)) {
                return class_1269.field_5812;
            }
            class_1799 focused = entity.item().method_32327();
            if (focused.method_7960()) {
                return class_1269.field_5811;
            }
            class_1661 inventory = player.method_31548();
            Stream aStream = Stream.concat(inventory.field_7547.stream(), inventory.field_7548.stream());
            Stream<class_1799> bStream = Stream.of(player.method_6118(class_1304.field_48824));
            Iterator iterator = Stream.concat(aStream, bStream).iterator();
            while (iterator.hasNext()) {
                int toAdd;
                class_1799 copy;
                class_1799 item = (class_1799)iterator.next();
                Optional<BundleLikeTraits> optional = BundleLikeTraits.get(ComponentHolder.of(item));
                if (optional.isPresent()) {
                    BundleLikeTraits traits = optional.get();
                    MutableItemStorage mutable = traits.mutable(ComponentHolder.of(item));
                    for (class_1799 stack : ((MutableBundleLike)mutable).getItemStacks()) {
                        int toAdd2;
                        class_1799 copy2 = stack.method_46651(toAdd2 = entity.amountToAdd(stack));
                        if (!entity.insertIntoFocus(copy2)) continue;
                        entity.success(stack, level, pos, player, entity.getFullness());
                        stack.method_7934(toAdd2);
                        ((MutableBundleLike)mutable).push();
                        return class_1269.field_5812;
                    }
                }
                if (!entity.insertIntoFocus(copy = item.method_46651(toAdd = entity.amountToAdd(item)))) continue;
                entity.success(item, level, pos, player, entity.getFullness());
                item.method_7934(toAdd);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static void onRemove(class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof DecoratedPotEntityAccess) {
            DecoratedPotEntityAccess entity = (DecoratedPotEntityAccess)blockEntity;
            BulkComponent bulk = entity.getBulkComponent();
            if (bulk == null) {
                return;
            }
            class_6880<class_1792> item = bulk.item();
            for (BulkComponent.ItemlessStack stack : bulk.stacks()) {
                class_1799 itemStack = stack.withItem(item);
                class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)itemStack);
            }
            entity.setBulkComponent(null);
        }
    }

    public static int getAnalogOutputSignal(class_1937 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof DecoratedPotEntityAccess) {
            DecoratedPotEntityAccess entity = (DecoratedPotEntityAccess)class_25862;
            if (entity.item().method_32327().method_7960()) {
                return 0;
            }
            Fraction fraction = entity.getWeight().multiplyBy(Fraction.getFraction((int)13, (int)108));
            return fraction.intValue() + 1;
        }
        return 0;
    }

    private int amountToAdd(class_1799 added) {
        Fraction size = Fraction.getFraction((int)108, (int)1);
        Fraction weight = this.getWeight();
        Fraction weightLeft = size.subtract(weight);
        int i = weightLeft.divideBy(Traits.getItemWeight(added)).intValue();
        return Math.min(i, added.method_7947());
    }

    private void fail(class_1937 level, class_2338 pos, class_1657 player) {
        level.method_8396(null, pos, class_3417.field_46650, class_3419.field_15245, 1.0f, 1.0f);
        this.wobble(class_8172.class_8837.field_46665);
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
    }

    private void success(class_1799 inHand, class_1937 level, class_2338 pos, class_1657 player, float fullness) {
        player.method_7259(class_3468.field_15372.method_14956((Object)inHand.method_7909()));
        this.success(level, pos, player, fullness);
    }

    private void success(class_1937 level, class_2338 pos, class_1657 player, float fullness) {
        this.wobble(class_8172.class_8837.field_46664);
        level.method_8396(null, pos, class_3417.field_46649, class_3419.field_15245, 1.0f, 0.7f + 0.5f * fullness);
        if (level instanceof class_3218) {
            class_3218 serverlevel = (class_3218)level;
            class_243 center = pos.method_46558();
            serverlevel.method_14199((class_2394)class_2398.field_46763, center.field_1352, (double)pos.method_10264() + 1.2, center.field_1350, 7, 0.0, 0.0, 0.0, 0.0);
        }
        this.method_5431();
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
    }

    @Nullable
    public BulkComponent getBulkComponent();

    public void setBulkComponent(@Nullable BulkComponent var1);

    public class_5630 item();

    public void wobble(class_8172.class_8837 var1);

    public void method_5431();

    public class_1937 getLevel();
}

