/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.beansgalaxy.backpacks.client.renderer.BackpackModel;
import com.beansgalaxy.backpacks.client.renderer.RenderUtilities;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.util.Tint;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5601;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public interface RenderBackpack
extends RenderUtilities {
    public static final class_5601 BACKPACK_MODEL = new class_5601(class_2960.method_60655((String)"beansbackpacks", (String)"backpack_model"), "main");
    public static final class_5601 PACK_CAPE_MODEL = new class_5601(class_2960.method_60655((String)"beansbackpacks", (String)"backpack_cape_model"), "main");

    public BackpackModel<?> model();

    default public void renderTexture(class_4587 pose, class_4597 pBufferSource, int pCombinedLight, class_2960 texture, class_1799 itemStack, ViewableBackpack viewable) {
        this.tryRenderUtilities(pose, pBufferSource, pCombinedLight, itemStack, viewable);
        if (texture.equals((Object)class_2960.method_60655((String)"beansbackpacks", (String)"leather"))) {
            this.builtInLeatherModel(pose, pBufferSource, pCombinedLight, itemStack);
            return;
        }
        class_2960 location = texture.method_45134(path -> "textures/backpack/" + path + ".png");
        class_4588 outer = pBufferSource.getBuffer(class_1921.method_23576((class_2960)location));
        this.model().renderBody(pose, outer, pCombinedLight, class_4608.field_21444, -1);
        this.model().renderMask(pose, outer, pCombinedLight, class_4608.field_21444, -1);
        class_8053 armorTrim = (class_8053)itemStack.method_57824(class_9334.field_49607);
        if (armorTrim != null) {
            class_2960 pattern = ((class_8056)armorTrim.method_48424().comp_349()).comp_1213();
            String material = ((class_8054)armorTrim.method_48431().comp_349()).comp_1208();
            class_2960 trimTexture = class_2960.method_60655((String)pattern.method_12836(), (String)("trims/backpacks/" + pattern.method_12832() + "_" + material));
            class_1059 atlas = class_310.method_1551().method_1554().method_24153(class_4722.field_42071);
            class_4588 trimVC = pBufferSource.getBuffer(class_1921.method_23586((class_2960)class_4722.field_42071));
            class_4588 wrapped = atlas.method_4608(trimTexture).method_24108(trimVC);
            this.model().renderBody(pose, wrapped, pCombinedLight, class_4608.field_21444, -1);
            class_4588 buttonVertex = pBufferSource.getBuffer(class_1921.method_23576((class_2960)class_4722.field_42071));
            class_4588 buttonWrap = atlas.method_4608(trimTexture).method_24108(buttonVertex);
            this.model().renderButton(pose, buttonWrap, pCombinedLight, class_4608.field_21444, -1);
        } else {
            this.model().renderButton(pose, outer, pCombinedLight, class_4608.field_21444, -1);
        }
    }

    default public void builtInLeatherModel(class_4587 pose, class_4597 pBufferSource, int pCombinedLight, class_1799 pItemStack) {
        class_9282 dyedItemColor = (class_9282)pItemStack.method_57824(class_9334.field_49644);
        int color = dyedItemColor == null ? -7714783 : dyedItemColor.comp_2384();
        class_2960 location = class_2960.method_60655((String)"beansbackpacks", (String)"textures/backpack/leather/base.png");
        class_2960 detail = class_2960.method_60655((String)"beansbackpacks", (String)"textures/backpack/leather/detail.png");
        class_4588 outer = pBufferSource.getBuffer(class_1921.method_23576((class_2960)location));
        this.model().renderBody(pose, outer, pCombinedLight, class_4608.field_21444, color);
        this.model().renderMask(pose, outer, pCombinedLight, class_4608.field_21444, color);
        class_4588 buttonVC = pBufferSource.getBuffer(class_1921.method_23576((class_2960)detail));
        this.model().renderButton(pose, buttonVC, pCombinedLight, class_4608.field_21444, -1);
        this.model().renderMask(pose, buttonVC, pCombinedLight, class_4608.field_21444, -1);
        Tint tint = new Tint(color);
        double brightness = tint.brightness();
        Tint.HSL hsl = tint.HSL();
        double lum = hsl.getLum();
        hsl.setLum((Math.cbrt(lum + 0.2) + lum) / 2.0).rotate(5.0).setSat(Math.sqrt((hsl.getSat() + brightness) / 2.0));
        int highColor = hsl.rgb();
        class_4588 detailVC = pBufferSource.getBuffer(class_1921.method_23689((class_2960)detail));
        this.model().renderBody(pose, detailVC, pCombinedLight, class_4608.field_21444, highColor);
    }

    default public void renderBackpack(class_4587 pose, class_4597 pBufferSource, int pCombinedLight, class_2960 location, class_1799 itemStack, @Nullable class_1309 entity, class_638 level, int seed) {
        pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        pose.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        pose.method_46416(-0.5f, -0.75f, -0.501f);
        class_1092 modelmanager = this.itemRenderer().method_4012().method_3303();
        class_1091 modelLocation = Services.PLATFORM.getModelVariant(location);
        class_1087 bakedModel = modelmanager.method_4742(modelLocation);
        class_1087 backpackModel = bakedModel.method_4710().method_3495(bakedModel, itemStack, level, entity, seed);
        if (backpackModel != null) {
            class_4588 buffer = pBufferSource.getBuffer(class_4722.method_24074());
            this.blockRenderer().method_3350().method_3367(pose.method_23760(), buffer, null, backpackModel, 1.0f, 1.0f, 1.0f, pCombinedLight, class_4608.field_21444);
        }
    }
}

