/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components;

import com.beansgalaxy.backpacks.traits.Traits;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import org.apache.commons.lang3.math.Fraction;

public record BulkComponent(class_6880<class_1792> item, List<ItemlessStack> stacks, Fraction weight) {
    public static final Codec<BulkComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_40294().fieldOf("item").forGetter(BulkComponent::item), (App)ItemlessStack.CODEC.listOf().fieldOf("stacks").forGetter(BulkComponent::stacks)).apply((Applicative)instance, BulkComponent::new));
    public static final class_9139<class_9129, BulkComponent> STREAM_CODEC = class_9139.method_56437((buf, bulk) -> {
        class_9135.method_56383((class_5321)class_7924.field_41197).encode(buf, bulk.item);
        List<ItemlessStack> stacks = bulk.stacks;
        int size = stacks.size();
        buf.method_53002(size);
        for (int i = 0; i < size; ++i) {
            ItemlessStack stack = stacks.get(i);
            ItemlessStack.STREAM_CODEC.encode(buf, (Object)stack);
        }
    }, buf -> {
        class_6880 item = (class_6880)class_9135.method_56383((class_5321)class_7924.field_41197).decode(buf);
        int size = buf.readInt();
        ArrayList<ItemlessStack> stacks = new ArrayList<ItemlessStack>();
        for (int i = 0; i < size; ++i) {
            ItemlessStack stack = (ItemlessStack)ItemlessStack.STREAM_CODEC.decode(buf);
            stacks.add(stack);
        }
        return new BulkComponent((class_6880<class_1792>)item, stacks);
    });

    public BulkComponent(class_6880<class_1792> item, List<ItemlessStack> stacks) {
        this(item, stacks, BulkComponent.getWeight(item, stacks));
    }

    private static Fraction getWeight(class_6880<class_1792> item, List<ItemlessStack> stacks) {
        Fraction fraction = Fraction.ZERO;
        for (ItemlessStack stack : stacks) {
            Fraction stackWeight = Traits.getStackWeight(stack.withItem(item));
            fraction = fraction.add(stackWeight);
        }
        return fraction.reduce();
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty() || class_1802.field_8162.equals(this.item.comp_349());
    }

    public record ItemlessStack(class_9326 patch, int count) {
        public static final Codec<ItemlessStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_9326.field_49589.fieldOf("components").forGetter(ItemlessStack::patch), (App)Codec.INT.fieldOf("count").forGetter(ItemlessStack::count)).apply((Applicative)instance, ItemlessStack::new));
        public static final class_9139<class_9129, ItemlessStack> STREAM_CODEC = class_9139.method_56437((buf, stack) -> {
            class_9326.field_49590.encode(buf, (Object)stack.patch());
            buf.method_53002(stack.count());
        }, buf -> {
            class_9326 components = (class_9326)class_9326.field_49590.decode(buf);
            int count = buf.readInt();
            return new ItemlessStack(components, count);
        });

        public class_1799 withItem(class_6880<class_1792> item) {
            return new class_1799(item, this.count, this.patch);
        }
    }
}

