/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components;

import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record FilterComponent(Iterable<class_6880<class_1792>> items, @Nullable class_6862<class_1792> tag, boolean blacklist) {
    public static final String NAME = "filter";
    public static final FilterComponent EMPTY = new FilterComponent(List.of(), null, false);
    private static final Codec<FilterComponent> TAG_CODEC = Codec.STRING.comapFlatMap(string -> {
        String path;
        boolean blacklist;
        if (string.startsWith("!#")) {
            blacklist = true;
            path = string.substring(2);
        } else if (string.startsWith("#")) {
            blacklist = false;
            path = string.substring(1);
        } else {
            return DataResult.error(() -> "Not a tag id");
        }
        return class_2960.method_29186((String)path).map(location -> {
            class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)location);
            return new FilterComponent((class_6862<class_1792>)key, blacklist);
        });
    }, filter -> {
        String prefix = filter.blacklist ? "!#" : "#";
        return prefix + String.valueOf(filter.tag.comp_327());
    });
    public static final Codec<FilterComponent> CODEC = new Codec<FilterComponent>(){

        public <T> DataResult<Pair<FilterComponent, T>> decode(DynamicOps<T> ops, T input) {
            DataResult decodeTag = TAG_CODEC.decode(ops, input);
            if (decodeTag.isSuccess()) {
                return decodeTag;
            }
            DataResult decodeItem = class_1799.field_47312.listOf().decode(ops, input);
            if (decodeItem.isSuccess()) {
                return decodeItem.map(pair -> pair.mapFirst(FilterComponent::new));
            }
            return DataResult.error(() -> "Neither item nor tag was parsed correctly; item=" + String.valueOf(decodeItem.error().get()) + "; tag=" + String.valueOf(decodeTag.error().get()));
        }

        public <T> DataResult<T> encode(FilterComponent filter, DynamicOps<T> ops, T prefix) {
            if (filter.tag == null) {
                ArrayList<class_6880<class_1792>> items = new ArrayList<class_6880<class_1792>>();
                for (class_6880<class_1792> holder : filter.items) {
                    items.add(holder);
                }
                return class_1799.field_47312.listOf().encode(items, ops, prefix);
            }
            return class_6862.method_40093((class_5321)class_7924.field_41197).encode(filter.tag, ops, prefix);
        }
    };
    public static final class_9139<class_9129, FilterComponent> STREAM_CODEC = class_9139.method_56437((buf, filter) -> {
        ArrayList<class_6880<class_1792>> items = new ArrayList<class_6880<class_1792>>();
        for (class_6880<class_1792> holder : filter.items) {
            items.add(holder);
        }
        int size = items.size();
        buf.method_53002(size);
        for (class_6880 class_68802 : items) {
            class_9135.method_56383((class_5321)class_7924.field_41197).encode(buf, (Object)class_68802);
        }
    }, buf -> {
        int size = buf.readInt();
        ArrayList<class_6880<class_1792>> items = new ArrayList<class_6880<class_1792>>();
        for (int i = 0; i < size; ++i) {
            class_6880 item = (class_6880)class_9135.method_56383((class_5321)class_7924.field_41197).decode(buf);
            items.add((class_6880<class_1792>)item);
        }
        return new FilterComponent(items);
    });

    public FilterComponent(class_6862<class_1792> tag, boolean blacklist) {
        this(class_7923.field_41178.method_40286(tag), tag, blacklist);
    }

    public FilterComponent(List<class_6880<class_1792>> items) {
        this(items, null, false);
    }

    public boolean isEmpty() {
        return this == EMPTY || !this.items.iterator().hasNext();
    }

    public boolean passes(class_1799 stack) {
        for (class_6880<class_1792> item : this.items) {
            if (!stack.method_41406(item)) continue;
            return !this.blacklist;
        }
        return this.blacklist;
    }

    @Nullable
    public static FilterComponent get(ComponentHolder stack) {
        FilterComponent component = stack.get(Traits.FILTER);
        if (component != null) {
            return component;
        }
        ReferenceTrait reference = stack.get(Traits.REFERENCE);
        if (reference == null) {
            return null;
        }
        return reference.getFilter().orElse(null);
    }
}

