/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components;

import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.util.Int2ValueMap;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilityComponent {
    public static final UtilityComponent BLANK = new UtilityComponent((Void)null){

        @Override
        public boolean isBlank() {
            return true;
        }
    };
    public static final String NAME = "utilities";
    private final Int2ObjectMap<class_1799> slots;
    private static final class_2561 OMINOUS_NAME = class_2561.method_43471((String)"block.minecraft.ominous_banner").method_27692(class_124.field_1065);
    public static final Codec<Byte> SIZE_CODEC = PrimitiveCodec.BYTE.validate(i -> i > 0 ? (i < 3 ? DataResult.success((Object)i) : DataResult.error(() -> "\"size\" cannot be larger than 2; input: " + i)) : DataResult.error(() -> "\"size\" cannot be smaller than 1; input: " + i));
    public static final Codec<UtilityComponent> CODEC = Slots.CODEC.listOf().xmap(items -> {
        Int2ObjectArrayMap map = new Int2ObjectArrayMap(items.size());
        map.defaultReturnValue((Object)class_1799.field_8037);
        for (Slots slot : items) {
            map.put(slot.slot, (Object)slot.stack);
        }
        return new UtilityComponent((Int2ObjectArrayMap<class_1799>)map);
    }, utility -> {
        ImmutableList.Builder list = ImmutableList.builder();
        utility.slots.forEach((integer, stack) -> list.add((Object)new Slots((int)integer, (class_1799)stack)));
        return list.build();
    });
    public static final class_9139<class_9129, UtilityComponent> STREAM_CODEC = new class_9139<class_9129, UtilityComponent>(){

        public UtilityComponent decode(class_9129 buf) {
            boolean isBlank = buf.readBoolean();
            if (isBlank) {
                return BLANK;
            }
            int size = buf.method_10816();
            Int2ObjectArrayMap map = new Int2ObjectArrayMap(size);
            map.defaultReturnValue((Object)class_1799.field_8037);
            for (int i = 0; i < size; ++i) {
                int key = buf.readInt();
                class_1799 stack = (class_1799)class_1799.field_48349.decode((Object)buf);
                map.put(key, (Object)stack);
            }
            return new UtilityComponent((Int2ObjectArrayMap<class_1799>)map);
        }

        public void encode(class_9129 buf, UtilityComponent component) {
            boolean isBlank = component.isBlank();
            buf.method_52964(isBlank);
            if (isBlank) {
                return;
            }
            Int2ObjectMap<class_1799> slots = component.slots;
            buf.method_10804(slots.size());
            slots.forEach((key, stack) -> {
                buf.method_53002(key.intValue());
                class_1799.field_48349.encode((Object)buf, stack);
            });
        }
    };

    public UtilityComponent(Int2ObjectArrayMap<class_1799> map) {
        map.defaultReturnValue((Object)class_1799.field_8037);
        ImmutableList.Builder builder = ImmutableList.builder();
        map.forEach((integer, stack) -> {
            Type util = UtilityComponent.getUtilities(stack);
            if (!Type.NONE.equals((Object)util)) {
                builder.add((Object)util);
            }
        });
        this.slots = Int2ObjectMaps.unmodifiable(map);
    }

    private UtilityComponent(Void ignored) {
        this.slots = new Int2ValueMap<class_1799>(class_1799.field_8037);
    }

    public static Optional<Mutable> get(class_1799 stack) {
        byte size;
        Byte utilities = (Byte)stack.method_57824(Traits.UTILITIES);
        if (utilities != null) {
            size = utilities;
        } else {
            ReferenceTrait reference = (ReferenceTrait)stack.method_57824(Traits.REFERENCE);
            if (reference == null) {
                return Optional.empty();
            }
            Optional<Byte> optional = reference.getUtilities();
            if (optional.isEmpty()) {
                return Optional.empty();
            }
            size = optional.get();
        }
        UtilityComponent component = (UtilityComponent)stack.method_57825(ITraitData.UTILITIES, (Object)BLANK);
        Mutable mutable = new Mutable(size, component, stack);
        return Optional.of(mutable);
    }

    public static byte getSize(class_1799 stack) {
        Optional<Byte> optional;
        if (stack.method_7960()) {
            return 0;
        }
        Byte utilities = (Byte)stack.method_57824(Traits.UTILITIES);
        if (utilities != null) {
            return utilities;
        }
        ReferenceTrait reference = (ReferenceTrait)stack.method_57824(Traits.REFERENCE);
        if (reference != null && (optional = reference.getUtilities()).isPresent()) {
            return optional.get();
        }
        return 0;
    }

    public static boolean testItems(class_1657 pPlayer, BiPredicate<class_1799, Mutable> predicate) {
        class_1799 backpack = pPlayer.method_6118(class_1304.field_48824);
        Optional<Mutable> optional = UtilityComponent.get(backpack);
        if (optional.isEmpty()) {
            return false;
        }
        Mutable mutable = optional.get();
        for (Int2ObjectMap.Entry entry : mutable.slots.int2ObjectEntrySet()) {
            class_1799 value = (class_1799)entry.getValue();
            if (!predicate.test(value, mutable)) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeOminous(class_1657 player, Runnable runnable) {
        class_1799 backpack = player.method_6118(class_1304.field_48824);
        Optional<Mutable> muteOptional = UtilityComponent.get(backpack);
        if (muteOptional.isEmpty()) {
            return false;
        }
        Mutable mutable = muteOptional.get();
        for (Int2ObjectMap.Entry entry : mutable.slots.int2ObjectEntrySet()) {
            class_1799 value = (class_1799)entry.getValue();
            if (!Type.OMINOUS.test(value)) continue;
            value.method_7934(1);
            mutable.freeze();
            runnable.run();
            return true;
        }
        return false;
    }

    public boolean has(Type type) {
        return this.get(type) != null;
    }

    @Nullable
    public class_1799 get(Type type) {
        ObjectCollection values = this.slots.values();
        for (class_1799 value : values) {
            if (!type.test(value)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    private static Type getUtilities(class_1799 stack) {
        return Type.NONE;
    }

    public class_1799 get(int i) {
        return (class_1799)this.slots.get(i);
    }

    public static Type getType(class_1799 stack) {
        for (Type value : Type.values()) {
            if (!value.test(stack)) continue;
            return value;
        }
        return Type.NONE;
    }

    public boolean isEmpty() {
        return this.slots.isEmpty();
    }

    public boolean isBlank() {
        return false;
    }

    public void clear() {
        this.slots.clear();
    }

    public Iterator<class_1799> iterator() {
        return this.slots.values().iterator();
    }

    public static boolean isOminousBanner(class_1799 stack) {
        if (!stack.method_31574(class_1802.field_8539) || !stack.method_57826(class_9334.field_49638)) {
            return false;
        }
        class_2561 component = (class_2561)stack.method_57824(class_9334.field_50239);
        return component != null && component.equals((Object)OMINOUS_NAME);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UtilityComponent)) {
            return false;
        }
        UtilityComponent component = (UtilityComponent)o;
        return Objects.equals(this.slots, component.slots);
    }

    public int hashCode() {
        return Objects.hash(this.slots);
    }

    public static class Mutable {
        public final Int2ObjectArrayMap<class_1799> slots;
        public final byte size;
        private final class_1799 holder;

        Mutable(byte size, UtilityComponent component, class_1799 holder) {
            Int2ObjectArrayMap map = new Int2ObjectArrayMap(component.slots);
            map.defaultReturnValue((Object)class_1799.field_8037);
            this.slots = map;
            this.size = size;
            this.holder = holder;
        }

        public UtilityComponent freeze() {
            UtilityComponent component;
            this.slots.int2ObjectEntrySet().removeIf(stack -> ((class_1799)stack.getValue()).method_7960());
            if (this.slots.isEmpty()) {
                this.holder.method_57381(ITraitData.UTILITIES);
                component = BLANK;
            } else {
                component = new UtilityComponent(this.slots);
                this.holder.method_57379(ITraitData.UTILITIES, (Object)component);
            }
            return component;
        }
    }

    public static enum Type {
        SPYGLASS(class_1802.field_27070, false),
        CLOCK(class_1802.field_8557, false),
        COMPASS(class_1802.field_8251, false),
        RECOVERY(class_1802.field_38747, false),
        LODESTONE(stack -> stack.method_31574(class_1802.field_8251) && stack.method_57826(class_9334.field_49614), false),
        CONDUIT(class_1802.field_8140, false),
        OMINOUS(UtilityComponent::isOminousBanner, true),
        ROCKET(class_1802.field_8639, true),
        TOTEM(class_1802.field_8288, false),
        LANTERN(stack -> stack.method_31574(class_1802.field_16539) || stack.method_31574(class_1802.field_22016), false),
        CRAFTING(class_1802.field_8465, false),
        CAULDRON(class_1802.field_8638, false),
        POT(class_1802.field_42699, false),
        NONE(class_1802.field_8162, true);

        private final Predicate<class_1799> predicate;
        private final boolean isStackable;

        private Type(class_1792 item, boolean stackable) {
            this((class_1799 stack) -> stack.method_31574(item), stackable);
        }

        private Type(Predicate<class_1799> predicate, boolean stackable) {
            this.predicate = predicate;
            this.isStackable = stackable;
        }

        public boolean test(class_1799 item) {
            return this.predicate.test(item);
        }

        public boolean isStackable() {
            return this.isStackable;
        }
    }

    private record Slots(int slot, class_1799 stack) {
        private static final Codec<Slots> CODEC = RecordCodecBuilder.create(in -> in.group((App)PrimitiveCodec.INT.fieldOf("slot").forGetter(Slots::slot), (App)class_1799.field_24671.fieldOf("item").forGetter(Slots::stack)).apply((Applicative)in, Slots::new));
    }
}

