/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components.ender;

import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.items.ModItems;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderTraits;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.generic.ItemStorageTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public final class EnderTraits
implements ComponentHolder {
    private final UUID uuid;
    private final class_2960 location;
    @Nullable
    private class_1937 level = null;
    public static final Codec<EnderTraits> CODEC = RecordCodecBuilder.create(in -> in.group((App)class_4844.field_41525.fieldOf("owner").forGetter(EnderTraits::owner), (App)class_2960.field_25139.fieldOf("location").forGetter(EnderTraits::trait)).apply((Applicative)in, EnderTraits::new));
    public static final class_9139<? super class_9129, EnderTraits> STREAM_CODEC = new class_9139<class_9129, EnderTraits>(){

        public void encode(class_9129 buf, EnderTraits traits) {
            class_2960.field_48267.encode((Object)buf, (Object)traits.location);
            class_4844.field_48453.encode((Object)buf, (Object)traits.uuid);
        }

        public EnderTraits decode(class_9129 buf) {
            class_2960 location = (class_2960)class_2960.field_48267.decode((Object)buf);
            UUID uuid = (UUID)class_4844.field_48453.decode((Object)buf);
            EnderTraits enderTraits = new EnderTraits(uuid, location);
            return enderTraits;
        }
    };

    public static Optional<EnderTraits> get(class_1799 stack) {
        if (!ModItems.ENDER_POUCH.is(stack)) {
            return Optional.empty();
        }
        EnderTraits enderTraits = (EnderTraits)stack.method_57824(Traits.ENDER);
        return Optional.ofNullable(enderTraits);
    }

    public EnderTraits(UUID uuid, class_2960 location) {
        this.uuid = uuid;
        this.location = location;
    }

    public void reload(class_1937 level) {
        this.level = level;
    }

    public boolean isLoaded() {
        return this.level != null;
    }

    public <T> Optional<T> mapLoaded(Function<class_1937, T> map) {
        return this.isLoaded() ? Optional.ofNullable(map.apply(this.level)) : Optional.empty();
    }

    public void runLoaded(Consumer<class_1937> run) {
        if (this.isLoaded()) {
            run.accept(this.level);
        }
    }

    public static Optional<ItemStorageTraits> getItemStorage(class_1799 stack) {
        EnderTraits enderTraits = (EnderTraits)stack.method_57824(Traits.ENDER);
        if (enderTraits != null) {
            return enderTraits.getTrait().map(traits -> {
                if (traits instanceof ItemStorageTraits) {
                    ItemStorageTraits storageTraits = (ItemStorageTraits)traits;
                    return storageTraits;
                }
                return null;
            });
        }
        return Optional.empty();
    }

    public static class_1799 createItem(class_1657 player, class_2960 location) {
        class_1792 enderItem = ModItems.ENDER_POUCH.get();
        class_1937 level = player.method_37908();
        UUID uuid = player.method_5667();
        EnderStorage.get(level).get(player, location);
        EnderTraits traits = new EnderTraits(uuid, location);
        class_1799 defaultInstance = enderItem.method_7854();
        defaultInstance.method_57379(Traits.ENDER, (Object)traits);
        return defaultInstance;
    }

    public UUID owner() {
        return this.uuid;
    }

    public class_2960 trait() {
        return this.location;
    }

    public Optional<GenericTraits> getTrait() {
        return this.mapLoaded(level -> EnderStorage.get(level).getTrait(this.uuid, this.location));
    }

    public GenericTraits getTrait(class_1937 level) {
        if (this.level == null) {
            this.level = level;
        }
        return EnderStorage.get(this.level).getTrait(this.uuid, this.location);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EnderTraits that = (EnderTraits)obj;
        return Objects.equals(this.uuid, that.uuid) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.location);
    }

    public String toString() {
        return "EnderTraits[owner=" + String.valueOf(this.uuid) + ", trait=" + String.valueOf(this.location) + "]";
    }

    @Override
    @Nullable
    public <T> T remove(class_9331<? extends T> type) {
        return this.mapLoaded(level -> EnderStorage.get(level).remove(this.uuid, this.location, type)).orElse(null);
    }

    @Override
    public <T> void set(class_9331<? super T> type, T trait) {
        this.runLoaded(level -> EnderStorage.get(level).set(this.uuid, this.location, type, trait));
    }

    @Override
    public <T> T get(class_9331<? extends T> type) {
        return this.mapLoaded(level -> {
            EnderStorage enderStorage = EnderStorage.get(level);
            return enderStorage.get(this.uuid, this.location).get((Object)type);
        }).orElse(null);
    }

    @Override
    public void setChanged() {
        if (!this.isLoaded() || this.level.field_9236) {
            return;
        }
        Predicate<class_1799> matchTraits = stack -> this.equals(stack.method_57824(Traits.ENDER));
        HashSet<class_3222> listeners = this.getListeners(this.level);
        Iterator<class_3222> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            class_3222 listener = iterator.next();
            if (listener.method_31548().method_55753(matchTraits) || matchTraits.test(listener.field_7498.method_34255())) {
                SendEnderTraits.send(listener, this.uuid, this.location);
                continue;
            }
            iterator.remove();
        }
    }

    public void broadcastChanges() {
    }

    public void broadcastChanges(class_3222 player) {
        Predicate<class_1799> matchTraits = stack -> this.equals(stack.method_57824(Traits.ENDER));
        HashSet<class_3222> listeners = this.getListeners(player.method_37908());
        Iterator<class_3222> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            class_3222 listener = iterator.next();
            if (listener.equals((Object)player)) continue;
            if (listener.method_31548().method_55753(matchTraits) || matchTraits.test(listener.field_7498.method_34255())) {
                SendEnderTraits.send(listener, this.uuid, this.location);
                continue;
            }
            iterator.remove();
        }
    }

    private HashSet<class_3222> getListeners(class_1937 level) {
        return EnderStorage.get(level).getListeners(this.uuid);
    }

    public void addListener(class_3222 serverPlayer) {
        HashSet<class_3222> listeners = this.getListeners(serverPlayer.method_37908());
        if (!listeners.contains(serverPlayer)) {
            listeners.add(serverPlayer);
            EnderStorage.sendEntry(serverPlayer, this.uuid, this.location);
        }
    }

    public class_2561 getDisplayName() {
        return this.mapLoaded(level -> EnderStorage.get(level).getDisplayName(this.uuid)).orElse((class_2561)class_2561.method_43470((String)"\u00a7kPlayer"));
    }
}

