/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components.reference;

import com.beansgalaxy.backpacks.components.DisplayComponent;
import com.beansgalaxy.backpacks.components.FilterComponent;
import com.beansgalaxy.backpacks.components.reference.NonTrait;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9285;
import org.jetbrains.annotations.Nullable;

public record ReferenceRegistry(GenericTraits traits, class_9285 modifiers, byte utilities, DisplayComponent display, FilterComponent filter) {
    public static final HashMap<class_2960, ReferenceRegistry> REFERENCES = new HashMap();
    public static class_9139<class_9129, ReferenceRegistry> STREAM_CODEC = new class_9139<class_9129, ReferenceRegistry>(){

        public void encode(class_9129 buf, ReferenceRegistry reference) {
            TraitComponentKind<? extends GenericTraits> kind = reference.traits.kind();
            TraitComponentKind.STREAM_CODEC.encode((Object)buf, kind);
            this.encode(buf, kind.method_57875(), reference.traits);
            class_9285.field_49328.encode((Object)buf, (Object)reference.modifiers);
            boolean hasDisplay = reference.display != null;
            buf.method_52964(hasDisplay);
            if (hasDisplay) {
                DisplayComponent.STREAM_CODEC.encode((Object)buf, (Object)reference.display);
            }
            buf.method_52997((int)reference.utilities);
            FilterComponent.STREAM_CODEC.encode((Object)buf, (Object)reference.filter);
        }

        private <T extends GenericTraits> void encode(class_9129 buf, Codec<T> codec, GenericTraits fields) {
            buf.method_49395(codec, (Object)fields);
        }

        public ReferenceRegistry decode(class_9129 buf) {
            TraitComponentKind kind = (TraitComponentKind)TraitComponentKind.STREAM_CODEC.decode((Object)buf);
            GenericTraits fields = (GenericTraits)buf.method_49394(kind.method_57875());
            class_9285 modifiers = (class_9285)class_9285.field_49328.decode((Object)buf);
            boolean hasDisplay = buf.readBoolean();
            DisplayComponent display = hasDisplay ? (DisplayComponent)DisplayComponent.STREAM_CODEC.decode((Object)buf) : null;
            byte utilities = buf.readByte();
            FilterComponent filter = (FilterComponent)FilterComponent.STREAM_CODEC.decode((Object)buf);
            return new ReferenceRegistry(fields, modifiers, utilities, display, filter);
        }
    };

    public static ReferenceRegistry get(class_2960 location) {
        ReferenceRegistry reference = REFERENCES.get(location);
        if (reference == null) {
            return ReferenceRegistry.createEmptyReference();
        }
        return reference;
    }

    public static ReferenceRegistry createEmptyReference() {
        return new ReferenceRegistry(NonTrait.INSTANCE, class_9285.field_49326, 0, null, FilterComponent.EMPTY);
    }

    @Nullable
    public static ReferenceRegistry getNullable(class_2960 location) {
        return REFERENCES.get(location);
    }

    public static void put(class_2960 location, ReferenceRegistry referenceRegistry) {
        REFERENCES.put(location, referenceRegistry);
    }
}

