/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.container;

import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.traits.ITraitData;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_5138;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7045;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class UtilityContainer
implements class_1263 {
    private final BackData owner;
    public byte size;
    private static int EFFECT_COOLDOWN = 40;
    private int effectCooldown = 0;
    private int omenCooldown = 0;

    public UtilityContainer(BackData owner) {
        this.owner = owner;
    }

    public static UtilityContainer get(class_1657 player) {
        BackData backData = BackData.get(player);
        return backData.getUtility();
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        return this.getUtility().isEmpty();
    }

    public class_1799 method_5438(int i) {
        return this.getUtility().get(i);
    }

    public class_1799 method_5434(int i, int amount) {
        return this.mapMutable(mute -> {
            class_1799 itemStack = (class_1799)mute.slots.get(i);
            if (itemStack.method_7960()) {
                return (class_1799)mute.slots.remove(i);
            }
            int count = itemStack.method_7947();
            if (count <= amount) {
                return (class_1799)mute.slots.remove(i);
            }
            class_1799 copy = itemStack.method_46651(amount);
            itemStack.method_7934(amount);
            return copy;
        }, class_1799.field_8037);
    }

    public class_1799 method_5441(int i) {
        return this.mapMutable(mute -> (class_1799)mute.slots.remove(i), class_1799.field_8037);
    }

    public void method_5447(int i, class_1799 stack) {
        this.getMutable().ifPresent(mute -> {
            mute.slots.put(i, (Object)stack);
            mute.freeze();
        });
    }

    private Optional<UtilityComponent.Mutable> getMutable() {
        class_1799 backpack = (class_1799)this.owner.beans_Backpacks_3$getBody().getFirst();
        if (backpack.method_7960()) {
            return Optional.empty();
        }
        return UtilityComponent.get(backpack);
    }

    private <T> T mapMutable(Function<UtilityComponent.Mutable, T> map, T orElse) {
        Optional<UtilityComponent.Mutable> mutable = this.getMutable();
        if (mutable.isEmpty()) {
            return orElse;
        }
        UtilityComponent.Mutable mute = mutable.get();
        T apply = map.apply(mute);
        mute.freeze();
        return apply;
    }

    private UtilityComponent getUtility() {
        class_1799 backpack = (class_1799)this.owner.beans_Backpacks_3$getBody().getFirst();
        return (UtilityComponent)backpack.method_57825(ITraitData.UTILITIES, (Object)UtilityComponent.BLANK);
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        class_1799 backpack = (class_1799)this.owner.beans_Backpacks_3$getBody().getFirst();
        backpack.method_57381(ITraitData.UTILITIES);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UtilityContainer)) {
            return false;
        }
        UtilityContainer container = (UtilityContainer)o;
        return this.size == container.size && Objects.equals(this.owner, container.owner);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.size);
    }

    public void tick(class_1661 inventory) {
        class_1937 class_19372;
        if (this.effectCooldown > 0) {
            --this.effectCooldown;
            return;
        }
        class_1657 player = inventory.field_7546;
        Optional<UtilityComponent.Mutable> optionalMute = this.getMutable();
        if (optionalMute.isEmpty()) {
            return;
        }
        UtilityComponent.Mutable mutable = optionalMute.get();
        class_1799 first = (class_1799)mutable.slots.get(0);
        class_1799 second = (class_1799)mutable.slots.get(1);
        UtilityComponent.Type firstType = UtilityComponent.getType(first);
        UtilityComponent.Type secondType = UtilityComponent.getType(second);
        if (player.method_5816() || player.method_37908().method_8419()) {
            if (firstType.equals((Object)UtilityComponent.Type.CONDUIT)) {
                if (secondType.equals((Object)UtilityComponent.Type.CONDUIT)) {
                    class_1293 effect = new class_1293(class_1294.field_5927, 260, 1, true, true);
                    player.method_6092(effect);
                    return;
                }
                effect = new class_1293(class_1294.field_5927, 260, 0, true, true);
                player.method_6092(effect);
                this.effectCooldown = EFFECT_COOLDOWN;
            } else if (secondType.equals((Object)UtilityComponent.Type.CONDUIT)) {
                effect = new class_1293(class_1294.field_5927, 260, 0, true, true);
                player.method_6092(effect);
                this.effectCooldown = EFFECT_COOLDOWN;
            }
        }
        if ((class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (firstType.equals((Object)UtilityComponent.Type.OMINOUS)) {
                this.consumeOminousEffect(player, serverLevel, mutable, 0);
            } else if (secondType.equals((Object)UtilityComponent.Type.OMINOUS)) {
                this.consumeOminousEffect(player, serverLevel, mutable, 1);
            }
        }
    }

    private void consumeOminousEffect(class_1657 player, class_3218 serverLevel, UtilityComponent.Mutable mutable, int i) {
        if (this.omenCooldown > 0) {
            --this.omenCooldown;
            return;
        }
        class_1293 effect = player.method_6112(class_1294.field_16595);
        if (effect == null) {
            effect = player.method_6112(class_1294.field_50116);
        }
        if (effect == null) {
            effect = player.method_6112(class_1294.field_50117);
        }
        if (effect != null) {
            this.omenCooldown = (int)((float)effect.method_5584() / ((float)EFFECT_COOLDOWN * 0.55f));
        } else if (this.isInStructure(serverLevel, player, (class_6862<class_3195>)class_7045.field_37045) || this.isInStructure(serverLevel, player, (class_6862<class_3195>)class_7045.field_49958)) {
            class_1293 omen = new class_1293(class_1294.field_16595, 5999, 0, true, true);
            player.method_6092(omen);
            ((class_1799)mutable.slots.get(i)).method_7934(1);
            mutable.freeze();
        }
    }

    private boolean isInStructure(class_3218 level, class_1657 player, class_6862<class_3195> tag) {
        Optional optional = level.method_30349().method_46759(class_7924.field_41246);
        if (optional.isEmpty()) {
            return false;
        }
        class_7225.class_7226 lookup = (class_7225.class_7226)optional.get();
        Optional optionalReference = lookup.method_46733(tag);
        if (optionalReference.isEmpty()) {
            return false;
        }
        class_6885.class_6888 aThrow = (class_6885.class_6888)optionalReference.get();
        class_5138 manager = level.method_27056();
        class_3449 at = manager.method_41034(player.method_24515(), (class_6885)aThrow);
        return at.method_16657();
    }

    private void applyConduitEffect(int amplifier, class_1657 player) {
    }
}

