/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.components.DisplayComponent;
import com.beansgalaxy.backpacks.components.FilterComponent;
import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.components.reference.NonTrait;
import com.beansgalaxy.backpacks.components.reference.ReferenceRegistry;
import com.beansgalaxy.backpacks.data.config.TraitConfig;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import net.minecraft.class_9285;

public class TraitLoader {
    private final class_3300 resourceManager;
    private final class_7780<class_7659> registryAccess;
    HashMap<class_2960, UnbakedTraits> unbakedMap = new HashMap();

    public TraitLoader(class_3300 manager, class_7780<class_7659> access) {
        this.resourceManager = manager;
        this.registryAccess = access;
    }

    public void run() {
        ReferenceRegistry.REFERENCES.clear();
        this.resourceManager.method_14488("trait_ids", in -> in.method_12832().endsWith(".json")).forEach((resourceLocation, resource) -> {
            try {
                class_6903 registryOps = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)this.registryAccess.method_45926());
                class_2960 location = resourceLocation.method_45134(path -> path.replaceFirst(".json", "").replaceFirst("trait_ids/", ""));
                JsonObject parse = class_3518.method_15255((Reader)resource.method_43039());
                UnbakedTraits traits = this.readJson(parse, (class_6903<JsonElement>)registryOps, location);
                this.unbakedMap.put(location, traits);
            }
            catch (IOException e) {
                throw new RuntimeException("error while parsing trait_ids", e);
            }
        });
        TraitConfig traitConfig = new TraitConfig();
        traitConfig.read();
        traitConfig.traits.forEach((string, parse) -> {
            class_6903 registryOps = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)this.registryAccess.method_45926());
            class_2960 location = class_2960.method_60654((String)string);
            UnbakedTraits traits = this.readJson((JsonObject)parse, (class_6903<JsonElement>)registryOps, location);
            this.unbakedMap.put(location, traits);
        });
        for (class_2960 location : this.unbakedMap.keySet()) {
            this.bakeEntry(location);
        }
    }

    private void bakeEntry(class_2960 location) {
        GenericTraits bakedTrait;
        class_2960 thisLocation = location;
        ArrayList<class_2960> chain = new ArrayList<class_2960>();
        while (!chain.contains(thisLocation) && this.unbakedMap.containsKey(thisLocation)) {
            chain.addFirst(thisLocation);
            if ((thisLocation = this.unbakedMap.get(thisLocation).parent()) != null) continue;
        }
        Pair<TraitComponentKind<?>, JsonObject> unbakedTrait = null;
        class_9285 attributes = class_9285.field_49326;
        byte utilities = 0;
        DisplayComponent display = null;
        FilterComponent filter = FilterComponent.EMPTY;
        for (class_2960 locations : chain) {
            UnbakedTraits temp = this.unbakedMap.get(locations);
            Pair<TraitComponentKind<?>, JsonObject> trait = temp.traits();
            if (trait != null) {
                if (unbakedTrait != null) {
                    TraitComponentKind kind = (TraitComponentKind)unbakedTrait.getFirst();
                    if (kind == trait.getFirst()) {
                        JsonObject jsonObject = (JsonObject)unbakedTrait.getSecond();
                        ((JsonObject)trait.getSecond()).asMap().forEach((arg_0, arg_1) -> ((JsonObject)jsonObject).add(arg_0, arg_1));
                    } else {
                        unbakedTrait = trait;
                    }
                } else {
                    unbakedTrait = trait;
                }
            }
            if (temp.attributes != null) {
                attributes = temp.attributes;
            }
            if (temp.utilities != -1) {
                utilities = temp.utilities;
            }
            if (temp.display != null) {
                display = temp.display;
            }
            if (temp.filter == null) continue;
            filter = temp.filter;
        }
        if (unbakedTrait != null) {
            TraitComponentKind kind = (TraitComponentKind)unbakedTrait.getFirst();
            JsonObject jsonObject = (JsonObject)unbakedTrait.getSecond();
            class_6903 registryOps = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)this.registryAccess.method_45926());
            DataResult result = kind.method_57875().parse((DynamicOps)registryOps, (Object)jsonObject);
            if (result.isError()) {
                String message = "Failure while parsing trait_id \"" + String.valueOf(location) + "\"; Error while decoding \"" + String.valueOf(kind) + "\"; ";
                String error = ((DataResult.Error)result.error().get()).message();
                Constants.LOG.warn("{}{}", (Object)message, (Object)error);
                return;
            }
            bakedTrait = (GenericTraits)result.getOrThrow();
        } else {
            bakedTrait = NonTrait.INSTANCE;
        }
        ReferenceRegistry.put(location, new ReferenceRegistry(bakedTrait, attributes, utilities, display, filter));
    }

    private UnbakedTraits readJson(JsonObject parse, class_6903<JsonElement> registryOps, class_2960 location) {
        Iterator iterator = parse.keySet().iterator();
        byte utilities = -1;
        FilterComponent filter = null;
        DisplayComponent display = null;
        class_9285 attributes = null;
        Pair traits = null;
        class_2960 parent = null;
        block9: while (iterator.hasNext()) {
            String type = (String)iterator.next();
            JsonElement json = parse.get(type);
            String string = type;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"parent", "modifiers", "utilities", "display", "filter", "non"}, (Object)string, n)) {
                case 0: {
                    String error;
                    String message;
                    if (parent != null) continue block9;
                    DataResult result = class_2960.field_25139.parse(registryOps, (Object)json);
                    if (result.isError()) {
                        message = "Failure while parsing trait_id \"" + String.valueOf(location) + "\"; Error while decoding \"" + type + "\"; ";
                        error = ((DataResult.Error)result.error().get()).message();
                        Constants.LOG.warn("{}{}", (Object)message, (Object)error);
                        continue block9;
                    }
                    parent = (class_2960)result.getOrThrow();
                    continue block9;
                }
                case 1: {
                    String error;
                    String message;
                    if (attributes != null) continue block9;
                    DataResult result = class_9285.field_49327.parse(registryOps, (Object)json);
                    if (result.isError()) {
                        message = "Failure while parsing trait_id \"" + String.valueOf(location) + "\"; Error while decoding \"" + type + "\"; ";
                        error = ((DataResult.Error)result.error().get()).message();
                        Constants.LOG.warn("{}{}", (Object)message, (Object)error);
                        continue block9;
                    }
                    attributes = (class_9285)result.getOrThrow();
                    continue block9;
                }
                case 2: {
                    String error;
                    String message;
                    if (utilities != -1) continue block9;
                    DataResult result = UtilityComponent.SIZE_CODEC.parse(registryOps, (Object)json);
                    if (result.isError()) {
                        message = "Failure while parsing trait_id \"" + String.valueOf(location) + "\"; Error while decoding \"" + type + "\"; ";
                        error = ((DataResult.Error)result.error().get()).message();
                        Constants.LOG.warn("{}{}", (Object)message, (Object)error);
                        continue block9;
                    }
                    utilities = (Byte)result.getOrThrow();
                    continue block9;
                }
                case 3: {
                    String error;
                    String message;
                    if (display != null) continue block9;
                    DataResult result = DisplayComponent.CODEC.parse(registryOps, (Object)json);
                    if (result.isError()) {
                        message = "Failure while parsing trait_id \"" + String.valueOf(location) + "\"; Error while decoding \"" + type + "\"; ";
                        error = ((DataResult.Error)result.error().get()).message();
                        Constants.LOG.warn("{}{}", (Object)message, (Object)error);
                        continue block9;
                    }
                    display = (DisplayComponent)result.getOrThrow();
                    continue block9;
                }
                case 4: {
                    String error;
                    String message;
                    if (filter != null) continue block9;
                    DataResult result = FilterComponent.CODEC.parse(registryOps, (Object)json);
                    if (result.isError()) {
                        message = "Failure while parsing trait_id \"" + String.valueOf(location) + "\"; Error while decoding \"" + type + "\"; ";
                        error = ((DataResult.Error)result.error().get()).message();
                        Constants.LOG.warn("{}{}", (Object)message, (Object)error);
                        continue block9;
                    }
                    filter = (FilterComponent)result.getOrThrow();
                    continue block9;
                }
                case 5: {
                    continue block9;
                }
                case -1: {
                    continue block9;
                }
            }
            TraitComponentKind<GenericTraits> kind = TraitComponentKind.get(type);
            if (kind == null || !json.isJsonObject()) continue;
            traits = Pair.of(kind, (Object)json.getAsJsonObject());
        }
        return new UnbakedTraits(parent, traits, attributes, display, filter, utilities);
    }

    public record UnbakedTraits(class_2960 parent, Pair<TraitComponentKind<?>, JsonObject> traits, class_9285 attributes, DisplayComponent display, FilterComponent filter, byte utilities) {
    }
}

