/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config;

import com.beansgalaxy.backpacks.data.config.TraitConfig;
import com.beansgalaxy.backpacks.data.config.screen.ConfigRows;
import com.beansgalaxy.backpacks.data.config.screen.ConfigScreen;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_7077;
import net.minecraft.class_7529;

public class TraitConfigRows
extends ConfigRows {
    private MultiLineParentRow parentRow;

    public TraitConfigRows(ConfigScreen screen, class_310 minecraft, TraitConfig config) {
        super(screen, minecraft, config);
        this.method_25321((class_350.class_351)new ConfigRows.ConfigDescription(this, (class_2561)class_2561.method_43471((String)"config.beansbackpacks.traits.description")));
        this.parentRow = new MultiLineParentRow(config.traits);
        this.method_25321((class_350.class_351)this.parentRow);
        this.method_25321((class_350.class_351)new ConfigRows.ConfigLabel(this, (class_2561)class_2561.method_43471((String)"config.beansbackpacks.traits.new")));
        this.method_25321((class_350.class_351)new NewTraitEntryRow(this.parentRow));
    }

    @Override
    public void resetToDefault() {
        TraitConfig config = (TraitConfig)this.config;
        this.parentRow = new MultiLineParentRow(config.traits);
    }

    @Override
    public void onSave() {
        TraitConfig traitConfig = (TraitConfig)this.config;
        Map<String, JsonObject> map = traitConfig.traits;
        map.clear();
        this.parentRow.map.forEach((name, row) -> {
            String value = "{" + row.editBox.method_44405() + "}";
            JsonObject parse = JsonParser.parseString((String)value).getAsJsonObject();
            map.put((String)name, parse);
        });
    }

    public class MultiLineParentRow
    extends ConfigRows.ConfigLabel {
        protected final HashMap<String, MultiLineEntry> map;
        private List<class_339> widgets;

        public MultiLineParentRow(Map<String, JsonObject> traits) {
            super(TraitConfigRows.this, (class_2561)class_2561.method_43470((String)"multiline_parent"));
            this.map = new HashMap();
            this.widgets = List.of();
            traits.forEach(this::createRow);
            this.reloadMap();
        }

        private void createRow(String name, JsonObject row) {
            class_7529 editBox = new class_7529(((TraitConfigRows)TraitConfigRows.this).field_22740.field_1772, 0, 9, TraitConfigRows.this.method_25322(), 72, (class_2561)class_2561.method_43470((String)""), (class_2561)class_2561.method_43470((String)"message"));
            String string = row.toString();
            StringBuilder builder = new StringBuilder(string);
            builder.deleteCharAt(0).deleteCharAt(string.length() - 2);
            editBox.method_44400(builder.toString());
            int height = editBox.method_44391() + 9;
            editBox.method_53533(height);
            MultiLineEntry configRow = new MultiLineEntry(name, editBox);
            this.map.put(name, configRow);
        }

        @Override
        public void method_25343(class_332 guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            for (MultiLineEntry value : this.map.values()) {
                value.render(guiGraphics, y, x, mouseX, mouseY, delta);
                y += value.getHeight();
            }
        }

        @Override
        public int getHeight() {
            return this.map.values().stream().mapToInt(MultiLineEntry::getHeight).sum();
        }

        private void reloadMap() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (MultiLineEntry value : this.map.values()) {
                builder.add((Object[])new class_339[]{value.editBox, value.confirm_remove, value.deny_remove, value.title});
            }
            this.widgets = builder.build();
        }

        public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
            if (pKeyCode == 258) {
                return true;
            }
            return super.method_25404(pKeyCode, pScanCode, pModifiers);
        }

        public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
            boolean fal = false;
            if (fal) {
                int i = TraitConfigRows.this.method_25322() / 2;
                int j = TraitConfigRows.this.method_46426() + TraitConfigRows.this.field_22758 / 2;
                int left = j - i;
                int right = j + i;
                if (pMouseX < (double)left || pMouseX > (double)right) {
                    return false;
                }
                for (class_339 child : this.widgets) {
                    int x;
                    if (!child.method_37303() || !child.field_22764) continue;
                    int topPos = child.method_46427();
                    int height = child.method_25364();
                    int botPos = topPos + height;
                    if (!(pMouseY > (double)topPos) || !(pMouseY < (double)botPos) || !(pMouseX > (double)(x = child.method_46426())) || !(pMouseX < (double)(x + child.method_25368()))) continue;
                    return child.method_25402(pMouseX, pMouseY, pButton);
                }
            }
            return super.method_25402(pMouseX, pMouseY, pButton);
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return this.widgets;
        }

        @Override
        public List<? extends class_364> method_25396() {
            return this.widgets;
        }

        public class MultiLineEntry {
            private final String entryName;
            private final class_7529 editBox;
            private final class_4185 confirm_remove;
            private final class_4185 deny_remove;
            private final class_4185 title;

            public MultiLineEntry(String name, class_7529 editBox) {
                this.entryName = name;
                this.editBox = editBox;
                final class_327 font = ((TraitConfigRows)TraitConfigRows.this).field_22740.field_1772;
                final int yesWidth = font.method_27525((class_5348)class_5244.field_24336);
                this.confirm_remove = new class_7077(TraitConfigRows.this.method_31383() - 40, 0, yesWidth, 9, class_5244.field_24336, button -> {
                    MultiLineParentRow row = MultiLineParentRow.this;
                    row.map.remove(this.entryName);
                    row.reloadMap();
                }, font);
                this.confirm_remove.field_22764 = false;
                final int noWidth = font.method_27525((class_5348)class_5244.field_24337);
                this.deny_remove = new class_7077(TraitConfigRows.this.method_31383() - 40, 0, noWidth, 9, class_5244.field_24337, button -> {
                    this.title.field_22763 = true;
                    this.confirm_remove.field_22764 = false;
                    this.deny_remove.field_22764 = false;
                }, font);
                this.deny_remove.field_22764 = false;
                this.title = new class_7077(0, 0, TraitConfigRows.this.method_25322() - yesWidth - noWidth, 9, (class_2561)class_2561.method_43470((String)this.entryName), button -> {
                    this.confirm_remove.field_22764 = true;
                    this.deny_remove.field_22764 = true;
                    class_4185 title = this.title;
                    title.field_22763 = false;
                }, font){
                    private final class_2561 removal_title;
                    {
                        super(x, y, width, height, message, onPress, font2);
                        this.removal_title = class_2561.method_43470((String)MultiLineEntry.this.entryName).method_27695(new class_124[]{class_124.field_1055, class_124.field_1061});
                    }

                    public void method_48579(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                        class_2561 component;
                        if (!this.field_22763) {
                            component = this.removal_title;
                            class_5250 text = class_2561.method_43471((String)"config.beansbackpacks.traits.remove-trait").method_27692(class_124.field_1080);
                            int width = font.method_27525((class_5348)text);
                            pGuiGraphics.method_27535(font, (class_2561)text, TraitConfigRows.this.method_31383() - yesWidth - noWidth - width - 10, this.method_46427(), 0xFFFFFF | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
                        } else {
                            component = this.field_22762 ? this.removal_title : this.method_25369();
                        }
                        pGuiGraphics.method_27535(font, component, this.method_46426(), this.method_46427(), 0xFFFFFF | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
                    }
                };
            }

            public void render(class_332 guiGraphics, int y, int x, int mouseX, int mouseY, float delta) {
                this.confirm_remove.method_46419(y);
                this.deny_remove.method_46419(y);
                this.title.method_46419(y);
                int rightPos = TraitConfigRows.this.method_31383() - this.confirm_remove.method_25368();
                this.confirm_remove.method_46421(rightPos);
                this.deny_remove.method_46421(rightPos - this.deny_remove.method_25368() - 4);
                this.title.method_46421(x + 2);
                this.confirm_remove.method_25394(guiGraphics, mouseX, mouseY, delta);
                this.deny_remove.method_25394(guiGraphics, mouseX, mouseY, delta);
                this.title.method_25394(guiGraphics, mouseX, mouseY, delta);
                this.editBox.method_46419(y + 11);
                this.editBox.method_46421(x);
                int height = this.editBox.method_44391() + 9;
                this.editBox.method_53533(height);
                this.editBox.method_25394(guiGraphics, mouseX, mouseY, delta);
            }

            public int getHeight() {
                return this.editBox.method_25364() + 15;
            }
        }
    }

    public class NewTraitEntryRow
    extends ConfigRows.ConfigLabel {
        private final class_342 editBox;
        private final MultiLineParentRow parentRow;

        public NewTraitEntryRow(MultiLineParentRow parentRow) {
            super(TraitConfigRows.this, (class_2561)class_2561.method_43470((String)"new_trait_row"));
            this.editBox = new class_342(((TraitConfigRows)TraitConfigRows.this).field_22740.field_1772, TraitConfigRows.this.method_25322(), 12, (class_2561)class_2561.method_43471((String)"config.beansbackpacks.traits.new-title"));
            this.editBox.method_47404((class_2561)class_2561.method_43471((String)"config.beansbackpacks.traits.new-box").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
            this.parentRow = parentRow;
        }

        public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
            if (pKeyCode == 257) {
                String name = this.editBox.method_1882();
                this.parentRow.createRow(name, new JsonObject());
                this.parentRow.reloadMap();
                this.editBox.method_1852("");
            }
            return super.method_25404(pKeyCode, pScanCode, pModifiers);
        }

        @Override
        public void method_25343(class_332 guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.editBox.method_46421(TraitConfigRows.this.method_25342());
            this.editBox.method_46419(y);
            this.editBox.method_25394(guiGraphics, mouseX, mouseY, delta);
        }

        @Override
        public List<? extends class_364> method_25396() {
            return List.of(this.editBox);
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return List.of(this.editBox);
        }
    }
}

