/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config.screen;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.data.config.types.ConfigLine;
import com.beansgalaxy.backpacks.platform.Services;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;

public interface IConfig {
    public String getPath();

    public Collection<ConfigLine> getLines();

    default public void parse(String encodedConfig) {
        JsonObject jsonObject = JsonParser.parseString((String)encodedConfig).getAsJsonObject();
        Collection<ConfigLine> lines = this.getLines();
        for (ConfigLine line : lines) {
            line.decode(jsonObject);
        }
    }

    default public void read() {
        this.read(true);
    }

    default public void read(boolean andWrite) {
        try {
            Path path = Services.PLATFORM.getConfigPath();
            Path resolve = path.resolve(this.getPath() + ".json5");
            if (!Files.exists(resolve, new LinkOption[0])) {
                resolve = this.getLegacyLocation();
            }
            String json5Content = new String(Files.readAllBytes(resolve));
            String jsonContent = json5Content.replaceAll("/\\*.*?\\*/", "").replaceAll("//.*", "");
            this.parse(jsonContent);
        }
        catch (IOException e) {
            Constants.LOG.warn("No Config for beansbackpacks : Created new config");
        }
        if (andWrite) {
            this.write();
        }
    }

    @Deprecated(since="0.4-beta")
    private Path getLegacyLocation() {
        return Services.PLATFORM.getConfigDir().resolve("beansbackpacks-" + this.getPath() + ".json5");
    }

    default public void write() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        Iterator<ConfigLine> iterator = this.getLines().iterator();
        while (iterator.hasNext()) {
            ConfigLine line = iterator.next();
            String encode = line.encode();
            if (line.punctuate()) {
                sb.append("  ");
            }
            sb.append(encode);
            int length = encode.length();
            if (line.punctuate() && iterator.hasNext()) {
                sb.append(',');
                ++length;
            }
            sb.append(line.comment(Math.max(0, 34 - length)));
            sb.append('\n');
        }
        sb.append('}');
        try {
            Path path = Services.PLATFORM.getConfigPath();
            Path resolve = path.resolve(this.getPath() + ".json5");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            String string = sb.toString();
            Files.writeString(resolve, (CharSequence)string, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

