/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config.types;

import com.beansgalaxy.backpacks.data.config.types.ConfigVariant;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class MapConfigVariant<KEY, ENTRY>
extends ConfigVariant<HashMap<String, ENTRY>> {
    private final Function<KEY, String> keyEncode;
    private final Function<String, KEY> keyDecode;
    private final Function<ENTRY, JsonElement> entryEncode;
    private final Function<JsonElement, ENTRY> entryDecode;
    public final BiPredicate<String, ENTRY> validate;
    public final UnaryOperator<ENTRY> clamp;
    private final HashMap<String, ENTRY> example;

    protected MapConfigVariant(String name, HashMap<String, ENTRY> defau, String comment, Function<KEY, String> keyEncode, Function<String, KEY> keyDecode, Function<ENTRY, JsonElement> entryEncode, Function<JsonElement, ENTRY> entryDecode, BiPredicate<String, ENTRY> validate, UnaryOperator<ENTRY> clamp, HashMap<String, ENTRY> example) {
        super(name, defau, comment);
        this.value = new HashMap<String, ENTRY>(defau);
        this.keyEncode = keyEncode;
        this.keyDecode = keyDecode;
        this.entryEncode = entryEncode;
        this.entryDecode = entryDecode;
        this.validate = validate;
        this.clamp = clamp;
        this.example = example;
    }

    public static <K, E> Builder<K, E> create(Function<K, String> keyEncode, Function<String, K> keyDecode, Function<E, JsonElement> entryEncode, Function<JsonElement, E> entryDecode) {
        return new Builder<K, E>(keyEncode, keyDecode, entryEncode, entryDecode);
    }

    public static <E> Builder<String, E> create(Function<E, JsonElement> entryEncode, Function<JsonElement, E> entryDecode) {
        Function<String, String> transcode = in -> in;
        return new Builder<String, E>(transcode, transcode, entryEncode, entryDecode);
    }

    public boolean contains(KEY key) {
        return ((HashMap)this.value).containsKey(this.keyEncode.apply(key));
    }

    public ENTRY get(KEY key) {
        return (ENTRY)((HashMap)this.value).get(this.keyEncode.apply(key));
    }

    public void put(String key, ENTRY entry) {
        ((HashMap)this.value).put(key, entry);
    }

    @Override
    public String comment(int whiteSpace) {
        return "";
    }

    @Override
    public String encode() {
        String formattedName = this.toString();
        StringBuilder sb = new StringBuilder().append(formattedName);
        sb.append("{");
        if (!this.comment.isBlank()) {
            sb.append(" ".repeat(Math.max(0, 34 - formattedName.length()))).append("// ").append(this.comment);
        }
        this.writeEntries(sb);
        this.writeExamples(sb);
        sb.append("\n  }");
        return sb.toString();
    }

    private void writeEntries(StringBuilder sb) {
        Iterator iterator = ((HashMap)this.value).keySet().iterator();
        while (iterator.hasNext()) {
            Object entry;
            String key = (String)iterator.next();
            if (!this.validate.test(key, entry = ((HashMap)this.value).get(key))) continue;
            sb.append("\n    \"");
            sb.append(key).append("\": ").append(this.entryEncode.apply(entry));
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
    }

    private void writeExamples(StringBuilder sb) {
        HashMap<String, ENTRY> map = new HashMap<String, ENTRY>(this.example);
        for (String key : ((HashMap)this.value).keySet()) {
            map.remove(key);
        }
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            key = iterator.next();
            ENTRY entry = map.get(key);
            sb.append("\n    //\"");
            sb.append(key).append("\": ").append(this.entryEncode.apply(entry));
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
    }

    @Override
    public void decode(JsonObject jsonObject) {
        if (!jsonObject.has(this.name)) {
            return;
        }
        ((HashMap)this.value).clear();
        JsonObject jsonValue = jsonObject.getAsJsonObject(this.name);
        for (String key : jsonValue.keySet()) {
            JsonElement entry = jsonValue.get(key);
            ENTRY appliedEntry = this.entryDecode.apply(entry);
            this.put(key, appliedEntry);
        }
    }

    public static class Builder<K, E> {
        private final HashMap<String, E> defau = new HashMap();
        private final HashMap<String, E> example = new HashMap();
        private final Function<K, String> keyEncode;
        private final Function<String, K> keyDecode;
        private final Function<E, JsonElement> entryEncode;
        private final Function<JsonElement, E> entryDecode;
        private BiPredicate<String, E> validator = (k, e) -> true;
        private UnaryOperator<E> clamp = e -> e;
        private String comment = "";

        private Builder(Function<K, String> keyEncode, Function<String, K> keyDecode, Function<E, JsonElement> entryEncode, Function<JsonElement, E> entryDecode) {
            this.keyEncode = keyEncode;
            this.keyDecode = keyDecode;
            this.entryEncode = entryEncode;
            this.entryDecode = entryDecode;
        }

        public Builder<K, E> defau(String[] keys, E[] entries) {
            int size = Math.min(keys.length, entries.length);
            for (int i = 0; i < size; ++i) {
                this.defau.put(keys[i], entries[i]);
            }
            return this;
        }

        public Builder<K, E> example(String[] keys, E[] entries) {
            int size = Math.min(keys.length, entries.length);
            for (int i = 0; i < size; ++i) {
                this.example.put(keys[i], entries[i]);
            }
            return this;
        }

        public Builder<K, E> validate(BiPredicate<String, E> validate) {
            this.validator = validate;
            return this;
        }

        public Builder<K, E> clamp(UnaryOperator<E> clamp) {
            this.clamp = clamp;
            return this;
        }

        public Builder<K, E> comment(String comment) {
            this.comment = comment;
            return this;
        }

        public MapConfigVariant<K, E> build(String name) {
            return new MapConfigVariant<K, E>(name, this.defau, this.comment, this.keyEncode, this.keyDecode, this.entryEncode, this.entryDecode, this.validator, this.clamp, this.example);
        }
    }
}

