/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.items;

import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.Traits;
import com.google.common.collect.Lists;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.apache.commons.lang3.math.Fraction;

public abstract class AbstractBurlapSackEntity
extends class_2586
implements class_1263 {
    protected static final class_2561 NAME = class_2561.method_43470((String)"Burlap Sack");
    private List<class_1799> stacks = Lists.newArrayList();

    public AbstractBurlapSackEntity(class_2338 pPos, class_2680 pBlockState) {
        super(Services.PLATFORM.getBurlapSackEntityType(), pPos, pBlockState);
    }

    protected void method_11007(class_2487 pTag, class_7225.class_7874 pRegistries) {
        super.method_11007(pTag, pRegistries);
        DataResult result = Traits.STACKS_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.stacks);
        result.ifSuccess(tag -> pTag.method_10566("stacks", tag));
    }

    protected void method_11014(class_2487 pTag, class_7225.class_7874 pRegistries) {
        super.method_11014(pTag, pRegistries);
        DataResult result = Traits.STACKS_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)pTag.method_10580("stacks"));
        result.ifSuccess(stacks -> {
            this.stacks.clear();
            this.stacks.addAll((Collection<class_1799>)stacks);
        });
    }

    public abstract void openMenu(class_1657 var1);

    public List<class_1799> getItemStacks() {
        return this.stacks;
    }

    public int getSize() {
        return this.stacks.size();
    }

    public int getRemainingSpace(class_1799 input) {
        Fraction size = Fraction.getFraction((int)16, (int)1);
        Fraction weight = Traits.getWeight(this.getItemStacks());
        Fraction weightLeft = size.subtract(weight);
        return Math.max(weightLeft.divideBy(Traits.getItemWeight(input)).intValue(), 0);
    }

    public void addItem(class_1799 input) {
        this.addItem(this.getSize(), input);
    }

    public void addItem(int slot, class_1799 input) {
        this.addItem(slot, input, input.method_7947());
    }

    public void addItem(int slot, class_1799 input, int increment) {
        if (input.method_7960()) {
            return;
        }
        int space = this.getRemainingSpace(input);
        int toAdd = Math.min(increment, space);
        if (toAdd == 0) {
            return;
        }
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            class_1799 stored = this.getItemStacks().get(i);
            if (!class_1799.method_31577((class_1799)input, (class_1799)stored)) continue;
            stored.method_7933(toAdd);
            input.method_7934(toAdd);
            this.getItemStacks().remove(i);
            int min = Math.min(size - 1, slot);
            this.getItemStacks().add(min, stored);
            this.method_5431();
            return;
        }
        int min = Math.min(size, slot);
        this.getItemStacks().add(min, input.method_46651(toAdd));
        input.method_7934(toAdd);
        this.method_5431();
    }

    public class_1799 method_5434(int slot, int amount) {
        int size = this.getSize();
        if (slot >= size) {
            return class_1799.field_8037;
        }
        class_1799 stack = this.getItemStacks().get(slot);
        amount = Math.min(stack.method_7914(), amount);
        int count = stack.method_7947();
        if (count <= amount) {
            class_1799 removed = this.getItemStacks().remove(slot);
            this.method_5431();
            return removed;
        }
        class_1799 removed = stack.method_46651(amount);
        stack.method_7934(amount);
        return removed;
    }

    public class_1799 method_5441(int slot) {
        return this.getSize() > slot ? this.getItemStacks().remove(slot) : class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
        int size = this.getSize();
        boolean isEmpty = stack.method_7960();
        if (!isEmpty) {
            if (size > slot) {
                this.getItemStacks().set(slot, stack);
            } else {
                this.getItemStacks().add(size, stack);
            }
        } else if (size > slot) {
            this.getItemStacks().remove(slot);
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public int method_5439() {
        int i = 1 - Traits.getWeight(this.stacks, 16).intValue();
        int value = this.getSize() + i;
        return value;
    }

    public boolean method_5437(int pSlot, class_1799 pStack) {
        return Traits.getWeight(this.stacks, 16).intValue() != 1;
    }

    public boolean method_5442() {
        return this.stacks.isEmpty();
    }

    public class_1799 method_5438(int slot) {
        return this.getSize() > slot ? this.getItemStacks().get(slot) : class_1799.field_8037;
    }

    public void dropAll() {
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_1263)this);
    }

    public void method_5448() {
    }
}

