/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.client;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.access.EquipmentSlotAccess;
import com.beansgalaxy.backpacks.access.TraitMenuAccessor;
import com.beansgalaxy.backpacks.data.config.ClientConfig;
import com.beansgalaxy.backpacks.screen.TraitMenu;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.DraggingContainer;
import com.beansgalaxy.backpacks.traits.abstract_traits.IDraggingTrait;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5630;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class AbstractScreenMixin<T extends class_1703>
extends class_437
implements TraitMenuAccessor {
    @Shadow
    protected class_1735 field_2787;
    @Shadow
    @Final
    protected T field_2797;
    @Shadow
    protected boolean field_2794;
    @Shadow
    private boolean field_2798;
    @Shadow
    @Nullable
    private class_1735 field_2799;
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    private int field_2786;
    @Shadow
    protected int field_2779;
    @Shadow
    protected int field_2792;
    @Unique
    private List<TraitMenu<?>> traitMenus = new ArrayList();
    private final DraggingContainer drag = new DraggingContainer(){

        @Override
        public void slotClicked(class_1735 slot, int slotId, int mouseButton, class_1713 type) {
            AbstractScreenMixin.this.method_2383(slot, slotId, mouseButton, type);
        }
    };

    @Shadow
    @Nullable
    protected abstract class_1735 method_2386(double var1, double var3);

    @Shadow
    protected abstract void method_2383(class_1735 var1, int var2, int var3, class_1713 var4);

    @Shadow
    public abstract T method_17577();

    protected AbstractScreenMixin(class_2561 pTitle) {
        super(pTitle);
    }

    @Override
    public void clickTraitMenu(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (!this.traitMenus.isEmpty()) {
            Iterator<TraitMenu<?>> iterator = this.traitMenus.iterator();
            while (iterator.hasNext() && !cir.isCancelled()) {
                TraitMenu<?> traitMenu = iterator.next();
                if (traitMenu.isHoveringSlot((int)pMouseX, (int)pMouseY)) {
                    boolean doubleClick;
                    long i = class_156.method_658();
                    boolean bl = doubleClick = i - traitMenu.timeOpened < 250L && this.field_2786 == pButton;
                    if (doubleClick) {
                        cir.setReturnValue((Object)true);
                        return;
                    }
                    iterator.remove();
                    if (pButton != 1) continue;
                    this.field_2798 = true;
                    cir.setReturnValue((Object)true);
                    return;
                }
                traitMenu.mouseClicked(pMouseX, pMouseY, pButton, cir);
                if (!cir.isCancelled()) continue;
                iterator.remove();
                this.traitMenus.addFirst(traitMenu);
                this.field_2798 = true;
                return;
            }
        }
    }

    @Unique
    private boolean shouldMakeNewMenu(int mButton) {
        if (mButton == 1) {
            return true;
        }
        if (mButton == 0) {
            if (BackData.get((class_1657)this.field_22787.field_1724).isMenuKeyDown()) {
                return true;
            }
            if (this.field_2787 instanceof EquipmentSlotAccess) {
                return this.field_22787.field_1724.method_7337() || !this.field_2787.method_7674((class_1657)this.field_22787.field_1724) || !this.field_2787.method_7680(this.field_2797.method_34255());
            }
        }
        return false;
    }

    @Inject(method={"mouseClicked"}, cancellable=true, at={@At(value="HEAD")})
    private void mouseClicked(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (this.field_2787 != null) {
            if (this.shouldMakeNewMenu(pButton)) {
                TraitMenu<?> menu = TraitMenu.create(this.field_22787, this.field_2776, this.field_2800, this.field_2779, this.field_2792, this.field_2787);
                if (menu != null) {
                    this.traitMenus.addFirst(menu);
                    ClientConfig config = CommonClass.CLIENT_CONFIG;
                    if (!((Boolean)config.hide_bundle_tutorial.get()).booleanValue()) {
                        config.hide_bundle_tutorial.set(true);
                        config.write();
                    }
                }
            } else if (this.field_2797.method_34255().method_7960() && this.field_2787.method_7681() && this.field_22787.field_1690.field_1871.method_1433(pButton)) {
                BackpackTraits.runIfEquipped((class_1657)this.field_22787.field_1724, (traits, slot) -> {
                    class_746 player = this.field_22787.field_1724;
                    class_5630 access = class_5630.method_59666(() -> this.field_2797.method_34255(), arg_0 -> this.field_2797.method_34254(arg_0));
                    return traits.pickItemClient((class_1657)player, (class_1304)slot, access, (class_1703)this.field_2797, this.field_2787.method_7677(), cir);
                });
            }
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        this.traitMenus = new ArrayList();
    }

    public boolean method_25422() {
        if (this.traitMenus.isEmpty()) {
            return super.method_25422();
        }
        this.traitMenus = new ArrayList();
        return false;
    }

    @Inject(method={"keyPressed"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;checkHotbarKeyPressed(II)Z")})
    private void keyPressed(int pKeyCode, int pScanCode, int pModifiers, CallbackInfoReturnable<Boolean> cir) {
        boolean dropButtonWasPressed = this.field_22787.field_1690.field_1869.method_1417(pKeyCode, pScanCode);
        if (dropButtonWasPressed) {
            Iterator<TraitMenu<?>> iterator = this.traitMenus.iterator();
            while (iterator.hasNext() && !cir.isCancelled()) {
                TraitMenu<?> menu = iterator.next();
                menu.dropHoveredItem(cir);
            }
        }
    }

    @Inject(method={"isHovering(IIIIDD)Z"}, cancellable=true, at={@At(value="HEAD")})
    private void isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY, CallbackInfoReturnable<Boolean> cir) {
        for (TraitMenu<?> traitMenu : this.traitMenus) {
            if (!traitMenu.isHovering((int)pMouseX, (int)pMouseY)) continue;
            cir.setReturnValue((Object)false);
            return;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V")})
    protected void renderTooltip(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        class_1799 stack;
        TraitMenu<?> focusedMenu = null;
        for (TraitMenu<?> traitMenu : this.traitMenus) {
            if (focusedMenu == null && traitMenu.isHovering(pMouseX, pMouseY)) {
                focusedMenu = traitMenu;
                focusedMenu.setFocus(true);
                continue;
            }
            traitMenu.setFocus(false);
        }
        if (focusedMenu != null) {
            this.traitMenus.remove(focusedMenu);
            this.traitMenus.addFirst(focusedMenu);
        }
        class_4587 pose = pGuiGraphics.method_51448();
        pGuiGraphics.method_44379(0, 0, this.field_22789, this.field_22790);
        int i = this.traitMenus.size();
        while (i > 0) {
            TraitMenu<?> traitMenu = this.traitMenus.get(--i);
            traitMenu.render((class_465)this, pGuiGraphics, pMouseX, pMouseY);
            pose.method_46416(0.0f, 0.0f, 300.0f);
        }
        pGuiGraphics.method_44380();
        if (this.field_2787 != null && !(stack = this.field_2787.method_7677()).method_7960() && !((Boolean)CommonClass.CLIENT_CONFIG.hide_bundle_tutorial.get()).booleanValue()) {
            Optional<BundleLikeTraits> optional = BundleLikeTraits.get(ComponentHolder.of(stack));
            optional.ifPresent(traits -> {
                if (traits instanceof BackpackTraits && !(this.field_2787 instanceof EquipmentSlotAccess)) {
                    return;
                }
                CommonClient.renderInfoTooltip(pGuiGraphics, pMouseX - this.field_2776, pMouseY - this.field_2800, this.field_2787, traits);
            });
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void movePose(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        pGuiGraphics.method_51448().method_46416(0.0f, 0.0f, (float)(this.traitMenus.size() * 300));
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        int scrolled;
        int containerId;
        class_638 level;
        class_1799 stack;
        if (this.field_2787 != null && CommonClient.scrollTraits((class_1657)this.field_22787.field_1724, stack = this.field_2787.method_7677(), (class_1937)(level = this.field_22787.field_1687), containerId = ((class_1703)this.field_2797).field_7763, scrolled = class_3532.method_15357((double)(pScrollY + 0.5)), this.field_2787)) {
            return true;
        }
        return super.method_25401(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    public void backpackDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY, CallbackInfoReturnable<Boolean> cir) {
        TraitMenu<?> traitMenu;
        if (!this.traitMenus.isEmpty() && (traitMenu = this.traitMenus.getFirst()).isFocused()) {
            traitMenu.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY, cir);
            if (cir.isCancelled()) {
                return;
            }
        }
        class_1799 backpack = this.field_2797.method_34255();
        class_1735 slot = this.method_2386(pMouseX, pMouseY);
        if (backpack.method_7960()) {
            return;
        }
        if (slot != this.field_2799 && slot != this.drag.firstSlot) {
            IDraggingTrait.runIfPresent(backpack, (class_1937)this.field_22787.field_1687, (trait, holder) -> this.beans_Backpacks_3$dragTrait((IDraggingTrait)trait, pButton, slot, cir, (ComponentHolder)holder));
        }
    }

    @Unique
    private void beans_Backpacks_3$dragTrait(IDraggingTrait traits, int pButton, class_1735 slot, CallbackInfoReturnable<Boolean> cir, ComponentHolder holder) {
        this.field_2794 = false;
        this.field_2798 = true;
        if (this.drag.allSlots.isEmpty()) {
            boolean bl = this.drag.isPickup = pButton == 0;
            if (this.drag.firstSlot != null) {
                traits.clickSlot(this.drag, (class_1657)this.field_22787.field_1724, holder);
            } else if (this.field_2799 != null) {
                this.drag.firstSlot = this.field_2799;
                traits.clickSlot(this.drag, (class_1657)this.field_22787.field_1724, holder);
            }
        } else if (this.drag.firstSlot != null) {
            traits.clickSlot(this.drag, (class_1657)this.field_22787.field_1724, holder);
        }
        this.drag.firstSlot = slot;
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")})
    public void backpackReleased(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (!this.drag.allSlots.isEmpty()) {
            if (this.drag.firstSlot != null) {
                class_1799 backpack = this.field_2797.method_34255();
                IDraggingTrait.runIfPresent(backpack, (class_1937)this.field_22787.field_1687, (trait, holder) -> trait.clickSlot(this.drag, (class_1657)this.field_22787.field_1724, ComponentHolder.of(backpack)));
                this.drag.firstSlot = null;
            }
            this.drag.allSlots.clear();
        }
    }

    @Inject(method={"renderSlot"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V")})
    public void renderBackpackDraggedSlot(class_332 pGuiGraphics, class_1735 pSlot, CallbackInfo ci) {
        class_1799 pair = this.drag.allSlots.get(pSlot);
        if (pair != null) {
            int i = pSlot.field_7873;
            int j = pSlot.field_7872;
            if (this.drag.isPickup) {
                pGuiGraphics.method_51445(pair, i, j);
                if (pSlot.method_7677().method_7947() == 1) {
                    class_4587 pose = pGuiGraphics.method_51448();
                    pose.method_22903();
                    pose.method_46416(0.0f, 0.0f, 200.0f);
                    String pText = String.valueOf(1);
                    pGuiGraphics.method_51433(this.field_22793, pText, i + 19 - 2 - this.field_22793.method_1727(pText), j + 6 + 3, 0xFFFFFF, true);
                    pose.method_22909();
                }
            }
            pGuiGraphics.method_51737(i, j, i + 16, j + 16, this.drag.isPickup ? 200 : 0, -2130706433);
        }
    }

    @Inject(method={"slotClicked"}, cancellable=true, at={@At(value="HEAD")})
    private void slotClicked(class_1735 pSlot, int pSlotId, int pMouseButton, class_1713 pType, CallbackInfo ci) {
        if (pSlot == null || pType != class_1713.field_7793) {
            return;
        }
        Optional<GenericTraits> traits = Traits.get(this.field_2797.method_34255());
        if (traits.isEmpty()) {
            return;
        }
        this.field_22787.field_1761.method_2906(((class_1703)this.field_2797).field_7763, pSlot.field_7874, pMouseButton, class_1713.field_7790, (class_1657)this.field_22787.field_1724);
        TraitMenu<?> menu = TraitMenu.create(this.field_22787, this.field_2776, this.field_2800, this.field_2779, this.field_2792, this.field_2787);
        if (menu != null) {
            this.traitMenus.addFirst(menu);
        }
        ci.cancel();
    }
}

