/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.ISlotSelectorTrait;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.quiver.QuiverTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.datafixers.util.Function4;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1661.class})
public abstract class InventoryMixin
implements BackData {
    @Shadow
    @Final
    public class_1657 field_7546;
    @Shadow
    @Final
    public class_2371<class_1799> field_7547;
    @Unique
    @Final
    public class_1661 instance = (class_1661)this;
    private long lastFailedTraitScroll = 0L;

    @Shadow
    public abstract class_1799 method_5438(int var1);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tickCarriedBackpack(CallbackInfo ci) {
        class_1799 carried = this.field_7546.field_7512.method_34255();
        class_1937 level = this.field_7546.method_37908();
        Traits.get(carried).ifPresent(traits -> carried.method_7917(level, (class_1297)this.field_7546, -1, false));
        this.getUtility().tick(this.instance);
        for (class_1735 slot : this.field_7546.field_7512.field_7761) {
            class_1799 stack = slot.method_7677();
            EnderTraits.get(stack).ifPresent(enderTraits -> {
                class_1657 patt0$temp;
                if (!enderTraits.isLoaded()) {
                    enderTraits.reload(level);
                }
                if ((patt0$temp = this.field_7546) instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)patt0$temp;
                    enderTraits.addListener(serverPlayer);
                }
            });
        }
    }

    @Inject(method={"add(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void addToBackpackBeforeInventory(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (!stack.method_7960()) {
            BackpackTraits bpackTraits = BackpackTraits.get(stack);
            if (bpackTraits != null && bpackTraits.isEmpty(ComponentHolder.of(stack))) {
                for (class_1304 value : bpackTraits.slots().getValues()) {
                    class_1799 itemBySlot = this.field_7546.method_6118(value);
                    if (!itemBySlot.method_7960()) continue;
                    this.field_7546.method_5673(value, stack.method_7972());
                    stack.method_7939(0);
                    cir.setReturnValue((Object)true);
                    return;
                }
                if (!this.field_7546.method_7337()) {
                    cir.setReturnValue((Object)false);
                    return;
                }
            }
            BackpackTraits.runIfEquipped(this.field_7546, (traits, equipmentSlot) -> {
                class_1799 backpack = this.field_7546.method_6118(equipmentSlot);
                return traits.pickupToBackpack(this.field_7546, (class_1304)equipmentSlot, this.instance, backpack, stack, cir);
            });
            QuiverTraits.runIfPresent(this.field_7546, (Function4<QuiverTraits, Integer, class_1799, ComponentHolder, Boolean>)((Function4)(traits, slot, itemStack, holder) -> traits.pickupToQuiver(this.field_7546, (int)slot, (class_1799)itemStack, stack, cir)));
        }
    }

    @Inject(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void addToBackpackAfterInventory(int $$0, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            BackpackTraits.runIfEquipped(this.field_7546, (traits, equipmentSlot) -> traits.overflowFromInventory((class_1304)equipmentSlot, this.field_7546, stack, cir));
        }
    }

    @Inject(method={"swapPaint"}, cancellable=true, at={@At(value="HEAD")})
    private void selectBackpackSlot(double pDirection, CallbackInfo ci) {
        if (this.field_7546.method_37908().field_9236) {
            long millis = class_156.method_658();
            if (!BackData.get(this.field_7546).isActionKeyDown()) {
                this.lastFailedTraitScroll = millis;
                return;
            }
            if (millis - this.lastFailedTraitScroll < 550L) {
                this.lastFailedTraitScroll = millis;
                return;
            }
            class_1799 inHand = this.field_7546.method_5998(class_1268.field_5808);
            ISlotSelectorTrait trait = ISlotSelectorTrait.get(inHand);
            if (trait == null) {
                this.lastFailedTraitScroll = millis;
                return;
            }
            trait.mouseScrolled(this.field_7546, ComponentHolder.of(inHand), -1, -1, (int)Math.signum(pDirection));
            ci.cancel();
        }
    }
}

