/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits;

import com.beansgalaxy.backpacks.components.SlotSelection;
import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9288;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public abstract class ITraitData<T> {
    public static final TraitDataComponentType<List<class_1799>> ITEM_STACKS = ITraitData.register("data_item_list", Traits.STACKS_CODEC, class_1799.field_48350, ItemList::new);
    public static final TraitDataComponentType<List<class_1799>> NON_EDIBLES = ITraitData.register("data_non_edible", class_1799.field_24671.listOf(), class_1799.field_48350, NonEdibles::new);
    public static final class_9331<class_9288> CHEST = Traits.register("data_chest", class_9288.field_49335, class_9288.field_49336);
    public static final TraitDataComponentType<class_1799> SOLO_STACK = ITraitData.register("data_solo_item", class_1799.field_49266, class_1799.field_49268, SoloItem::new);
    public static final TraitDataComponentType<Integer> AMOUNT = ITraitData.register("data_amount", class_5699.field_33441, class_9135.field_49675, Amount::new);
    public static final class_9331<SlotSelection> SLOT_SELECTION = Traits.register("data_selection", Codec.unit(SlotSelection::new), SlotSelection.STREAM_CODEC);
    public static final class_9331<UtilityComponent> UTILITIES = Traits.register("utility_slots", UtilityComponent.CODEC, UtilityComponent.STREAM_CODEC);
    protected T value = null;
    boolean isDirty = false;
    protected final ComponentHolder holder;

    public static void register() {
    }

    public static <T> TraitDataComponentType<T> register(String name, Codec<T> codec, class_9139<? super class_9129, T> streamCodec, Function<ComponentHolder, ITraitData<T>> getData) {
        TraitDataComponentType<T> type = new TraitDataComponentType<T>(codec, streamCodec, getData);
        Services.PLATFORM.register(name, type);
        return type;
    }

    @Nullable
    public T remove() {
        return this.holder().remove(this.type());
    }

    public abstract class_9331<T> type();

    public abstract boolean isEmpty(T var1);

    public boolean isEmpty() {
        if (this.value != null) {
            return this.isEmpty(this.value);
        }
        T data = this.holder().get(this.type());
        return data == null || this.isEmpty(data);
    }

    protected ITraitData(ComponentHolder holder) {
        this.holder = holder;
    }

    public ComponentHolder holder() {
        return this.holder;
    }

    public abstract T get();

    public void markDirty() {
        this.isDirty = true;
    }

    public void push() {
        if (this.isEmpty()) {
            this.holder().remove(this.type());
        } else if (this.isDirty) {
            this.holder().set(this.type(), this.value);
        }
    }

    public ITraitData<T> set(T value) {
        this.markDirty();
        this.value = value;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ITraitData that = (ITraitData)obj;
        return Objects.equals(this.holder(), that.holder()) && Objects.equals(this.value, that.value);
    }

    public static class TraitDataComponentType<T>
    implements class_9331<T> {
        private final Codec<T> codec;
        private final class_9139<? super class_9129, T> streamCodec;
        private final Function<ComponentHolder, ITraitData<T>> getData;

        public TraitDataComponentType(Codec<T> codec, class_9139<? super class_9129, T> streamCodec, Function<ComponentHolder, ITraitData<T>> getData) {
            this.codec = codec;
            this.streamCodec = streamCodec;
            this.getData = getData;
        }

        @Nullable
        public Codec<T> method_57875() {
            return this.codec;
        }

        public class_9139<? super class_9129, T> method_57878() {
            return this.streamCodec;
        }

        public ITraitData<T> get(ComponentHolder holder) {
            return this.getData.apply(holder);
        }
    }

    static class Amount
    extends ITraitData<Integer> {
        public Amount(ComponentHolder holder) {
            super(holder);
        }

        @Override
        public class_9331<Integer> type() {
            return AMOUNT;
        }

        @Override
        public boolean isEmpty() {
            if (this.value != null) {
                this.markDirty();
                return (Integer)this.value == 0;
            }
            Integer amount = this.holder.get(this.type());
            return amount == null || amount == 0;
        }

        @Override
        public boolean isEmpty(Integer data) {
            return data == 0;
        }

        @Override
        public Integer get() {
            if (this.value == null) {
                this.markDirty();
                Integer t = this.holder().get(this.type());
                this.value = Objects.requireNonNullElse(t, 0);
            }
            return (Integer)this.value;
        }
    }

    static class NonEdibles
    extends ItemList {
        public NonEdibles(ComponentHolder holder) {
            super(holder);
        }

        @Override
        public class_9331<List<class_1799>> type() {
            return NON_EDIBLES;
        }
    }

    static class ItemList
    extends ITraitData<List<class_1799>> {
        public ItemList(ComponentHolder holder) {
            super(holder);
        }

        @Override
        public class_9331<List<class_1799>> type() {
            return ITEM_STACKS;
        }

        @Override
        public List<class_1799> get() {
            if (this.value == null) {
                this.markDirty();
                List<class_1799> t = this.holder().get(this.type());
                this.value = t == null ? new ArrayList() : new ArrayList<class_1799>(t);
            }
            return (List)this.value;
        }

        @Override
        public void push() {
            List<class_1799> stacks;
            List<class_1799> list = stacks = this.value == null ? this.holder.get(this.type()) : (List<class_1799>)this.value;
            if (stacks == null) {
                return;
            }
            this.value = stacks.stream().filter(itemStack -> !itemStack.method_7960()).toList();
            if (((List)this.value).isEmpty()) {
                this.holder.remove(this.type());
            } else if (this.isDirty) {
                this.holder.set(this.type(), (List)this.value);
            }
        }

        @Override
        public boolean isEmpty(List<class_1799> data) {
            return data.isEmpty();
        }
    }

    static class SoloItem
    extends ITraitData<class_1799> {
        public SoloItem(ComponentHolder holder) {
            super(holder);
        }

        @Override
        public class_9331<class_1799> type() {
            return SOLO_STACK;
        }

        @Override
        public class_1799 get() {
            if (this.value == null) {
                this.markDirty();
                class_1799 t = this.holder().get(this.type());
                this.value = Objects.requireNonNullElse(t, class_1799.field_8037);
            }
            return (class_1799)this.value;
        }

        @Override
        public boolean isEmpty(class_1799 data) {
            return data.method_7960();
        }
    }
}

