/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits;

import com.beansgalaxy.backpacks.access.EquipmentSlotAccess;
import com.beansgalaxy.backpacks.components.BulkComponent;
import com.beansgalaxy.backpacks.components.DisplayComponent;
import com.beansgalaxy.backpacks.components.FilterComponent;
import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.components.ender.EmptyEnderItem;
import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.alchemy.AlchemyCodecs;
import com.beansgalaxy.backpacks.traits.alchemy.AlchemyTraits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackCodecs;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.bundle.BundleCodecs;
import com.beansgalaxy.backpacks.traits.bundle.BundleTraits;
import com.beansgalaxy.backpacks.traits.chest.ChestCodecs;
import com.beansgalaxy.backpacks.traits.chest.ChestTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxCodecs;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxTraits;
import com.beansgalaxy.backpacks.traits.quiver.QuiverCodecs;
import com.beansgalaxy.backpacks.traits.quiver.QuiverTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public interface Traits {
    public static final class_9331<BulkComponent> BULK = Traits.register("bulk", BulkComponent.CODEC, BulkComponent.STREAM_CODEC);
    public static final class_9331<DisplayComponent> DISPLAY = Traits.register("display", DisplayComponent.CODEC, DisplayComponent.STREAM_CODEC);
    public static final class_9331<FilterComponent> FILTER = Traits.register("filter", FilterComponent.CODEC, FilterComponent.STREAM_CODEC);
    public static final class_9331<ReferenceTrait> REFERENCE = Traits.register("reference", ReferenceTrait.CODEC, ReferenceTrait.STREAM_CODEC);
    public static final class_9331<EnderTraits> ENDER = Traits.register("ender", EnderTraits.CODEC, EnderTraits.STREAM_CODEC);
    public static final class_9331<EmptyEnderItem.UnboundEnderTraits> EMPTY_ENDER = Traits.register("empty_ender", EmptyEnderItem.CODEC, EmptyEnderItem.STREAM_CODEC);
    public static final TraitComponentKind<BundleTraits> BUNDLE = TraitComponentKind.registerBundleLike("bundle", BundleCodecs.INSTANCE);
    public static final TraitComponentKind<LunchBoxTraits> LUNCH_BOX = TraitComponentKind.registerBundleLike("lunch", LunchBoxCodecs.INSTANCE);
    public static final TraitComponentKind<QuiverTraits> QUIVER = TraitComponentKind.registerBundleLike("quiver", QuiverCodecs.INSTANCE);
    public static final TraitComponentKind<AlchemyTraits> ALCHEMY = TraitComponentKind.registerBundleLike("alchemy", AlchemyCodecs.INSTANCE);
    public static final class_9331<Byte> UTILITIES = Traits.register("utilities", UtilityComponent.SIZE_CODEC, class_9135.field_48548);
    public static final TraitComponentKind<ChestTraits> CHEST = TraitComponentKind.registerBundleLike("chest", ChestCodecs.INSTANCE);
    public static final TraitComponentKind<BackpackTraits> BACKPACK = TraitComponentKind.registerBundleLike("backpack", BackpackCodecs.INSTANCE);
    public static final Codec<List<class_1799>> STACKS_CODEC = Codec.list((Codec)RecordCodecBuilder.create(in -> in.group((App)class_1799.field_47312.fieldOf("id").forGetter(class_1799::method_41409), (App)Codec.INT.fieldOf("count").forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(class_1799::method_57380)).apply((Applicative)in, class_1799::new)));

    public static <T> class_9331<T> register(String name, Codec<T> codec, class_9139<? super class_9129, T> streamCodec) {
        class_9331.class_9332 builder = class_9331.method_57873();
        class_9331 type = builder.method_57881(codec).method_57882(streamCodec).method_59871().method_57880();
        return Services.PLATFORM.register(name, type);
    }

    public static Optional<GenericTraits> get(class_1799 stack) {
        return stack.method_7960() ? Optional.empty() : Traits.get(ComponentHolder.of(stack));
    }

    public static Optional<GenericTraits> get(ComponentHolder stack) {
        for (TraitComponentKind<? extends GenericTraits> type : TraitComponentKind.TRAITS) {
            GenericTraits traits = stack.get(type);
            if (traits == null) continue;
            return Optional.of(traits);
        }
        ReferenceTrait reference = stack.get(REFERENCE);
        if (reference != null) {
            return reference.getTrait();
        }
        return Optional.empty();
    }

    public static void runIfPresent(class_1799 stack, Consumer<GenericTraits> runnable) {
        if (!stack.method_7960()) {
            Optional<GenericTraits> traits = Traits.get(stack);
            traits.ifPresent(runnable);
        }
    }

    public static void runIfPresent(class_1799 stack, Consumer<GenericTraits> runnable, Runnable orElse) {
        if (!stack.method_7960()) {
            Optional<GenericTraits> traits = Traits.get(stack);
            traits.ifPresentOrElse(runnable, orElse);
        } else {
            orElse.run();
        }
    }

    public static boolean testIfPresent(class_1799 stack, Predicate<GenericTraits> predicate) {
        if (stack.method_7960()) {
            return false;
        }
        return Traits.testIfPresent(ComponentHolder.of(stack), predicate);
    }

    public static boolean testIfPresent(ComponentHolder stack, Predicate<GenericTraits> predicate) {
        Optional<GenericTraits> genericTraits = Traits.get(stack);
        if (genericTraits.isEmpty()) {
            return false;
        }
        GenericTraits traits = genericTraits.get();
        return predicate.test(traits);
    }

    public static void runIfEquipped(class_1657 player, BiPredicate<GenericTraits, class_1304> runnable) {
        class_2371 slots = player.field_7498.field_7761;
        for (int i = slots.size() - 1; i > 4; --i) {
            Optional<GenericTraits> traits;
            class_1735 slot = (class_1735)slots.get(i);
            if (!(slot instanceof EquipmentSlotAccess)) continue;
            EquipmentSlotAccess access = (EquipmentSlotAccess)slot;
            class_1799 stack = slot.method_7677();
            if (stack.method_7960() || (traits = Traits.get(stack)).isEmpty() || !runnable.test(traits.get(), access.getSlot())) continue;
            return;
        }
    }

    public static Fraction getWeight(List<class_1799> stacks) {
        if (stacks.isEmpty()) {
            return Fraction.ZERO;
        }
        Fraction fraction = Fraction.ZERO;
        for (class_1799 stack : stacks) {
            Fraction stackWeight = Traits.getStackWeight(stack);
            fraction = fraction.add(stackWeight);
        }
        return fraction;
    }

    public static Fraction getWeight(List<class_1799> stacks, int size) {
        return Traits.getWeight(stacks).multiplyBy(Fraction.getFraction((int)1, (int)size));
    }

    public static Fraction getStackWeight(class_1799 stack) {
        return Fraction.getFraction((int)stack.method_7947(), (int)stack.method_7914());
    }

    public static Fraction getItemWeight(class_1799 stack) {
        return Fraction.getFraction((int)1, (int)stack.method_7914());
    }

    public static void register() {
    }

    @Nullable
    public static <T extends GenericTraits> T get(ComponentHolder backpack, TraitComponentKind<T> kind) {
        GenericTraits genericTraits;
        Optional<GenericTraits> reference;
        GenericTraits traits = (GenericTraits)backpack.get(kind);
        if (traits != null) {
            return (T)traits;
        }
        ReferenceTrait referenceTrait = backpack.get(REFERENCE);
        if (referenceTrait != null && (reference = referenceTrait.getTrait()).isPresent() && kind.equals((genericTraits = reference.get()).kind())) {
            return (T)genericTraits;
        }
        return null;
    }

    @Nullable
    public static <T extends GenericTraits> T get(ComponentHolder backpack, TraitComponentKind<T>[] kinds) {
        for (TraitComponentKind<T> kind : kinds) {
            GenericTraits traits = (GenericTraits)backpack.get(kind);
            if (traits == null) continue;
            return (T)traits;
        }
        ReferenceTrait referenceTrait = backpack.get(REFERENCE);
        if (referenceTrait == null) {
            return null;
        }
        Optional<GenericTraits> reference = referenceTrait.getTrait();
        if (reference.isEmpty()) {
            return null;
        }
        GenericTraits genericTraits = reference.get();
        for (TraitComponentKind<T> kind : kinds) {
            if (!kind.equals(genericTraits.kind())) continue;
            return (T)genericTraits;
        }
        return null;
    }
}

