/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.abstract_traits;

import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.DraggingContainer;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public interface IDraggingTrait {
    public static final TraitComponentKind<? extends IDraggingTrait>[] TRAITS = new TraitComponentKind[]{Traits.BUNDLE, Traits.LUNCH_BOX, Traits.ALCHEMY, Traits.QUIVER, Traits.CHEST};

    @Nullable
    public static IDraggingTrait get(ComponentHolder backpack) {
        GenericTraits genericTraits;
        for (TraitComponentKind<? extends IDraggingTrait> kind : TRAITS) {
            IDraggingTrait traits = backpack.get(kind);
            if (traits == null) continue;
            return traits;
        }
        ReferenceTrait referenceTrait = backpack.get(Traits.REFERENCE);
        if (referenceTrait == null) {
            return null;
        }
        Optional<GenericTraits> reference = referenceTrait.getTrait();
        if (!reference.isEmpty() && (genericTraits = reference.get()) instanceof IDraggingTrait) {
            IDraggingTrait draggingTrait = (IDraggingTrait)((Object)genericTraits);
            return draggingTrait;
        }
        return null;
    }

    public static void runIfPresent(class_1799 backpack, class_1937 level, BiConsumer<IDraggingTrait, ComponentHolder> consumer) {
        EnderTraits enderTraits;
        GenericTraits trait;
        ComponentHolder holder = ComponentHolder.of(backpack);
        IDraggingTrait draggingTrait = IDraggingTrait.get(holder);
        if (draggingTrait != null) {
            consumer.accept(draggingTrait, holder);
            return;
        }
        Optional<EnderTraits> optionalEnder = EnderTraits.get(backpack);
        if (optionalEnder.isPresent() && (trait = (enderTraits = optionalEnder.get()).getTrait(level)) instanceof IDraggingTrait) {
            IDraggingTrait storageTraits = (IDraggingTrait)((Object)trait);
            consumer.accept(storageTraits, enderTraits);
        }
    }

    default public void clickSlot(DraggingContainer drag, class_1657 player, ComponentHolder holder) {
        class_1735 slot = drag.firstSlot;
        if (drag.isPickup) {
            class_1799 stack = slot.method_7677();
            boolean mayPickup = slot.method_7674(player);
            boolean hasItem = slot.method_7681();
            boolean canFit = this.canItemFit(holder, stack);
            boolean isFull = this.isFull(holder);
            if (mayPickup && hasItem && canFit && !isFull) {
                drag.allSlots.put(drag.firstSlot, stack.method_46651(1));
                drag.slotClicked(slot, slot.field_7874, 1, class_1713.field_7790);
            }
        } else {
            class_1799 itemStack = this.getFirst(holder);
            if (itemStack != null && !slot.method_7681() && class_1703.method_7592((class_1735)slot, (class_1799)itemStack, (boolean)true) && slot.method_7680(itemStack)) {
                drag.allSlots.put(slot, class_1799.field_8037);
                drag.slotClicked(slot, slot.field_7874, 1, class_1713.field_7790);
            }
        }
    }

    public class_1799 getFirst(ComponentHolder var1);

    public boolean isFull(ComponentHolder var1);

    public boolean canItemFit(ComponentHolder var1, class_1799 var2);
}

