/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.backpack;

import com.beansgalaxy.backpacks.components.equipable.EquipmentGroups;
import com.beansgalaxy.backpacks.network.serverbound.PickBlock;
import com.beansgalaxy.backpacks.network.serverbound.PickItem;
import com.beansgalaxy.backpacks.traits.IEntityTraits;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackClient;
import com.beansgalaxy.backpacks.traits.backpack.BackpackMutable;
import com.beansgalaxy.backpacks.traits.bundle.BundleHopper;
import com.beansgalaxy.backpacks.traits.bundle.BundleScreen;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2744;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5819;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class BackpackTraits
extends BundleLikeTraits
implements IEntityTraits<BackpackTraits> {
    public static final String NAME = "backpack";
    private final EquipmentGroups slot;
    private final class_2960 texture;

    public BackpackTraits(ModSound sound, int size, EquipmentGroups slot, class_2960 texture) {
        super(sound, size);
        this.slot = slot;
        this.texture = texture;
    }

    @Nullable
    public static BackpackTraits get(class_1799 stack) {
        return Traits.get(ComponentHolder.of(stack), Traits.BACKPACK);
    }

    public static void runAllEquipped(class_1309 entity, BiConsumer<BackpackTraits, class_1304> runnable) {
        class_1304[] values = class_1304.values();
        for (int i = values.length - 1; i >= 0; --i) {
            class_1304 slot = values[i];
            class_1799 backpack = entity.method_6118(slot);
            BackpackTraits traits = BackpackTraits.get(backpack);
            if (traits == null) continue;
            runnable.accept(traits, slot);
        }
    }

    public static void runIfEquipped(class_1657 player, BiPredicate<BackpackTraits, class_1304> runnable) {
        class_1304[] values = class_1304.values();
        int size = values.length;
        for (int i = size - 1; i >= 0; --i) {
            BackpackTraits traits;
            class_1304 slot = values[i];
            class_1799 stack = player.method_6118(slot);
            if (stack.method_7960() || (traits = BackpackTraits.get(stack)) == null || !traits.slots().test(slot) || !runnable.test(traits, slot)) continue;
            return;
        }
    }

    @Override
    public void use(class_1937 level, class_1657 player, class_1268 hand, ComponentHolder holder, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        class_1799 backpack = player.method_5998(hand);
        class_1304 slotCanidate = null;
        for (class_1304 value : this.slots().getValues()) {
            boolean isEmpty;
            class_1799 equipped = player.method_6118(value);
            if (equipped.method_7960()) {
                player.method_5673(value, backpack);
                player.method_6122(hand, class_1799.field_8037);
                cir.setReturnValue((Object)class_1271.method_22427((Object)backpack));
                return;
            }
            if (slotCanidate != null) continue;
            if (player.method_7337()) {
                slotCanidate = value;
                continue;
            }
            boolean hasBinding = class_1890.method_60142((class_1799)equipped, (class_9331)class_9701.field_51656);
            boolean bl = isEmpty = !Traits.testIfPresent(equipped, traits -> !traits.isEmpty(equipped));
            if (hasBinding || !isEmpty) continue;
            slotCanidate = value;
        }
        if (slotCanidate != null) {
            class_1799 equipped = player.method_6118(slotCanidate);
            player.method_5673(slotCanidate, backpack);
            player.method_6122(hand, equipped);
            cir.setReturnValue((Object)class_1271.method_22427((Object)backpack));
        }
    }

    @Override
    public void stackedOnOther(ComponentHolder backpack, class_1799 other, class_1735 slot, class_5536 click, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
    }

    public boolean pickupToBackpack(class_1657 player, class_1304 equipmentSlot, class_1661 inventory, class_1799 backpack, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (!this.isFull(backpack)) {
            inventory.field_7547.forEach(stacks -> {
                if (class_1799.method_31577((class_1799)stacks, (class_1799)stack)) {
                    int present = stacks.method_7947();
                    int inserted = stack.method_7947();
                    int count = present + inserted;
                    int remainder = Math.max(0, count - stack.method_7914());
                    stacks.method_7939(count -= remainder);
                    stack.method_7939(remainder);
                }
            });
            if (stack.method_7960()) {
                cir.setReturnValue((Object)true);
                return true;
            }
            BackpackMutable mutable = this.mutable(ComponentHolder.of(backpack));
            Iterator<class_1799> iterator = mutable.getItemStacks().iterator();
            while (iterator.hasNext() && !stack.method_7960()) {
                class_1799 returnStack;
                class_1799 itemStack = iterator.next();
                if (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack) || (returnStack = mutable.addItem(stack)) == null) continue;
                cir.setReturnValue((Object)true);
            }
            if (cir.isCancelled() && ((Boolean)cir.getReturnValue()).booleanValue()) {
                this.sound().toClient(player, ModSound.Type.INSERT, 1.0f, 1.0f);
                mutable.push();
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    List<Pair> pSlots = List.of(Pair.of((Object)equipmentSlot, (Object)backpack));
                    class_2744 packet = new class_2744(serverPlayer.method_5628(), pSlots);
                    serverPlayer.method_51469().method_14178().method_18751((class_1297)serverPlayer, (class_2596)packet);
                }
            }
            return stack.method_7960();
        }
        return false;
    }

    @Override
    public EquipmentGroups slots() {
        return this.slot;
    }

    @Override
    public String name() {
        return NAME;
    }

    public BackpackClient client() {
        return BackpackClient.INSTANCE;
    }

    @Override
    public TraitComponentKind<? extends GenericTraits> kind() {
        return Traits.BACKPACK;
    }

    @Override
    public BackpackMutable mutable(ComponentHolder holder) {
        return new BackpackMutable(this, holder);
    }

    @Override
    public class_2960 getTexture() {
        return this.texture;
    }

    @Override
    public void hotkeyThrow(class_1735 slot, ComponentHolder backpack, int button, class_1657 player, boolean menuKeyDown, CallbackInfo ci) {
        class_1799 itemStack;
        if (this.isEmpty(backpack)) {
            return;
        }
        BackpackMutable mutable = this.mutable(backpack);
        int selectedSlot = mutable.getSelectedSlot(player);
        class_1799 removed = menuKeyDown ? mutable.removeItem(selectedSlot) : ((itemStack = mutable.getItemStacks().get(selectedSlot)).method_7947() == 1 ? mutable.removeItem(selectedSlot) : itemStack.method_7971(1));
        player.method_7328(removed, true);
        this.sound().atClient(player, ModSound.Type.REMOVE);
        mutable.push();
        ci.cancel();
    }

    @Override
    public class_1269 interact(BackpackEntity backpackEntity, class_1657 player, class_1268 hand) {
        if (player.method_37908().field_9236) {
            BundleScreen.openScreen(player, backpackEntity.viewable, this);
        }
        return class_1269.field_5812;
    }

    @Override
    public void onBreak(BackpackEntity backpack, boolean dropItems) {
        List<class_1799> stacks = backpack.get(ITraitData.ITEM_STACKS);
        if (stacks == null) {
            return;
        }
        class_1937 level = backpack.method_37908();
        double x = backpack.method_23317();
        double y = backpack.method_23318();
        double z = backpack.method_23321();
        if (dropItems && !level.field_9236) {
            for (class_1799 stack : stacks) {
                class_1542 itementity = new class_1542(level, x, y, z, stack);
                itementity.method_6988();
                class_5819 random = backpack.method_59922();
                double a = random.method_43058() - 0.5;
                double b = a * Math.abs(a);
                double c = random.method_43058() - 0.5;
                double d = c * Math.abs(c);
                class_243 vec3 = new class_243(b, Math.abs(a * c) + 0.5, d).method_1021(0.35);
                itementity.method_18799(vec3);
                level.method_8649((class_1297)itementity);
            }
        }
        backpack.remove(ITraitData.ITEM_STACKS);
    }

    @Override
    public class_1263 createHopperContainer(BackpackEntity backpack) {
        return new BundleHopper(backpack, this);
    }

    public boolean pickItemClient(class_1657 player, class_1304 slot, class_5630 access, class_1703 menu, class_1799 hoveredStack, CallbackInfoReturnable<Boolean> cir) {
        class_1799 backpack = player.method_6118(slot);
        BackpackMutable mutable = this.mutable(ComponentHolder.of(backpack));
        List<class_1799> stacks = mutable.getItemStacks();
        for (int i = 0; i < stacks.size(); ++i) {
            int maxStackSize;
            class_1799 stack = stacks.get(i);
            if (!class_1799.method_31577((class_1799)hoveredStack, (class_1799)stack)) continue;
            int count = stack.method_7947();
            if (count > (maxStackSize = stack.method_7914())) {
                mutable.pickItem(i, maxStackSize, access);
                PickItem.send(menu.field_7763, i, maxStackSize, slot);
            } else {
                mutable.pickItem(i, -1, access);
                PickItem.send(menu.field_7763, i, -1, slot);
            }
            this.sound().atClient(player, ModSound.Type.REMOVE);
            cir.setReturnValue((Object)true);
            return true;
        }
        return false;
    }

    public void pickBlockClient(class_1657 player, class_1304 slot, class_1661 inventory, class_1799 matchedStack, CallbackInfo ci) {
        class_1799 backpack = player.method_6118(slot);
        BackpackTraits traits = BackpackTraits.get(backpack);
        if (traits == null) {
            return;
        }
        int freeSlot = inventory.method_7376();
        if (freeSlot == -1) {
            this.sound().atClient(player, ModSound.Type.HIT);
            return;
        }
        ComponentHolder holder = ComponentHolder.of(backpack);
        BackpackMutable mutable = traits.mutable(holder);
        List<class_1799> stacks = mutable.getItemStacks();
        for (int i = 0; i < stacks.size(); ++i) {
            int maxStackSize;
            class_1799 stack = stacks.get(i);
            if (!class_1799.method_31577((class_1799)matchedStack, (class_1799)stack)) continue;
            int count = stack.method_7947();
            int amount = count > (maxStackSize = stack.method_7914()) ? maxStackSize : -1;
            mutable.pickBlock(player, i, amount, freeSlot);
            PickBlock.send(i, amount, slot, freeSlot);
            this.sound().atClient(player, ModSound.Type.REMOVE);
            mutable.push();
            ci.cancel();
            return;
        }
    }
}

