/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.common;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.components.reference.NonTrait;
import com.beansgalaxy.backpacks.items.ModItems;
import com.beansgalaxy.backpacks.traits.IEntityTraits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.util.CollidingVertexMap;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.beansgalaxy.backpacks.util.data_fixers.RecoverLocalData;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_6903;
import net.minecraft.class_8111;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BackpackEntity
extends class_1297
implements ComponentHolder {
    public static final class_2940<Boolean> IS_OPEN = class_2945.method_12791(BackpackEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<class_1799> ITEM_STACK = class_2945.method_12791(BackpackEntity.class, (class_2941)class_2943.field_13322);
    public static final class_2940<class_2350> DIRECTION = class_2945.method_12791(BackpackEntity.class, (class_2941)class_2943.field_13321);
    public final ViewableBackpack viewable = new ViewableBackpack(){

        @Override
        public void setOpen(boolean isOpen) {
            BackpackEntity.this.field_6011.method_12778(IS_OPEN, (Object)isOpen);
        }

        @Override
        public boolean isOpen() {
            return (Boolean)BackpackEntity.this.field_6011.method_12789(IS_OPEN);
        }

        @Override
        public void playSound(ModSound.Type type) {
            BackpackEntity.this.getTraits().sound().at(BackpackEntity.this, type);
        }

        @Override
        @NotNull
        public class_1297 entity() {
            return BackpackEntity.this;
        }

        @Override
        protected ComponentHolder holder() {
            return BackpackEntity.this;
        }

        @Override
        public class_1799 toStack() {
            class_1799 stack = BackpackEntity.this.toStack();
            stack.method_27320((class_1297)BackpackEntity.this);
            return stack;
        }

        @Override
        public boolean shouldClose() {
            return false;
        }

        @Override
        public float fallDistance() {
            return BackpackEntity.this.field_6017;
        }
    };
    public int breakAmount = 0;
    public static final int BACKPACK_HEALTH = 24;

    public class_1269 useTraitInteraction(class_1657 player, class_1268 hand) {
        IEntityTraits<?> traits = this.getTraits();
        return traits.interact(this, player, hand);
    }

    public BackpackEntity(class_1299<?> $$0, class_1937 $$1) {
        super($$0, $$1);
        this.field_23807 = true;
    }

    public IEntityTraits<?> getTraits() {
        class_1799 stack = (class_1799)this.field_6011.method_12789(ITEM_STACK);
        BackpackTraits traits = BackpackTraits.get(stack);
        return Objects.requireNonNullElse(traits, NonTrait.INSTANCE);
    }

    @Nullable
    public static BackpackEntity create(class_1838 ctx, class_1799 backpackStack, BackpackTraits traits) {
        class_243 pos;
        class_243 cursor;
        class_2350 direction;
        class_1937 level = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_1657 player = ctx.method_8036();
        if (level.method_8320(blockPos).method_26220((class_1922)level, blockPos).method_1110()) {
            class_3965 hitResult = Constants.getPlayerPOVHitResult(level, player, class_3959.class_3960.field_17558, class_3959.class_242.field_1348);
            direction = class_239.class_240.field_1333.equals((Object)hitResult.method_17783()) ? class_2350.field_11036 : hitResult.method_17780();
            cursor = hitResult.method_17784();
        } else {
            direction = ctx.method_8038();
            cursor = ctx.method_17698();
        }
        float yRot = switch (direction) {
            case class_2350.field_11043, class_2350.field_11035 -> {
                double y = BackpackEntity.snapY(player.method_23320(), cursor);
                double z = BackpackEntity.snapXZ(cursor.field_1352);
                pos = new class_243(z, y - 0.3125, cursor.field_1350);
                yield direction.method_10144();
            }
            case class_2350.field_11034, class_2350.field_11039 -> {
                double y = BackpackEntity.snapY(player.method_23320(), cursor);
                double z = BackpackEntity.snapXZ(cursor.field_1350);
                pos = new class_243(cursor.field_1352, y - 0.3125, z);
                yield direction.method_10144();
            }
            default -> {
                if (direction == class_2350.field_11033) {
                    cursor = cursor.method_1031(0.0, -0.5625, 0.0);
                    direction = class_2350.field_11036;
                }
                pos = new class_243(class_3532.method_16436((double)0.85, (double)player.method_23317(), (double)cursor.field_1352), cursor.field_1351, class_3532.method_16436((double)0.85, (double)player.method_23321(), (double)cursor.field_1350));
                yield player.method_5791() + 180.0f;
            }
        };
        Vector3f step = direction.method_23955().mul(0.125f, 0.0f, 0.125f);
        class_243 stepped_pos = pos.method_1031((double)step.x, (double)step.y, (double)step.z);
        class_238 aabb = BackpackEntity.newBoundingBox(direction, stepped_pos);
        Vector3f inset = direction.method_23955().mul(-0.0625f, -0.0625f, -0.0625f);
        class_238 inset_aabb = aabb.method_60314(inset);
        CollidingVertexMap map = new CollidingVertexMap(inset_aabb, direction, level, cursor);
        map.pushClippedPoints();
        map.pushHangingPoints();
        Vector3f offset = inset.mul(-1.0f);
        class_238 box = map.box.method_60314(offset);
        if (!map.areClippedPointsStable() || !level.method_52569(null, box)) {
            map.box = box;
            map.stabilizeHangingPoints();
            box = map.box;
            if (!level.method_52569((class_1297)player, box)) {
                return null;
            }
        }
        return BackpackEntity.create(backpackStack, traits, level, box.method_61124(), yRot, direction, player);
    }

    private static double snapXZ(double clickLocation) {
        int iX = clickLocation < 0.0 ? -1 : 1;
        int block = (int)clickLocation;
        double vX = Math.abs(clickLocation - (double)block);
        double z = vX < 0.09 ? (double)block : (vX > 0.91 ? (double)(block + iX) : (vX < 0.35 ? (double)block + (double)iX * 0.25 : (vX > 0.65 ? (double)block + (double)iX * 0.75 : (double)block + (double)iX * 0.5)));
        return z;
    }

    private static double snapY(double targetY, class_243 clickLocation) {
        double i = clickLocation.field_1351;
        double scale = 8.0;
        double scaled = (i -= 0.0625) * scale;
        double v = i - targetY;
        double y = v > 0.0 ? (double)((int)scaled) / scale : (double)class_3532.method_15384((double)scaled) / scale;
        return y;
    }

    public static void drop(class_1657 player) {
        class_1799 backpack = player.method_6118(class_1304.field_48824);
        BackpackTraits traits = BackpackTraits.get(backpack);
        if (traits == null) {
            return;
        }
        float angle = player.field_6283 + 180.0f;
        double radians = Math.toRadians(angle);
        double x = Math.sin(radians) * 0.25;
        double z = Math.cos(radians) * 0.25;
        BackpackEntity.create(backpack, traits, player.method_37908(), player.method_19538().method_1031(x, 0.6, z), angle, class_2350.field_11036, player);
    }

    @NotNull
    public static BackpackEntity create(class_1799 backpackStack, BackpackTraits traits, class_1937 level, class_243 pos, float yRot, class_2350 direction, class_1657 player) {
        BackpackEntity backpackEntity = new BackpackEntity(CommonClass.BACKPACK_ENTITY.get(), level);
        backpackEntity.method_33574(pos);
        backpackEntity.method_36456(yRot);
        backpackEntity.setDirection(direction);
        traits.onPlace(backpackEntity, player, backpackStack);
        backpackEntity.field_6011.method_12778(ITEM_STACK, (Object)backpackStack.method_46651(1));
        if (level instanceof class_3218) {
            level.method_8649((class_1297)backpackEntity);
        }
        if (direction.method_10166().method_10179()) {
            level.method_8455(backpackEntity.method_24515(), class_2246.field_10124);
        }
        backpackStack.method_7934(1);
        return backpackEntity;
    }

    @NotNull
    protected class_238 method_33332() {
        return BackpackEntity.newBoundingBox(this.method_5735(), this.method_19538());
    }

    private static class_238 newBoundingBox(class_2350 direction, class_243 pos) {
        double d = 0.125;
        double w = 0.25;
        double h = 0.5625;
        return switch (direction) {
            case class_2350.field_11043, class_2350.field_11035 -> new class_238(pos.field_1352 - w, pos.field_1351, pos.field_1350 + d, pos.field_1352 + w, pos.field_1351 + h, pos.field_1350 - d);
            case class_2350.field_11034, class_2350.field_11039 -> new class_238(pos.field_1352 - d, pos.field_1351, pos.field_1350 - w, pos.field_1352 + d, pos.field_1351 + h, pos.field_1350 + w);
            default -> {
                double width = 0.21875;
                yield new class_238(pos.method_1031(width, h, width), pos.method_1031(-width, 0.0, -width));
            }
        };
    }

    private static double roundForY(double i, double playerEye) {
        double scale = 8.0;
        double scaled = (i -= 0.0625) * scale;
        double v = i - playerEye;
        if (v > 0.0) {
            return 0.125 + (double)((int)scaled) / scale;
        }
        return 0.125 + (double)class_3532.method_15384((double)scaled) / scale;
    }

    private static double roundToScale(double position, double scale) {
        int i = position < 0.0 ? -1 : 1;
        int block = (int)position;
        double v = Math.abs(position - (double)block);
        if (v < 0.12) {
            return block;
        }
        if (v > 0.89) {
            return block + i;
        }
        if (v < 0.38) {
            return (double)block + (double)i * 0.25;
        }
        if (v > 0.63) {
            return (double)block + (double)i * 0.75;
        }
        return (double)block + (double)i * 0.5;
    }

    public class_1799 toStack() {
        return (class_1799)this.field_6011.method_12789(ITEM_STACK);
    }

    public void method_5773() {
        super.method_5773();
        this.updateGravity();
        this.wobble();
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    public boolean method_5675() {
        return false;
    }

    private void wobble() {
        if (this.viewable.wobble > 0) {
            --this.viewable.wobble;
        } else {
            this.breakAmount = 0;
        }
    }

    private void updateGravity() {
        boolean collides = !this.method_37908().method_8587((class_1297)this, this.method_5829().method_1009(0.1, -0.1, 0.1));
        this.method_5875(this.method_5740() && collides);
        if (!this.method_5740()) {
            if (this.method_5799()) {
                this.inWaterGravity();
            } else if (this.method_5771()) {
                if (this.method_5777(class_3486.field_15518) && this.method_18798().field_1351 < 0.1) {
                    this.method_18799(this.method_18798().method_1031(0.0, 0.02, 0.0));
                }
                this.method_18799(this.method_18798().method_1021(0.6));
            } else if (this.method_24828()) {
                this.method_18799(this.method_18798().method_1021(0.2));
            } else {
                this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
                this.method_18799(this.method_18798().method_1021(0.98));
            }
        }
    }

    private void inWaterGravity() {
        class_238 thisBox = this.method_5829();
        class_238 box = new class_238(thisBox.field_1320, thisBox.field_1325 + 0.375, thisBox.field_1324, thisBox.field_1323, thisBox.field_1325, thisBox.field_1321);
        List entityList = this.method_5770().method_8335((class_1297)this, box);
        if (!entityList.isEmpty()) {
            class_1297 entity = (class_1297)entityList.get(0);
            double velocity = this.method_23318() - entity.method_23318();
            Object e = entityList.get(0);
            if (e instanceof class_1657) {
                class_1657 player = (class_1657)e;
                this.method_18800(0.0, velocity / 10.0, 0.0);
            } else if (velocity < -0.6) {
                this.inWaterBob();
            } else {
                this.method_18800(0.0, velocity / 20.0, 0.0);
            }
        } else {
            this.inWaterBob();
        }
    }

    private void inWaterBob() {
        if (this.method_5869()) {
            this.method_18799(this.method_18798().method_1021(0.95));
            this.method_18799(this.method_18798().method_1031(0.0, 0.003, 0.0));
        } else if (this.method_5799() && this.method_18798().field_1351 < 0.01) {
            this.method_18799(this.method_18798().method_1021(0.9));
            this.method_18799(this.method_18798().method_1031(0.0, -0.01, 0.0));
        }
    }

    public boolean method_5753() {
        return ((class_1799)this.field_6011.method_12789(ITEM_STACK)).method_57826(class_9334.field_50076);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(ITEM_STACK, (Object)ModItems.IRON_BACKPACK.get().method_7854());
        builder.method_56912(DIRECTION, (Object)class_2350.field_11036);
        builder.method_56912(IS_OPEN, (Object)false);
    }

    protected void method_5749(class_2487 tag) {
        if (tag.method_10545("local_data")) {
            RecoverLocalData.readEntity(this, tag);
            return;
        }
        class_6903 serializationContext = this.method_56673().method_57093((DynamicOps)class_2509.field_11560);
        class_1799 stack = (class_1799)class_1799.field_49266.parse((DynamicOps)serializationContext, (Object)tag.method_10580("as_stack")).getOrThrow();
        this.field_6011.method_12778(ITEM_STACK, (Object)stack);
        class_2350 direction = (class_2350)class_2350.field_29502.parse((DynamicOps)serializationContext, (Object)tag.method_10580("direction")).getOrThrow();
        this.setDirection(direction);
    }

    protected void method_5652(class_2487 tag) {
        class_1799 stack = this.toStack();
        class_6903 serializationContext = this.method_56673().method_57093((DynamicOps)class_2509.field_11560);
        tag.method_10566("as_stack", (class_2520)class_1799.field_49266.encodeStart((DynamicOps)serializationContext, (Object)stack).getOrThrow());
        class_2350 direction = this.method_5735();
        tag.method_10566("direction", (class_2520)class_2350.field_29502.encodeStart((DynamicOps)serializationContext, (Object)direction).getOrThrow());
    }

    public class_2596<class_2602> method_18002(class_3231 entity) {
        return new class_2604((class_1297)this, entity, this.method_5735().method_10146());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        int data = packet.method_11166();
        class_2350 direction = class_2350.method_10143((int)data);
        this.setDirection(direction);
    }

    public void setDirection(class_2350 direction) {
        if (direction != null) {
            if (direction == class_2350.field_11033) {
                direction = class_2350.field_11036;
            }
            this.field_6011.method_12778(DIRECTION, (Object)direction);
            if (direction != class_2350.field_11036) {
                this.method_5875(true);
                this.method_36456((float)direction.method_10161() * 90.0f);
            }
            this.field_6004 = this.method_36455();
            this.field_5982 = this.method_36454();
            this.method_5857(this.method_33332());
        }
    }

    public class_2350 method_5735() {
        return (class_2350)this.field_6011.method_12789(DIRECTION);
    }

    public class_2561 method_5477() {
        return Constants.getName(this.toStack());
    }

    protected boolean method_5638() {
        return false;
    }

    public boolean method_30949(@NotNull class_1297 that) {
        class_1309 livingEntity;
        if (that instanceof class_1309 && !(livingEntity = (class_1309)that).method_5805()) {
            return false;
        }
        if (this.method_5794(that)) {
            return false;
        }
        if (that instanceof BackpackEntity) {
            return true;
        }
        if (that.method_19538().field_1351 < this.method_19538().field_1351) {
            return false;
        }
        return that.method_30948() || that.method_5810();
    }

    public boolean method_30948() {
        return true;
    }

    @Nullable
    public class_1799 method_31480() {
        return this.toStack();
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5698(class_1297 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            return this.method_5643(this.method_48923().method_48802(player), 0.0f);
        }
        return false;
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        class_1297 class_12972;
        double height = 0.1;
        if (damageSource.method_49708(class_8111.field_42335) || damageSource.method_49708(class_8111.field_42338)) {
            if (this.method_5753()) {
                return false;
            }
            this.wobble(5);
            ++this.breakAmount;
            if (this.breakAmount >= 24) {
                this.breakAndDropContents();
            }
            if ((this.breakAmount + 10) % 11 == 0) {
                this.method_5783(class_3417.field_14821, 0.8f, 1.0f);
            }
            return true;
        }
        if (damageSource.method_49708(class_8111.field_42320) && (class_12972 = damageSource.method_5526()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (player.method_7337()) {
                IEntityTraits<?> traits = this.getTraits();
                if (!traits.isEmpty(this)) {
                    this.method_5775(this.toStack());
                }
                this.killAndUpdate(false);
            } else if (this.breakAmount + 10 >= 24) {
                this.breakAndDropContents();
            } else {
                boolean silent = this.method_5701();
                IEntityTraits<?> traits = this.getTraits();
                traits.onDamage(this, silent, traits.sound());
            }
            return true;
        }
        if (damageSource.method_49708(class_8111.field_42337)) {
            return false;
        }
        if (damageSource.method_49708(class_8111.field_42344)) {
            this.breakAndDropContents();
            return true;
        }
        if (damageSource.method_49708(class_8111.field_42331) || damageSource.method_49708(class_8111.field_42332)) {
            this.hop(height += Math.sqrt(amount) / 20.0);
            return true;
        }
        if (damageSource.method_49708(class_8111.field_42321) || damageSource.method_49708(class_8111.field_42328) || damageSource.method_49708(class_8111.field_42322) || damageSource.method_49708(class_8111.field_42323)) {
            this.hop(height);
            return false;
        }
        this.hop(height);
        return true;
    }

    public void wobble(int amount) {
        this.viewable.wobble = Math.min(this.viewable.wobble + amount, 24);
        this.method_37908().method_8455(this.method_24515(), class_2246.field_10124);
    }

    public void hop(double height) {
        if (this.method_5740()) {
            this.method_5875(false);
        } else {
            this.method_18799(this.method_18798().method_1031(0.0, height, 0.0));
        }
    }

    protected void breakAndDropContents() {
        boolean dropItems = this.method_37908().method_8450().method_8355(class_1928.field_19392);
        IEntityTraits<?> traits = this.getTraits();
        traits.onBreak(this, dropItems);
        if (!this.method_5701()) {
            traits.sound().at(this, ModSound.Type.BREAK);
        }
        this.killAndUpdate(dropItems);
    }

    private void killAndUpdate(boolean dropItems) {
        class_2338 pPos = this.method_24515();
        this.method_37908().method_8455(pPos, class_2246.field_10124);
        if (!this.method_31481() && !this.method_37908().method_8608()) {
            this.method_5768();
            this.method_5785();
            if (dropItems) {
                class_1799 backpack = this.toStack();
                this.method_5775(backpack);
            }
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1269 tryEquip;
        BackData backData = BackData.get(player);
        if (backData.isActionKeyDown() && !(tryEquip = this.tryEquip(player)).equals((Object)class_1269.field_5811)) {
            return tryEquip;
        }
        return this.useTraitInteraction(player, hand);
    }

    public class_1269 tryEquip(class_1657 player) {
        if (!this.getTraits().slots().test(class_1304.field_48824)) {
            return class_1269.field_5811;
        }
        class_1799 backSlot = player.method_6118(class_1304.field_48824);
        if (!backSlot.method_7960()) {
            return class_1269.field_5814;
        }
        class_1799 stack = this.toStack();
        player.method_5673(class_1304.field_48824, stack);
        this.getTraits().sound().at(this, ModSound.Type.EQUIP);
        this.killAndUpdate(false);
        return class_1269.field_5812;
    }

    private void tryInsertInventory(class_1657 player) {
        class_1799 stack = this.toStack();
        class_1799 handStack = player.method_6118(class_1304.field_6173);
        if (handStack.method_7960()) {
            player.method_5673(class_1304.field_6173, stack);
            return;
        }
        class_1661 inventory = player.method_31548();
        class_2371 items = inventory.field_7547;
        for (int i = 0; i < 9; ++i) {
            class_1799 hotbarStack = (class_1799)items.get(0);
            if (!hotbarStack.method_7960()) continue;
            inventory.method_5447(i, stack);
            inventory.field_7545 = i;
            return;
        }
        if (!inventory.method_7367(-1, stack)) {
            this.method_5775(stack);
        }
    }

    @Override
    @Nullable
    public <T> T remove(class_9331<? extends T> type) {
        class_1799 stack = (class_1799)this.field_6011.method_12789(ITEM_STACK);
        Object removed = stack.method_57381(type);
        this.field_6011.method_12778(ITEM_STACK, (Object)stack);
        return (T)removed;
    }

    @Override
    public <T> void set(class_9331<? super T> type, T data) {
        class_1799 stack = (class_1799)this.field_6011.method_12789(ITEM_STACK);
        stack.method_57379(type, data);
        this.field_6011.method_12778(ITEM_STACK, (Object)stack);
    }

    @Override
    public <T> T get(class_9331<? extends T> type) {
        return (T)((class_1799)this.field_6011.method_12789(ITEM_STACK)).method_57824(type);
    }

    @Override
    public void setChanged() {
        class_1799 stack = this.toStack();
        this.field_6011.method_49743(ITEM_STACK, (Object)stack, true);
        class_2338 pPos = this.method_24515();
        this.method_37908().method_8455(pPos, class_2246.field_10124);
    }
}

