/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.generic;

import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.network.serverbound.TraitMenuClick;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackMutable;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.bundle.BundleScreen;
import com.beansgalaxy.backpacks.traits.generic.ItemStorageTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.generic.MutableItemStorage;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class BundleLikeTraits
extends ItemStorageTraits {
    private final int size;

    public BundleLikeTraits(ModSound sound, int size) {
        super(sound);
        this.size = size;
    }

    public static Optional<BundleLikeTraits> get(ComponentHolder stack) {
        for (TraitComponentKind<? extends BundleLikeTraits> type : TraitComponentKind.BUNDLE_TRAITS) {
            BundleLikeTraits traits2 = stack.get(type);
            if (traits2 == null) continue;
            return Optional.of(traits2);
        }
        ReferenceTrait referenceTrait = stack.get(Traits.REFERENCE);
        if (referenceTrait != null) {
            return referenceTrait.getTrait().map(traits -> {
                if (traits instanceof BundleLikeTraits) {
                    BundleLikeTraits storageTraits = (BundleLikeTraits)traits;
                    return storageTraits;
                }
                return null;
            });
        }
        return Optional.empty();
    }

    public int size() {
        return this.size;
    }

    @Override
    public Fraction fullness(ComponentHolder holder) {
        List<class_1799> stacks = holder.get(ITraitData.ITEM_STACKS);
        if (stacks == null) {
            return Fraction.ZERO;
        }
        return this.fullness(stacks);
    }

    public Fraction fullness(List<class_1799> stacks) {
        return Traits.getWeight(stacks, this.size());
    }

    @Override
    public boolean isEmpty(ComponentHolder holder) {
        List<class_1799> stacks = holder.get(ITraitData.ITEM_STACKS);
        return stacks == null || stacks.isEmpty();
    }

    @Override
    @Nullable
    public class_1799 getFirst(ComponentHolder holder) {
        List<class_1799> stacks = holder.get(ITraitData.ITEM_STACKS);
        return stacks == null ? null : stacks.getFirst();
    }

    @Override
    public void stackedOnMe(ComponentHolder backpack, class_1799 other, class_1735 slot, class_5536 click, class_1657 player, class_5630 access, CallbackInfoReturnable<Boolean> cir) {
    }

    @Override
    public void stackedOnOther(ComponentHolder backpack, class_1799 other, class_1735 slot, class_5536 click, class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        if (!class_5536.field_27014.equals((Object)click)) {
            return;
        }
        MutableItemStorage mutable = this.mutable(backpack);
        ModSound sound = this.sound();
        if (other.method_7960()) {
            class_1799 stack = ((MutableBundleLike)mutable).removeItem(other, player);
            if (stack.method_7960() || !slot.method_7680(stack)) {
                return;
            }
            slot.method_7673(stack);
            sound.atClient(player, ModSound.Type.REMOVE);
        } else if (slot.method_7674(player)) {
            if (((MutableBundleLike)mutable).addItem(other, 0) != null) {
                sound.atClient(player, ModSound.Type.INSERT);
            }
        } else {
            return;
        }
        mutable.push(cir);
    }

    @Override
    public boolean canItemFit(ComponentHolder holder, class_1799 inserted) {
        return !inserted.method_7960() && super.canItemFit(holder, inserted);
    }

    @Override
    public abstract MutableBundleLike<?> mutable(ComponentHolder var1);

    @Override
    public void hotkeyUse(class_1735 slot, class_1304 selectedEquipment, int button, class_1713 actionType, class_1657 player, CallbackInfo ci) {
        if (selectedEquipment == null) {
            ComponentHolder holder = ComponentHolder.of(slot.method_7677());
            MutableItemStorage mutable = this.mutable(holder);
            if (((MutableBundleLike)mutable).isEmpty()) {
                ci.cancel();
                return;
            }
            class_1661 inventory = player.method_31548();
            int selectedSlot = ((MutableBundleLike)mutable).getSelectedSlot(player);
            if (class_1713.field_7793.equals((Object)actionType)) {
                List<class_1799> stacks;
                class_1799 selectedStack;
                class_1799 carried = player.field_7512.method_34255();
                if (!class_1799.method_31577((class_1799)carried, (class_1799)(selectedStack = (stacks = ((MutableBundleLike)mutable).getItemStacks()).get(selectedSlot))) || !this.canItemFit(holder, carried)) {
                    ci.cancel();
                    return;
                }
                for (int i = stacks.size() - 1; i >= 0 && !mutable.isFull(); --i) {
                    class_1799 removed;
                    class_1799 stack = stacks.get(i);
                    boolean same = class_1799.method_31577((class_1799)carried, (class_1799)stack);
                    if (!same) continue;
                    int stackableSlot = inventory.method_7390(stack);
                    if (stackableSlot == -1) {
                        stackableSlot = inventory.method_7376();
                    }
                    if (stackableSlot == -1 || !inventory.method_7367(-1, removed = ((MutableBundleLike)mutable).removeItem(i))) continue;
                    ci.cancel();
                }
                boolean cancelled = ci.isCancelled();
                if (cancelled) {
                    this.sound().atClient(player, ModSound.Type.REMOVE);
                    ((MutableBundleLike)mutable).push();
                }
                return;
            }
            class_1799 stack = ((MutableBundleLike)mutable).removeItem(selectedSlot);
            int stackableSlot = inventory.method_7390(stack);
            if (stackableSlot == -1) {
                stackableSlot = inventory.method_7376();
            }
            if (stackableSlot != -1 && inventory.method_7367(-1, stack)) {
                this.sound().atClient(player, ModSound.Type.REMOVE);
                ((MutableBundleLike)mutable).push();
                ci.cancel();
            }
        } else {
            class_1799 backpack = player.method_6118(selectedEquipment);
            ComponentHolder holder = ComponentHolder.of(backpack);
            MutableItemStorage mutable = this.mutable(holder);
            if (mutable.isFull()) {
                return;
            }
            if (class_1713.field_7793.equals((Object)actionType)) {
                List<class_1799> stacks = ((MutableBundleLike)mutable).getItemStacks();
                class_1799 carried = player.field_7512.method_34255();
                if (stacks.isEmpty() || !class_1799.method_31577((class_1799)carried, (class_1799)stacks.getFirst()) || !this.canItemFit(holder, carried)) {
                    ci.cancel();
                    return;
                }
                class_1661 inventory = player.method_31548();
                class_2371 items = inventory.field_7547;
                for (int i = items.size() - 1; i >= 0 && !mutable.isFull(); --i) {
                    class_1799 stack = (class_1799)items.get(i);
                    if (!class_1799.method_31577((class_1799)carried, (class_1799)stack)) continue;
                    int toAdd = ((MutableBundleLike)mutable).getMaxAmountToAdd(stack.method_7972());
                    int count = Math.min(stack.method_7914(), toAdd);
                    class_1799 removed = stack.method_46651(count);
                    stack.method_7934(count);
                    if (((MutableBundleLike)mutable).addItem(removed, 0) == null) continue;
                    ci.cancel();
                }
                boolean cancelled = ci.isCancelled();
                if (cancelled) {
                    this.sound().atClient(player, ModSound.Type.INSERT);
                    ((MutableBundleLike)mutable).push();
                }
                return;
            }
            class_1799 stack = slot.method_7677();
            if (this.canItemFit(holder, stack)) {
                class_1799 removed;
                int toAdd = ((MutableBundleLike)mutable).getMaxAmountToAdd(stack);
                if (slot instanceof class_1734) {
                    Optional optional = slot.method_34264(stack.method_7947(), toAdd, player);
                    if (optional.isEmpty()) {
                        return;
                    }
                    removed = (class_1799)optional.get();
                    slot.method_7667(player, removed);
                } else {
                    removed = slot.method_7671(toAdd);
                }
                if (((MutableBundleLike)mutable).addItem(removed, 0) != null) {
                    this.sound().atClient(player, ModSound.Type.INSERT);
                    ((MutableBundleLike)mutable).push();
                    ci.cancel();
                }
            }
        }
    }

    @Override
    public void hotkeyThrow(class_1735 slot, ComponentHolder backpack, int button, class_1657 player, boolean menuKeyDown, CallbackInfo ci) {
        if (this.isEmpty(backpack)) {
            return;
        }
        MutableItemStorage mutable = this.mutable(backpack);
        int selectedSlot = ((MutableBundleLike)mutable).getSelectedSlot(player);
        if (!menuKeyDown) {
            return;
        }
        class_1799 removed = ((MutableBundleLike)mutable).removeItem(selectedSlot);
        player.method_7328(removed, true);
        this.sound().atClient(player, ModSound.Type.REMOVE);
        ((MutableBundleLike)mutable).push();
        ci.cancel();
    }

    @Override
    public void breakTrait(class_3222 pPlayer, class_1799 instance) {
        List stacks = (List)instance.method_57824(ITraitData.ITEM_STACKS);
        if (stacks == null) {
            return;
        }
        stacks.forEach(stack -> {
            boolean success = pPlayer.method_31548().method_7367(-1, stack);
            if (!success || !stack.method_7960()) {
                pPlayer.method_7329(stack, true, true);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BundleLikeTraits)) {
            return false;
        }
        BundleLikeTraits that = (BundleLikeTraits)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.size == that.size && Objects.equals((Object)this.sound(), (Object)that.sound());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sound(), this.size});
    }

    @Override
    public void tinyMenuClick(ComponentHolder holder, int index, TinyClickType clickType, class_5630 carriedAccess, class_1657 player) {
        List<class_1799> stacks;
        int add;
        int size;
        class_1799 stack;
        MutableItemStorage mutable = this.mutable(holder);
        if (clickType.isHotbar()) {
            class_1661 inventory = player.method_31548();
            class_1799 hotbarStack = (class_1799)inventory.field_7547.get(clickType.hotbarSlot);
            class_1799 stack2 = ((MutableBundleLike)mutable).removeItem(index);
            if (!hotbarStack.method_7960()) {
                int add2 = ((MutableBundleLike)mutable).toAdd(hotbarStack);
                if (add2 < hotbarStack.method_7947()) {
                    return;
                }
                ((MutableBundleLike)mutable).addItem(hotbarStack, index);
            }
            this.sound().at((class_1297)player, ModSound.Type.REMOVE);
            inventory.field_7547.set(clickType.hotbarSlot, (Object)stack2);
            ((MutableBundleLike)mutable).push();
            return;
        }
        if (clickType.isShift()) {
            class_1799 hotbar;
            class_1661 inventory = player.method_31548();
            stack = ((MutableBundleLike)mutable).removeItem(index);
            size = inventory.field_7547.size();
            int i = 9;
            do {
                if (i == size) {
                    i = 0;
                }
                if (class_1799.method_31577((class_1799)stack, (class_1799)(hotbar = (class_1799)inventory.field_7547.get(i)))) {
                    add = Math.min(hotbar.method_7914() - hotbar.method_7947(), stack.method_7947());
                    hotbar.method_7933(add);
                    stack.method_7934(add);
                }
                if (!stack.method_7960()) continue;
                ((MutableBundleLike)mutable).push();
                this.sound().at((class_1297)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
            do {
                if (i == size) {
                    i = 0;
                }
                if ((hotbar = (class_1799)inventory.field_7547.get(i)).method_7960()) {
                    add = Math.min(stack.method_7914(), stack.method_7947());
                    inventory.field_7547.set(i, (Object)stack.method_46651(add));
                    stack.method_7934(add);
                }
                if (!stack.method_7960()) continue;
                ((MutableBundleLike)mutable).push();
                this.sound().at((class_1297)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
        }
        if (clickType.isAction()) {
            if (index == -1) {
                return;
            }
            stacks = ((MutableBundleLike)mutable).stacks.get();
            if (index >= stacks.size()) {
                return;
            }
            stack = stacks.get(index);
            BackpackTraits.runIfEquipped(player, (arg_0, arg_1) -> this.lambda$tinyMenuClick$2(player, holder, stack, (MutableBundleLike)mutable, arg_0, arg_1));
        }
        if (clickType.isDrop()) {
            class_1799 stack3 = ((MutableBundleLike)mutable).removeItem(index);
            player.method_7328(stack3, true);
            ((MutableBundleLike)mutable).push();
            return;
        }
        stacks = ((MutableBundleLike)mutable).getItemStacks();
        class_1799 carried = carriedAccess.method_32327();
        if (index == -1) {
            if (clickType.isRight()) {
                if (((MutableBundleLike)mutable).addItem(carried.method_46651(1)) != null) {
                    carried.method_7934(1);
                    ((MutableBundleLike)mutable).push();
                    this.sound().at((class_1297)player, ModSound.Type.INSERT);
                }
            } else if (((MutableBundleLike)mutable).addItem(carried) != null) {
                ((MutableBundleLike)mutable).push();
                this.sound().at((class_1297)player, ModSound.Type.INSERT);
            }
            return;
        }
        size = stacks.size();
        if (index >= size) {
            if (clickType.isRight()) {
                if (((MutableBundleLike)mutable).addItem(carried.method_46651(1), size) != null) {
                    carried.method_7934(1);
                    ((MutableBundleLike)mutable).push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (((MutableBundleLike)mutable).addItem(carried, size) != null) {
                ((MutableBundleLike)mutable).push();
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
            return;
        }
        class_1799 stack4 = stacks.get(index);
        if (stack4.method_7960() && carried.method_7960()) {
            return;
        }
        if (!stack4.method_7960() && !carried.method_7960()) {
            if (class_1799.method_31577((class_1799)stack4, (class_1799)carried)) {
                int toAdd = ((MutableBundleLike)mutable).toAdd(carried);
                if (toAdd == 0) {
                    return;
                }
                if (clickType.isRight()) {
                    stack4.method_7933(1);
                    carried.method_7934(1);
                } else {
                    add = Math.min(stack4.method_7914() - stack4.method_7947(), toAdd);
                    stack4.method_7933(add);
                    carried.method_7934(add);
                }
                this.sound().atClient(player, ModSound.Type.INSERT);
            } else if (((MutableBundleLike)mutable).addItem(carried, index) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
        } else if (clickType.isRight()) {
            int count = class_3532.method_15386((float)((float)stack4.method_7947() / 2.0f));
            class_1799 split = stack4.method_7971(count);
            carriedAccess.method_32332(split);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (carried.method_7960()) {
            class_1799 removed = ((MutableBundleLike)mutable).removeItem(index);
            carriedAccess.method_32332(removed);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (((MutableBundleLike)mutable).addItem(carried, index + 1) != null) {
            this.sound().atClient(player, ModSound.Type.INSERT);
        }
        ((MutableBundleLike)mutable).push();
    }

    @Override
    public void tinyHotbarClick(ComponentHolder holder, int slotId, TinyClickType clickType, class_1723 menu, class_1657 player) {
        if (TinyClickType.I_SHIFT.equals((Object)clickType)) {
            class_1735 slot = menu.method_7611(slotId);
            class_1799 hotbar = slot.method_7677();
            MutableItemStorage mutable = this.mutable(holder);
            if (((MutableBundleLike)mutable).addItem(hotbar, ((MutableBundleLike)mutable).getItemStacks().size()) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
                ((MutableBundleLike)mutable).push();
            }
            return;
        }
        super.tinyHotbarClick(holder, slotId, clickType, menu, player);
    }

    @Override
    public void onPlayerInteract(class_1309 owner, class_1657 player, class_1799 backpack, CallbackInfoReturnable<class_1269> cir) {
        if (player.method_37908().field_9236) {
            ViewableBackpack viewable = ViewableBackpack.get(owner);
            BundleScreen.openScreen(player, viewable, this);
        }
        cir.setReturnValue((Object)class_1269.field_5812);
    }

    @Override
    public void menuClick(ComponentHolder holder, int index, TraitMenuClick.Kind clickType, class_5630 carriedAccess, class_1657 player) {
        List<class_1799> stacks;
        int size;
        class_1799 stack;
        MutableItemStorage mutable = this.mutable(holder);
        if (clickType.isShift()) {
            int add;
            class_1799 hotbar;
            class_1661 inventory = player.method_31548();
            stack = ((MutableBundleLike)mutable).removeItem(index);
            size = inventory.field_7547.size();
            int i = 9;
            do {
                if (i == size) {
                    i = 0;
                }
                if (class_1799.method_31577((class_1799)stack, (class_1799)(hotbar = (class_1799)inventory.field_7547.get(i)))) {
                    add = Math.min(hotbar.method_7914() - hotbar.method_7947(), stack.method_7947());
                    hotbar.method_7933(add);
                    stack.method_7934(add);
                }
                if (!stack.method_7960()) continue;
                ((MutableBundleLike)mutable).push();
                this.sound().at((class_1297)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
            do {
                if (i == size) {
                    i = 0;
                }
                if ((hotbar = (class_1799)inventory.field_7547.get(i)).method_7960()) {
                    add = Math.min(stack.method_7914(), stack.method_7947());
                    inventory.field_7547.set(i, (Object)stack.method_46651(add));
                    stack.method_7934(add);
                }
                if (!stack.method_7960()) continue;
                ((MutableBundleLike)mutable).push();
                this.sound().at((class_1297)player, ModSound.Type.INSERT);
                return;
            } while (++i != 9);
        }
        if (clickType.isAction()) {
            if (index == -1) {
                return;
            }
            stacks = ((MutableBundleLike)mutable).stacks.get();
            if (index >= stacks.size()) {
                return;
            }
            stack = stacks.get(index);
            BackpackTraits.runIfEquipped(player, (arg_0, arg_1) -> this.lambda$menuClick$3(player, holder, stack, (MutableBundleLike)mutable, arg_0, arg_1));
        }
        if (clickType.isDrop()) {
            BackData backData = BackData.get(player);
            if (backData.isMenuKeyDown()) {
                stack = ((MutableBundleLike)mutable).removeItem(index);
            } else {
                class_1799 item = ((MutableBundleLike)mutable).getItemStacks().get(index);
                stack = item.method_46651(1);
                item.method_7934(1);
            }
            player.method_7328(stack, true);
            ((MutableBundleLike)mutable).push();
            return;
        }
        stacks = ((MutableBundleLike)mutable).getItemStacks();
        class_1799 carried = carriedAccess.method_32327();
        size = stacks.size();
        if (index >= size) {
            if (clickType.isRight()) {
                if (((MutableBundleLike)mutable).addItem(carried.method_46651(1), size) != null) {
                    carried.method_7934(1);
                    ((MutableBundleLike)mutable).push();
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (((MutableBundleLike)mutable).addItem(carried, size) != null) {
                ((MutableBundleLike)mutable).push();
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
            return;
        }
        class_1799 stack2 = stacks.get(index);
        if (stack2.method_7960() && carried.method_7960()) {
            return;
        }
        if (!stack2.method_7960() && !carried.method_7960()) {
            if (class_1799.method_31577((class_1799)stack2, (class_1799)carried)) {
                int toAdd = ((MutableBundleLike)mutable).toAdd(carried);
                if (toAdd == 0) {
                    return;
                }
                if (clickType.isRight()) {
                    stack2.method_7933(1);
                    carried.method_7934(1);
                } else {
                    stack2.method_7933(toAdd);
                    carried.method_7934(toAdd);
                }
                this.sound().atClient(player, ModSound.Type.INSERT);
            } else if (clickType.isRight()) {
                if (((MutableBundleLike)mutable).addItem(carried.method_46651(1), index) != null) {
                    carried.method_7934(1);
                    this.sound().atClient(player, ModSound.Type.INSERT);
                }
            } else if (((MutableBundleLike)mutable).addItem(carried, index) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
            }
        } else if (clickType.isRight()) {
            int count = class_3532.method_15386((float)((float)Math.min(stack2.method_7914(), stack2.method_7947()) / 2.0f));
            class_1799 split = stack2.method_7971(count);
            carriedAccess.method_32332(split);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (carried.method_7960()) {
            class_1799 removed = ((MutableBundleLike)mutable).removeItem(index);
            carriedAccess.method_32332(removed);
            this.sound().atClient(player, ModSound.Type.REMOVE);
        } else if (((MutableBundleLike)mutable).addItem(carried, index + 1) != null) {
            this.sound().atClient(player, ModSound.Type.INSERT);
        }
        ((MutableBundleLike)mutable).push();
    }

    private /* synthetic */ boolean lambda$menuClick$3(class_1657 player, ComponentHolder holder, class_1799 stack, MutableBundleLike mutable, BackpackTraits storageTraits, class_1304 slot) {
        class_1799 backpack = player.method_6118(slot);
        BackpackMutable itemStorage = storageTraits.mutable(ComponentHolder.of(backpack));
        if (this.canItemFit(holder, stack) && itemStorage.addItem(stack) != null) {
            mutable.push();
            this.sound().atClient(player, ModSound.Type.INSERT);
            itemStorage.push();
        }
        return stack.method_7960();
    }

    private /* synthetic */ boolean lambda$tinyMenuClick$2(class_1657 player, ComponentHolder holder, class_1799 stack, MutableBundleLike mutable, BackpackTraits storageTraits, class_1304 slot) {
        class_1799 backpack = player.method_6118(slot);
        BackpackMutable itemStorage = storageTraits.mutable(ComponentHolder.of(backpack));
        if (this.canItemFit(holder, stack) && itemStorage.addItem(stack) != null) {
            mutable.push();
            this.sound().atClient(player, ModSound.Type.INSERT);
            itemStorage.push();
        }
        return stack.method_7960();
    }
}

