/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.generic;

import com.beansgalaxy.backpacks.components.FilterComponent;
import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackMutable;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableItemStorage;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2744;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5630;
import net.minecraft.class_9322;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class ItemStorageTraits
extends GenericTraits {
    public ItemStorageTraits(ModSound sound) {
        super(sound);
    }

    public static Optional<ItemStorageTraits> get(class_9322 stack) {
        for (TraitComponentKind<? extends ItemStorageTraits> type : TraitComponentKind.STORAGE_TRAITS) {
            ItemStorageTraits traits2 = (ItemStorageTraits)stack.method_57824(type);
            if (traits2 == null) continue;
            return Optional.of(traits2);
        }
        ReferenceTrait referenceTrait = (ReferenceTrait)stack.method_57824(Traits.REFERENCE);
        if (referenceTrait != null) {
            return referenceTrait.getTrait().map(traits -> {
                if (traits instanceof ItemStorageTraits) {
                    ItemStorageTraits storageTraits = (ItemStorageTraits)traits;
                    return storageTraits;
                }
                return null;
            });
        }
        return Optional.empty();
    }

    public static void runIfPresent(class_1799 stack, Consumer<ItemStorageTraits> runnable) {
        if (!stack.method_7960()) {
            Optional<ItemStorageTraits> traits = ItemStorageTraits.get((class_9322)stack);
            traits.ifPresent(runnable);
        }
    }

    public static void runIfPresent(class_1799 stack, Consumer<ItemStorageTraits> runnable, Runnable orElse) {
        if (!stack.method_7960()) {
            Optional<ItemStorageTraits> traits = ItemStorageTraits.get((class_9322)stack);
            traits.ifPresentOrElse(runnable, orElse);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean tryMoveItems(MutableItemStorage to, class_1799 from, class_1657 player) {
        MutableItemStorage other;
        if (to.isFull()) {
            return false;
        }
        Optional<ItemStorageTraits> optional = ItemStorageTraits.get((class_9322)from);
        if (optional.isEmpty()) {
            EnderTraits enderTraits = (EnderTraits)from.method_57824(Traits.ENDER);
            if (enderTraits == null) {
                return false;
            }
            GenericTraits genericTraits = enderTraits.getTrait(player.method_37908());
            if (!(genericTraits instanceof ItemStorageTraits)) return false;
            ItemStorageTraits traits = (ItemStorageTraits)genericTraits;
            other = traits.mutable(enderTraits);
        } else {
            other = optional.get().mutable(ComponentHolder.of(from));
        }
        if (other.isEmpty()) {
            return false;
        }
        other.moveItemsTo(to, player, true);
        return true;
    }

    @Override
    public abstract MutableItemStorage mutable(ComponentHolder var1);

    public abstract void hotkeyUse(class_1735 var1, class_1304 var2, int var3, class_1713 var4, class_1657 var5, CallbackInfo var6);

    public abstract void hotkeyThrow(class_1735 var1, ComponentHolder var2, int var3, class_1657 var4, boolean var5, CallbackInfo var6);

    public boolean overflowFromInventory(class_1304 equipmentSlot, class_1657 player, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        class_1799 backpack = player.method_6118(equipmentSlot);
        MutableItemStorage mutable = this.mutable(ComponentHolder.of(backpack));
        class_1799 itemStack = mutable.addItem(stack);
        if (itemStack != null) {
            mutable.push();
            cir.setReturnValue((Object)true);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                List<Pair> pSlots = List.of(Pair.of((Object)equipmentSlot, (Object)backpack));
                class_2744 packet = new class_2744(serverPlayer.method_5628(), pSlots);
                serverPlayer.method_51469().method_14178().method_18754((class_1297)serverPlayer, (class_2596)packet);
            }
            return itemStack.method_7960();
        }
        return false;
    }

    public boolean canItemFit(ComponentHolder holder, class_1799 inserted) {
        FilterComponent component = FilterComponent.get(holder);
        if (component != null && !component.isEmpty() && !component.passes(inserted)) {
            return false;
        }
        return inserted.method_7909().method_31568() && Traits.get(inserted).isEmpty();
    }

    public abstract void breakTrait(class_3222 var1, class_1799 var2);

    @Nullable
    public abstract class_1799 getFirst(ComponentHolder var1);

    public void tinyHotbarClick(ComponentHolder holder, int slotId, TinyClickType clickType, class_1723 menu, class_1657 player) {
        class_1735 slot = menu.method_7611(slotId);
        class_1799 hotbar = slot.method_7677();
        if (ItemStorageTraits.tryMoveItems(this.mutable(holder), hotbar, player)) {
            return;
        }
        if (clickType.isAction()) {
            BackpackTraits.runIfEquipped(player, (storageTraits, equipment) -> {
                class_1799 backpack = player.method_6118(equipment);
                BackpackMutable itemStorage = storageTraits.mutable(ComponentHolder.of(backpack));
                if (this.canItemFit(ComponentHolder.of(backpack), hotbar) && itemStorage.addItem(hotbar) != null) {
                    this.sound().atClient(player, ModSound.Type.INSERT);
                    itemStorage.push();
                }
                return hotbar.method_7960();
            });
        }
        if (slot instanceof class_1734) {
            class_1734 resultSlot = (class_1734)slot;
            if (!this.canItemFit(holder, hotbar)) {
                return;
            }
            MutableItemStorage mutable = this.mutable(holder);
            int toAdd = mutable.getMaxAmountToAdd(hotbar);
            Optional optional = resultSlot.method_34264(hotbar.method_7947(), toAdd, player);
            if (optional.isEmpty()) {
                return;
            }
            class_1799 removed = (class_1799)optional.get();
            resultSlot.method_7667(player, removed);
            if (mutable.addItem(removed) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
                mutable.push();
            }
            return;
        }
        if (clickType.isShift()) {
            MutableItemStorage mutable = this.mutable(holder);
            if (mutable.addItem(hotbar) != null) {
                this.sound().atClient(player, ModSound.Type.INSERT);
                mutable.push();
            }
            return;
        }
        class_1799 carried = menu.method_34255();
        if (hotbar.method_7960() && carried.method_7960()) {
            return;
        }
        if (!hotbar.method_7960() && !carried.method_7960()) {
            if (class_1799.method_31577((class_1799)hotbar, (class_1799)carried)) {
                int count = clickType.isRight() ? 1 : carried.method_7947();
                int toAdd = Math.min(hotbar.method_7914() - hotbar.method_7947(), count);
                hotbar.method_7933(toAdd);
                carried.method_7934(toAdd);
            } else {
                slot.method_7673(carried);
                menu.method_34254(hotbar);
            }
        } else if (clickType.isRight()) {
            if (hotbar.method_7960()) {
                class_1799 copy = carried.method_46651(1);
                carried.method_7934(1);
                slot.method_7673(copy);
            } else {
                int count = class_3532.method_15386((float)((float)hotbar.method_7947() / 2.0f));
                class_1799 split = hotbar.method_7971(count);
                menu.method_34254(split);
            }
        } else {
            slot.method_7673(carried);
            menu.method_34254(hotbar);
        }
    }

    public abstract void tinyMenuClick(ComponentHolder var1, int var2, TinyClickType var3, class_5630 var4, class_1657 var5);
}

