/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits.lunch_box;

import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.IDraggingTrait;
import com.beansgalaxy.backpacks.traits.abstract_traits.ISlotSelectorTrait;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxClient;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxMutable;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_4174;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class LunchBoxTraits
extends BundleLikeTraits
implements ISlotSelectorTrait,
IDraggingTrait {
    public static final String NAME = "lunch";

    public LunchBoxTraits(ModSound sound, int size) {
        super(sound, size);
    }

    public LunchBoxClient client() {
        return LunchBoxClient.INSTANCE;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Nullable
    public static LunchBoxTraits get(class_1799 stack) {
        LunchBoxTraits traits = (LunchBoxTraits)stack.method_57824(Traits.LUNCH_BOX);
        if (traits != null) {
            return traits;
        }
        ReferenceTrait reference = (ReferenceTrait)stack.method_57824(Traits.REFERENCE);
        if (reference == null) {
            return null;
        }
        Optional<GenericTraits> optional = reference.getTrait();
        if (optional.isEmpty()) {
            return null;
        }
        GenericTraits genericTraits = optional.get();
        if (genericTraits instanceof LunchBoxTraits) {
            LunchBoxTraits lunch = (LunchBoxTraits)genericTraits;
            return lunch;
        }
        return null;
    }

    public static void ifPresent(class_1799 lunchBox, Consumer<LunchBoxTraits> ifPresent) {
        LunchBoxTraits boxTraits = (LunchBoxTraits)lunchBox.method_57824(Traits.LUNCH_BOX);
        if (boxTraits != null) {
            ifPresent.accept(boxTraits);
            return;
        }
        ReferenceTrait referenceTrait = (ReferenceTrait)lunchBox.method_57824(Traits.REFERENCE);
        if (referenceTrait == null) {
            return;
        }
        referenceTrait.getTrait().ifPresent(traits -> {
            if (traits instanceof LunchBoxTraits) {
                LunchBoxTraits lunchBoxTraits = (LunchBoxTraits)traits;
                ifPresent.accept(lunchBoxTraits);
            }
        });
    }

    public static void selectionIsPresent(class_1799 lunchBox, class_1309 entity, Consumer<class_1799> ifPresent) {
        LunchBoxTraits.ifPresent(lunchBox, traits -> {
            int n;
            LunchBoxMutable mutable = traits.mutable(ComponentHolder.of(lunchBox));
            if (mutable.isEmpty()) {
                return;
            }
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                n = mutable.getSelectedSlot(player);
            } else {
                n = 0;
            }
            int selectedSlotSafe = n;
            class_1799 food = mutable.getItemStacks().get(selectedSlotSafe);
            ifPresent.accept(food);
        });
    }

    public static void selectionIsPresent(class_1799 lunchBox, class_1657 player, Consumer<class_1799> ifPresent) {
        LunchBoxTraits.ifPresent(lunchBox, traits -> {
            LunchBoxMutable mutable = traits.mutable(ComponentHolder.of(lunchBox));
            if (mutable.isEmpty()) {
                return;
            }
            int selectedSlotSafe = mutable.getSelectedSlot(player);
            class_1799 food = mutable.getItemStacks().get(selectedSlotSafe);
            ifPresent.accept(food);
        });
    }

    public void finishUsingItem(ComponentHolder holder, class_1799 backpack, class_1937 level, class_1309 entity, CallbackInfoReturnable<class_1799> cir) {
        class_1799 consumedStack;
        int n;
        LunchBoxMutable mutable = this.mutable(holder);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            n = mutable.getSelectedSlot(player);
        } else {
            n = 0;
        }
        int selectedSlot = n;
        List<class_1799> itemStacks = mutable.getItemStacks();
        class_1799 stack = itemStacks.get(selectedSlot);
        class_1799 copy = stack.method_46651(1);
        stack.method_7934(1);
        if (stack.method_7960()) {
            itemStacks.remove(selectedSlot);
        }
        if (!(consumedStack = copy.method_7910(level, entity)).method_7960()) {
            for (int i = 0; i < itemStacks.size(); ++i) {
                class_1799 nonEdible = itemStacks.get(i);
                if (nonEdible.method_7960()) {
                    itemStacks.remove(i);
                    continue;
                }
                if (!class_1799.method_31577((class_1799)nonEdible, (class_1799)consumedStack)) continue;
                class_1799 removed = itemStacks.remove(i);
                consumedStack.method_7933(removed.method_7947());
                mutable.limitSelectedSlot(i);
            }
            if (!consumedStack.method_7960()) {
                itemStacks.addFirst(consumedStack);
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    mutable.setSelectedSlot(player, mutable.getSelectedSlot(player));
                }
                mutable.growSelectedSlot(0);
            }
        }
        mutable.push();
        cir.setReturnValue((Object)backpack);
    }

    @Override
    public void use(class_1937 level, class_1657 player, class_1268 hand, ComponentHolder holder, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        LunchBoxMutable mutable = this.mutable(holder);
        if (mutable.isEmpty()) {
            return;
        }
        int selected = mutable.getSelectedSlot(player);
        class_1799 first = mutable.getItemStacks().get(selected);
        class_4174 $$4 = (class_4174)first.method_57824(class_9334.field_50075);
        if ($$4 != null && player.method_7332($$4.comp_2493())) {
            player.method_6019(hand);
            class_1799 backpack = player.method_5998(hand);
            cir.setReturnValue((Object)class_1271.method_22428((Object)backpack));
        }
    }

    @Override
    public boolean canItemFit(ComponentHolder holder, class_1799 inserted) {
        return inserted.method_57826(class_9334.field_50075) && super.canItemFit(holder, inserted);
    }

    @Override
    public LunchBoxMutable mutable(ComponentHolder holder) {
        return new LunchBoxMutable(this, holder);
    }

    public String toString() {
        return "LunchBoxTraits{size=" + this.size() + ", sound=" + String.valueOf((Object)this.sound()) + "}";
    }

    @Override
    public TraitComponentKind<? extends GenericTraits> kind() {
        return Traits.LUNCH_BOX;
    }
}

