/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util;

import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class CollidingVertexMap {
    final class_238 starting_box;
    final class_1937 level;
    final class_243 cursor;
    public class_238 box;
    class_2350 direction;
    class_243[] clipped = new class_243[4];
    class_243[] hanging = new class_243[4];
    int pointer = 0;

    public CollidingVertexMap(class_238 box, class_2350 direction, class_1937 level, class_243 cursor) {
        this.direction = direction;
        this.level = level;
        this.box = box;
        this.starting_box = box;
        this.cursor = cursor;
        this.updateCords();
    }

    private void updateCords() {
        class_243[] clip;
        class_243[] hang;
        switch (this.direction) {
            case field_11043: {
                hang = new class_243[]{new class_243(this.box.field_1323, this.box.field_1325, this.box.field_1321), new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1321), new class_243(this.box.field_1320, this.box.field_1322, this.box.field_1321), new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1321)};
                clip = new class_243[]{new class_243(this.box.field_1323, this.box.field_1325, this.box.field_1324), new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1324), new class_243(this.box.field_1320, this.box.field_1322, this.box.field_1324), new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1324)};
                break;
            }
            case field_11035: {
                clip = new class_243[]{new class_243(this.box.field_1323, this.box.field_1325, this.box.field_1321), new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1321), new class_243(this.box.field_1320, this.box.field_1322, this.box.field_1321), new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1321)};
                hang = new class_243[]{new class_243(this.box.field_1323, this.box.field_1325, this.box.field_1324), new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1324), new class_243(this.box.field_1320, this.box.field_1322, this.box.field_1324), new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1324)};
                break;
            }
            case field_11034: {
                hang = new class_243[]{new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1324), new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1321), new class_243(this.box.field_1320, this.box.field_1322, this.box.field_1321), new class_243(this.box.field_1320, this.box.field_1322, this.box.field_1324)};
                clip = new class_243[]{new class_243(this.box.field_1323, this.box.field_1325, this.box.field_1324), new class_243(this.box.field_1323, this.box.field_1325, this.box.field_1321), new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1321), new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1324)};
                break;
            }
            case field_11039: {
                clip = new class_243[]{new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1324), new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1321), new class_243(this.box.field_1320, this.box.field_1322, this.box.field_1321), new class_243(this.box.field_1320, this.box.field_1322, this.box.field_1324)};
                hang = new class_243[]{new class_243(this.box.field_1323, this.box.field_1325, this.box.field_1324), new class_243(this.box.field_1323, this.box.field_1325, this.box.field_1321), new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1321), new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1324)};
                break;
            }
            case field_11036: 
            case field_11033: {
                clip = new class_243[]{new class_243(this.box.field_1320, this.box.field_1322, this.box.field_1324), new class_243(this.box.field_1320, this.box.field_1322, this.box.field_1321), new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1321), new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1324)};
                hang = new class_243[]{new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1324), new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1321), new class_243(this.box.field_1323, this.box.field_1325, this.box.field_1321), new class_243(this.box.field_1323, this.box.field_1325, this.box.field_1324)};
                break;
            }
            default: {
                return;
            }
        }
        this.clipped = clip;
        this.hanging = hang;
    }

    public boolean areClippedPointsStable() {
        this.pointer = 0;
        while (this.pointer < 4) {
            class_243 v = this.clipped[this.pointer];
            class_243 offs = new class_243(0.1, 0.1, 0.1);
            Iterable blockCollisions = this.level.method_20812(null, new class_238(v.method_1019(offs), v.method_1020(offs)));
            boolean noCollision = true;
            block1: for (class_265 collision : blockCollisions) {
                for (class_238 ab : collision.method_1090()) {
                    boolean minX = v.field_1352 >= ab.field_1323;
                    boolean maxX = v.field_1352 <= ab.field_1320;
                    boolean minY = v.field_1351 >= ab.field_1322;
                    boolean maxY = v.field_1351 <= ab.field_1325;
                    boolean minZ = v.field_1350 >= ab.field_1321;
                    boolean maxZ = v.field_1350 <= ab.field_1324;
                    boolean contains = minX && maxX && minY && maxY && minZ && maxZ;
                    if (!contains) continue;
                    noCollision = false;
                    continue block1;
                }
            }
            if (noCollision) {
                return false;
            }
            ++this.pointer;
        }
        return true;
    }

    public void stabilizeHangingPoints() {
        class_243 vFace;
        int i;
        class_243[] face;
        class_243 size = new class_243(0.21875, 0.28125, 0.21875);
        class_238 aabb = new class_238(this.cursor.method_1019(size), this.cursor.method_1020(size));
        class_243 center = aabb.method_1005();
        class_243 px = new class_243(aabb.field_1320, center.field_1351, center.field_1350);
        class_243 nx = new class_243(aabb.field_1323, center.field_1351, center.field_1350);
        class_243 pz = new class_243(center.field_1352, center.field_1351, aabb.field_1324);
        class_243 nz = new class_243(center.field_1352, center.field_1351, aabb.field_1321);
        class_243[] pair = switch (this.direction) {
            case class_2350.field_11043 -> {
                face = new class_243[]{nz};
                yield new class_243[]{pz};
            }
            case class_2350.field_11035 -> {
                face = new class_243[]{pz};
                yield new class_243[]{nz};
            }
            case class_2350.field_11034 -> {
                face = new class_243[]{px};
                yield new class_243[]{nx};
            }
            case class_2350.field_11039 -> {
                face = new class_243[]{nx};
                yield new class_243[]{px};
            }
            default -> {
                face = new class_243[]{nx, nz, px, pz};
                yield new class_243[]{px, pz, nx, nz};
            }
        };
        int index = -1;
        for (i = 0; i < face.length; ++i) {
            vFace = face[i];
            class_3965 lineOfSightToCursor = this.level.method_17742(new class_3959(vFace, this.cursor, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
            boolean noLineOfSight = class_239.class_240.field_1332.equals((Object)lineOfSightToCursor.method_17783());
            if (noLineOfSight || this.doesCollide(vFace)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            i = index;
            do {
                class_3965 clip;
                boolean hasLinOfSight;
                vFace = face[i];
                class_243 vPair = pair[i];
                if (this.doesCollide(vFace)) continue;
                class_3965 lineOfSightToCursor = this.level.method_17742(new class_3959(vFace, this.cursor, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
                boolean bl = hasLinOfSight = !class_239.class_240.field_1332.equals((Object)lineOfSightToCursor.method_17783());
                if (!hasLinOfSight || !class_239.class_240.field_1332.equals((Object)(clip = this.level.method_17742(new class_3959(vFace, vPair, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()))).method_17783())) continue;
                class_243 location = clip.method_17784();
                class_243 offset = location.method_1020(vPair);
                if (!(Math.abs(offset.field_1352) + Math.abs(offset.field_1351) + Math.abs(offset.field_1350) > 0.001)) continue;
                for (int j = 0; j < face.length; ++j) {
                    face[j] = face[j].method_1019(offset);
                    pair[j] = pair[j].method_1019(offset);
                }
                aabb = aabb.method_997(offset);
            } while ((i = (i + 1) % face.length) != index);
        }
        class_238 start = aabb.method_989(0.0, 1.0, 0.0);
        class_238 zone = start.method_1012(0.0, -1.0, 0.0);
        Iterable iterable = this.level.method_8600(null, zone);
        double yOff = 1.0 + class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11052, (class_238)start, (Iterable)iterable, (double)-1.0);
        this.box = aabb = aabb.method_989(0.0, yOff, 0.0);
        this.updateCords();
    }

    private boolean doesCollide(class_243 v) {
        class_243 offs = new class_243(0.1, 0.1, 0.1);
        Iterable blockCollisions = this.level.method_20812(null, new class_238(v.method_1019(offs), v.method_1020(offs)));
        for (class_265 collision : blockCollisions) {
            for (class_238 ab : collision.method_1090()) {
                boolean contains = v.field_1352 >= ab.field_1323 && v.field_1352 <= ab.field_1320 && v.field_1351 >= ab.field_1322 && v.field_1351 <= ab.field_1325 && v.field_1350 >= ab.field_1321 && v.field_1350 <= ab.field_1324;
                if (!contains) continue;
                return true;
            }
        }
        return false;
    }

    public void pushClippedPoints() {
        this.pointer = 0;
        while (this.pointer < 4) {
            class_243 tl = this.clipped[this.pointer];
            class_243 tr = this.clipped[(this.pointer + 1) % 4];
            class_243 bl = this.clipped[(this.pointer + 3) % 4];
            boolean doesCollide = this.doesCollide(tl);
            if (!doesCollide) {
                class_3965 clip2 = this.level.method_17742(new class_3959(tl, tr, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
                class_3965 clip0 = this.level.method_17742(new class_3959(tl, bl, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
                boolean clip2Missed = class_239.class_240.field_1333.equals((Object)clip2.method_17783());
                boolean clip0Missed = class_239.class_240.field_1333.equals((Object)clip0.method_17783());
                if (!clip2Missed || !clip0Missed) {
                    class_243 offset;
                    if (!clip2Missed && !clip0Missed) {
                        class_243 zeroed2 = clip2.method_17784().method_1020(tl);
                        class_243 zeroed0 = clip0.method_17784().method_1020(tl);
                        class_243 zeroed = zeroed2.method_1019(zeroed0);
                        double absZ = Math.abs(zeroed.field_1350);
                        double absX = Math.abs(zeroed.field_1352);
                        offset = this.direction.method_10166().method_10178() ? (absX < absZ ? new class_243(zeroed.field_1352, 0.0, 0.0) : new class_243(0.0, 0.0, zeroed.field_1350)) : (Math.max(absZ, absX) < Math.abs(zeroed.field_1351) ? new class_243(zeroed.field_1352, 0.0, zeroed.field_1350) : new class_243(0.0, zeroed.field_1351, 0.0));
                    } else {
                        class_3965 clip = clip2Missed ? clip0 : clip2;
                        offset = clip.method_17784().method_1020(tl);
                    }
                    if (!(Math.abs(offset.field_1352) + Math.abs(offset.field_1351) + Math.abs(offset.field_1350) < 0.001)) {
                        this.move(offset);
                    }
                }
            }
            ++this.pointer;
        }
    }

    void move(class_243 offset) {
        this.box = this.box.method_997(offset);
        this.updateCords();
    }

    public void pushHangingPoints() {
        class_243 br;
        int success = 0;
        class_243[] list = new class_243[]{null, null, null, null};
        int count = 0;
        this.pointer = 0;
        while (this.pointer < 4) {
            class_3965 clip2;
            br = this.hanging[(this.pointer + 2) % 4];
            if (!this.doesCollide(br) && (clip2 = this.level.method_17742(new class_3959(br, this.cursor, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()))).method_17783().equals((Object)class_239.class_240.field_1333)) {
                list[this.pointer] = br;
                ++count;
            }
            ++this.pointer;
        }
        if (count == 3) {
            this.pointer = 0;
            while (this.pointer < 4) {
                br = list[this.pointer];
                if (br != null) {
                    class_243 tl = this.hanging[this.pointer];
                    class_243 tr = this.hanging[(this.pointer + 1) % 4];
                    class_243 bl = this.hanging[(this.pointer + 3) % 4];
                    class_3965 clipR = this.level.method_17742(new class_3959(tr, tl, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
                    class_243 contactR = clipR.method_17784();
                    class_3965 clipL = this.level.method_17742(new class_3959(bl, tl, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
                    class_243 contactL = clipL.method_17784();
                    class_243 offsR = tl.method_1020(contactR).method_18805(-1.0, -1.0, -1.0);
                    class_243 offsL = tl.method_1020(contactL).method_18805(-1.0, -1.0, -1.0);
                    class_243 zeroed = offsR.method_1019(offsL);
                    double absZ = Math.abs(zeroed.field_1350);
                    double absX = Math.abs(zeroed.field_1352);
                    class_243 offs = this.direction.method_10166().method_10178() ? (absX < absZ ? new class_243(zeroed.field_1352, 0.0, 0.0) : new class_243(0.0, 0.0, zeroed.field_1350)) : (Math.max(absZ, absX) < Math.abs(zeroed.field_1351) ? new class_243(zeroed.field_1352, 0.0, zeroed.field_1350) : new class_243(0.0, zeroed.field_1351, 0.0));
                    this.move(offs);
                }
                ++this.pointer;
            }
        } else {
            this.pointer = 0;
            while (this.pointer < 4 && success < 2) {
                br = list[this.pointer];
                if (br != null) {
                    class_243 offs;
                    class_243 contact;
                    class_3965 clip2;
                    class_243 tr = this.hanging[(this.pointer + 1) % 4];
                    class_243 bl = this.hanging[(this.pointer + 3) % 4];
                    int steps = 0;
                    class_243 offset = class_243.field_1353;
                    if (this.doesCollide(tr)) {
                        clip2 = this.level.method_17742(new class_3959(br, tr, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
                        contact = clip2.method_17784();
                        offs = tr.method_1020(contact).method_18805(-1.0, -1.0, -1.0);
                        offset = offset.method_1019(offs);
                        ++steps;
                    }
                    if (this.doesCollide(bl)) {
                        clip2 = this.level.method_17742(new class_3959(br, bl, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
                        contact = clip2.method_17784();
                        offs = bl.method_1020(contact).method_18805(-1.0, -1.0, -1.0);
                        offset = offset.method_1019(offs);
                        ++steps;
                    }
                    if (class_243.field_1353 != offset) {
                        this.move(offset);
                        success += steps;
                    }
                }
                ++this.pointer;
            }
        }
    }
}

