/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.util.data_fixers;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.components.ender.EmptyEnderItem;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.items.ModItems;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.util.data_fixers.BPack2PlayerFix;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_8053;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class RecoverLocalData {
    public static void readEntity(BackpackEntity entity, class_2487 tag) {
        class_1799 backpack;
        class_5455 access = entity.method_56673();
        entity.setDirection(class_2350.method_10143((int)tag.method_10571("facing")));
        entity.method_5875(tag.method_10577("hanging"));
        class_1299 type = entity.method_5864();
        if (type == CommonClass.LEGACY_ENDER_ENTITY) {
            backpack = ModItems.EMPTY_ENDER_POUCH.get().method_7854();
            backpack.method_57379(Traits.EMPTY_ENDER, (Object)new EmptyEnderItem.UnboundEnderTraits(EnderStorage.LEGACY_ENDER_LOCATION));
        } else {
            class_2487 localDataTag = tag.method_10562("local_data");
            LocalData localData = new LocalData(localDataTag);
            backpack = localData.toStack(access, tag);
        }
        entity.method_5841().method_12778(BackpackEntity.ITEM_STACK, (Object)backpack);
    }

    public static ArrayList<class_1799> readStackNbt(class_2487 nbt, class_5455 access) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        class_2499 nbtList = nbt.method_10554("Items", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            class_6903 context = access.method_57093((DynamicOps)class_2509.field_11560);
            Dynamic dynamic = new Dynamic((DynamicOps)context, (Object)nbtCompound);
            Dynamic updated = BPack2PlayerFix.updateVersion(dynamic);
            class_1799.field_24671.parse(updated).ifSuccess(stack -> {
                if (!stack.method_7960()) {
                    list.add((class_1799)stack);
                }
            });
        }
        return list;
    }

    public static class LocalData {
        public final Kind kind;
        public final String backpack_id;
        public int color = 0xFFFFFF;
        private class_2487 trim = new class_2487();

        public LocalData(class_2487 tag) {
            String kindString = tag.method_10558("kind");
            this.kind = Kind.fromName(kindString);
            this.backpack_id = tag.method_10558("backpack_id");
            if (!tag.method_10545("empty") || !tag.method_10577("empty")) {
                this.color = tag.method_10550("color");
                this.trim = tag.method_10562("Trim");
            }
        }

        public class_1799 toStack(class_5455 access, class_2487 tag) {
            class_1799 backpack;
            switch (this.kind.ordinal()) {
                case 1: {
                    backpack = switch (this.backpack_id) {
                        case "gold" -> ModItems.GOLD_BACKPACK.get().method_7854();
                        case "netherite" -> ModItems.NETHERITE_BACKPACK.get().method_7854();
                        default -> ModItems.IRON_BACKPACK.get().method_7854();
                    };
                    class_6903 ops = access.method_57093((DynamicOps)class_2509.field_11560);
                    class_8053.field_41994.parse((DynamicOps)ops, (Object)this.trim).ifSuccess(armorTrim -> backpack.method_57379(class_9334.field_49607, armorTrim));
                    ArrayList<class_1799> stacks = RecoverLocalData.readStackNbt(tag, access);
                    backpack.method_57379(ITraitData.ITEM_STACKS, stacks);
                    break;
                }
                case 0: 
                case 6: {
                    backpack = ModItems.LEATHER_BACKPACK.get().method_7854();
                    class_9282 itemColor = new class_9282(this.color, true);
                    backpack.method_57379(class_9334.field_49644, (Object)itemColor);
                    ArrayList<class_1799> stacks = RecoverLocalData.readStackNbt(tag, access);
                    backpack.method_57379(ITraitData.ITEM_STACKS, stacks);
                    break;
                }
                case 2: {
                    backpack = ModItems.LEATHER_BACKPACK.get().method_7854();
                    class_9282 itemColor = new class_9282(this.color, true);
                    backpack.method_57379(class_9334.field_49644, (Object)itemColor);
                    ArrayList<class_1799> stacks = RecoverLocalData.readStackNbt(tag, access);
                    class_2520 itemTags = tag.method_10580("item_tags");
                    if (itemTags != null) {
                        class_2487 compoundTag = new class_2487();
                        compoundTag.method_10582("id", "minecraft:elytra");
                        compoundTag.method_10569("count", 1);
                        compoundTag.method_10566("tag", itemTags);
                        class_6903 context = access.method_57093((DynamicOps)class_2509.field_11560);
                        Dynamic dynamic = new Dynamic((DynamicOps)context, (Object)compoundTag);
                        Dynamic updated = BPack2PlayerFix.updateVersion(dynamic);
                        DataResult parse = class_1799.field_24671.parse(updated);
                        if (parse.isSuccess()) {
                            stacks.add((class_1799)parse.getOrThrow());
                        } else {
                            stacks.add(class_1802.field_8833.method_7854());
                        }
                    } else {
                        stacks.add(class_1802.field_8833.method_7854());
                    }
                    backpack.method_57379(ITraitData.ITEM_STACKS, stacks);
                    break;
                }
                case 3: {
                    backpack = ModItems.EMPTY_ENDER_POUCH.get().method_7854();
                    backpack.method_57379(Traits.EMPTY_ENDER, (Object)new EmptyEnderItem.UnboundEnderTraits(EnderStorage.LEGACY_ENDER_LOCATION));
                    break;
                }
                default: {
                    backpack = ModItems.IRON_BACKPACK.get().method_7854();
                }
            }
            return backpack;
        }
    }

    public static enum Kind {
        LEATHER,
        METAL,
        WINGED,
        ENDER,
        POT,
        CAULDRON,
        BIG_BUNDLE;


        public static Kind fromName(String string) {
            for (Kind kind : Kind.values()) {
                if (!kind.name().equals(string)) continue;
                return kind;
            }
            return METAL;
        }
    }
}

