/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.access.PlayerAccessor;
import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.network.serverbound.BackpackUseOn;
import com.beansgalaxy.backpacks.network.serverbound.InstantKeyPress;
import com.beansgalaxy.backpacks.network.serverbound.SyncHotkey;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import java.util.OptionalInt;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7298;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class KeyPress {
    public static final KeyPress INSTANCE = new KeyPress();
    public static final String KEY_CATEGORY = "key.beansbackpacks.category";
    public static final String ACTION_KEY_IDENTIFIER = "key.beansbackpacks.action";
    public static final String MENUS_KEY_IDENTIFIER = "key.beansbackpacks.inventory";
    public static final String INSTANT_KEY_IDENTIFIER = "key.beansbackpacks.instant";
    public static final String ACTION_KEY_DESC = "key.beansbackpacks.desc.action";
    public static final String MENUS_KEY_DESC = "key.beansbackpacks.desc.inventory";
    public static final String INSTANT_KEY_DESC = "key.beansbackpacks.desc.instant";
    public static final String ACTION_KEY_DISABLED = "key.beansbackpacks.action_disabled";
    public static final String ACTION_KEY_DISABLED_DESC = "key.beansbackpacks.desc.action_disabled";
    public static final String SPYGLASS_KEY_IDENTIFIER = "key.beansbackpacks.spyglass";
    public final class_304 ACTION_KEY = new class_304("key.beansbackpacks.action", -1, "key.beansbackpacks.category");
    public final class_304 MENUS_KEY = new class_304("key.beansbackpacks.inventory", -1, "key.beansbackpacks.category");
    public final class_304 INSTANT_KEY = new class_304("key.beansbackpacks.instant", -1, "key.beansbackpacks.category");
    public final class_304 SPYGLASS_KEY = new class_304("key.beansbackpacks.spyglass", 66, "key.beansbackpacks.category");
    @Nullable
    private CoyoteClick coyoteClick = null;
    private boolean wasUtilityDown = false;

    public void tick(class_310 minecraft, class_746 player, class_9779 delta) {
        isPressed actionKey;
        if (this.coyoteClick != null) {
            if (this.coyoteClick.shouldUnload(minecraft, player)) {
                this.unloadCoyoteClick(minecraft, player, this.coyoteClick);
            } else if (player.method_6115()) {
                this.cancelCoyoteClick();
            }
        }
        boolean actionKeyPressed = (actionKey = KeyPress.isPressed(minecraft, KeyPress.getActionKeyBind())).pressed() && this.INSTANT_KEY.method_1415();
        isPressed menusKey = KeyPress.isPressed(minecraft, KeyPress.getMenusKeyBind());
        int tinyChestSlot = -1;
        boolean menuKeyPressed = menusKey.pressed();
        BackData backData = BackData.get((class_1657)player);
        if (actionKeyPressed == backData.isActionKeyDown() && menuKeyPressed == backData.isMenuKeyDown()) {
            return;
        }
        backData.setActionKey(actionKeyPressed);
        backData.setMenuKey(menuKeyPressed);
        backData.setTinySlot(tinyChestSlot);
        SyncHotkey.send(actionKeyPressed, menuKeyPressed, tinyChestSlot);
    }

    private void unloadCoyoteClick(class_310 minecraft, class_746 player, CoyoteClick coyoteClick) {
        class_1268 interactionhand;
        class_1799 itemstack;
        class_1268[] class_1268Array = class_1268.values();
        int n = class_1268Array.length;
        for (int i = 0; i < n && (itemstack = player.method_5998(interactionhand = class_1268Array[i])).method_45435(minecraft.field_1687.method_45162()); ++i) {
            int i2 = itemstack.method_7947();
            class_1269 interactionresult = minecraft.field_1761.method_2896(player, interactionhand, coyoteClick.blockhitresult);
            if (!interactionresult.method_23665()) continue;
            if (!interactionresult.method_23666()) break;
            player.method_6104(interactionhand);
            if (itemstack.method_7960() || itemstack.method_7947() == i2 && !minecraft.field_1761.method_2914()) break;
            minecraft.field_1773.field_4012.method_3215(interactionhand);
            break;
        }
        this.cancelCoyoteClick();
    }

    public OptionalInt loadCoyoteClick(class_746 player, class_3965 hitResult) {
        class_1304[] slots;
        if (this.coyoteClick != null) {
            if (this.coyoteClick.isFinished()) {
                class_1304 slot = this.coyoteClick.slot;
                BackpackTraits traits = this.coyoteClick.traits;
                this.coyoteClick = null;
                class_1799 backpack = player.method_6118(slot);
                if (BackpackUseOn.placeBackpack((class_1657)player, hitResult, backpack, traits)) {
                    BackpackUseOn.send(hitResult, slot);
                    return OptionalInt.of(8);
                }
                return OptionalInt.of(4);
            }
            this.coyoteClick.indexProgress();
            return OptionalInt.of(0);
        }
        if (this.pickUpThru(player)) {
            return OptionalInt.of(0);
        }
        for (class_1304 slot : slots = new class_1304[]{class_1304.field_48824, class_1304.field_6173, class_1304.field_6171}) {
            class_1799 backpack = player.method_6118(slot);
            BackpackTraits traits = BackpackTraits.get(backpack);
            if (traits == null) continue;
            this.coyoteClick = new CoyoteClick(slot, traits, hitResult);
            return OptionalInt.of(0);
        }
        return OptionalInt.empty();
    }

    public void cancelCoyoteClick() {
        this.coyoteClick = null;
    }

    public boolean hasCoyoteClick() {
        return this.coyoteClick != null;
    }

    public float placementProgress() {
        if (this.coyoteClick == null) {
            return 0.0f;
        }
        return (float)this.coyoteClick.progress / 4.0f;
    }

    public boolean pickUpThru(class_746 player) {
        class_238 aabb;
        double pBlockInteractionRange = player.method_55754();
        double d0 = Math.max(pBlockInteractionRange, player.method_55755());
        double d1 = class_3532.method_33723((double)d0);
        float pPartialTick = 1.0f;
        class_243 vec3 = player.method_5836(pPartialTick);
        class_243 vec31 = player.method_5828(pPartialTick);
        class_243 vec32 = vec3.method_1031(vec31.field_1352 * d0, vec31.field_1351 * d0, vec31.field_1350 * d0);
        class_3966 entityhitresult = class_1675.method_18075((class_1297)player, (class_243)vec3, (class_243)vec32, (class_238)(aabb = player.method_5829().method_18804(vec31.method_1021(d0)).method_1009(1.0, 1.0, 1.0)), p_234237_ -> !p_234237_.method_7325() && p_234237_.method_5863(), (double)d1);
        if (entityhitresult == null || class_239.class_240.field_1333.equals((Object)entityhitresult.method_17783())) {
            return false;
        }
        class_243 vec33 = entityhitresult.method_17784();
        if (!vec33.method_24802((class_2374)vec33, pBlockInteractionRange)) {
            return false;
        }
        class_1297 entity = entityhitresult.method_17782();
        if (!player.method_6057(entity)) {
            return false;
        }
        return KeyPress.tryEquip(player, entity);
    }

    public static boolean tryEquip(class_746 player, class_1297 entity) {
        if (entity instanceof BackpackEntity) {
            BackpackEntity backpack = (BackpackEntity)entity;
            class_1269 tryEquip = backpack.tryEquip((class_1657)player);
            if (tryEquip.method_23665()) {
                InstantKeyPress.send(entity.method_5628());
            }
            return true;
        }
        if (entity instanceof class_1531) {
            class_1531 armorStand = (class_1531)entity;
            class_1269 tryEquip = CommonClass.swapBackWith(armorStand, (class_1657)player);
            if (tryEquip.method_23665()) {
                InstantKeyPress.send(entity.method_5628());
            }
            return true;
        }
        if (entity instanceof class_7298) {
            class_7298 allay = (class_7298)entity;
            class_1269 tryEquip = CommonClass.swapBackWith(allay, (class_1657)player);
            if (tryEquip.method_23665()) {
                InstantKeyPress.send(entity.method_5628());
            }
            return true;
        }
        return false;
    }

    public static boolean placeBackpack(class_1657 player, class_3965 hitResult) {
        return KeyPress.tryPlace(player, hitResult, class_1304.field_6173) || KeyPress.tryPlace(player, hitResult, class_1304.field_48824);
    }

    private static boolean tryPlace(class_1657 player, class_3965 hitResult, class_1304 slot) {
        class_1799 backpack = player.method_6118(slot);
        BackpackTraits traits = BackpackTraits.get(backpack);
        if (traits == null) {
            return false;
        }
        if (BackpackUseOn.placeBackpack(player, hitResult, backpack, traits)) {
            BackpackUseOn.send(hitResult, slot);
            return true;
        }
        return false;
    }

    public static class_304 getDefaultKeyBind() {
        class_310 instance = class_310.method_1551();
        return instance.field_1690.field_1867;
    }

    public static class_304 getActionKeyBind() {
        class_304 sprintKey = KeyPress.getDefaultKeyBind();
        class_304 customKey = KeyPress.INSTANCE.ACTION_KEY;
        return customKey.method_1415() ? sprintKey : customKey;
    }

    public static class_304 getMenusKeyBind() {
        class_304 sprintKey = KeyPress.getActionKeyBind();
        class_304 customKey = KeyPress.INSTANCE.MENUS_KEY;
        return customKey.method_1415() ? sprintKey : customKey;
    }

    @NotNull
    public static isPressed isPressed(class_310 minecraft, class_304 bind) {
        class_304 sneakKey = minecraft.field_1690.field_1832;
        if (sneakKey.method_1435(bind)) {
            sneakKey.method_23481(bind.method_1434());
        }
        class_3675.class_306 key = class_3675.method_15981((String)bind.method_1428());
        long window = minecraft.method_22683().method_4490();
        int value = key.method_1444();
        boolean isMouseKey = key.method_1442().equals((Object)class_3675.class_307.field_1672);
        boolean isPressed2 = isMouseKey ? GLFW.glfwGetMouseButton((long)window, (int)value) == 1 : class_3675.method_15987((long)window, (int)value);
        return new isPressed(isMouseKey, isPressed2);
    }

    public void handleUtility(class_746 player, class_239 result) {
        boolean isUtilityDown = this.SPYGLASS_KEY.method_1434();
        if (isUtilityDown != this.wasUtilityDown) {
            UtilityComponent.testItems((class_1657)player, (item, mute) -> {
                if (item.method_31574(class_1802.field_27070)) {
                    PlayerAccessor access = (PlayerAccessor)player;
                    access.setUtilityScoped(isUtilityDown);
                    if (isUtilityDown) {
                        player.method_5783(class_3417.field_26972, 1.0f, 1.0f);
                    }
                    return true;
                }
                return false;
            });
        }
        this.wasUtilityDown = isUtilityDown;
    }

    private static class CoyoteClick {
        final class_1304 slot;
        final BackpackTraits traits;
        final class_3965 blockhitresult;
        int progress = 1;

        private CoyoteClick(class_1304 slot, BackpackTraits backpack, class_3965 blockhitresult) {
            this.slot = slot;
            this.traits = backpack;
            this.blockhitresult = blockhitresult;
        }

        void indexProgress() {
            ++this.progress;
        }

        boolean isFinished() {
            return this.progress > 4;
        }

        public boolean shouldUnload(class_310 minecraft, class_746 player) {
            if (!minecraft.field_1690.field_1904.method_1434()) {
                return true;
            }
            class_239 class_2392 = minecraft.field_1765;
            if (class_2392 instanceof class_3965) {
                class_3965 hitResult = (class_3965)class_2392;
                return !hitResult.method_17777().equals((Object)this.blockhitresult.method_17777()) || !hitResult.method_17780().equals((Object)this.blockhitresult.method_17780());
            }
            return true;
        }
    }

    public record isPressed(boolean onMouse, boolean pressed) {
    }
}

