/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.client.renderer.BackpackCapeModel;
import com.beansgalaxy.backpacks.client.renderer.BackpackModel;
import com.beansgalaxy.backpacks.client.renderer.RenderBackpack;
import com.beansgalaxy.backpacks.components.equipable.EquipmentModel;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import java.util.HashSet;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_776;
import net.minecraft.class_918;
import org.joml.Quaternionf;

public class BackFeature
extends class_3887<class_742, class_591<class_742>>
implements RenderBackpack {
    private final BackpackModel<class_742> model;
    private final BackpackCapeModel<class_742> capeModel;
    private final class_918 itemRenderer;
    private final class_776 blockDispatcher;

    public BackFeature(class_3883<class_742, class_591<class_742>> pRenderer, class_918 itemRenderer, class_5599 modelSet, class_776 blockDispatcher) {
        super(pRenderer);
        this.itemRenderer = itemRenderer;
        this.model = new BackpackModel(modelSet.method_32072(BACKPACK_MODEL));
        this.capeModel = new BackpackCapeModel(modelSet.method_32072(PACK_CAPE_MODEL));
        this.blockDispatcher = blockDispatcher;
    }

    @Override
    public BackpackModel<?> model() {
        return this.model;
    }

    @Override
    public class_918 itemRenderer() {
        return this.itemRenderer;
    }

    @Override
    public class_776 blockRenderer() {
        return this.blockDispatcher;
    }

    public void render(class_4587 pose, class_4597 pBufferSource, int pCombinedLight, class_742 player, float limbAngle, float limbDistance, float tick, float animationProgress, float playerHeadYaw, float playerHeadPitch) {
        this.renderEquipables(pose, pBufferSource, pCombinedLight, player, tick);
    }

    private void renderEquipables(class_4587 pose, class_4597 pBufferSource, int pCombinedLight, class_742 player, float tick) {
        if (((Boolean)CommonClass.CLIENT_CONFIG.disable_equipable_render.get()).booleanValue()) {
            return;
        }
        BackpackTraits.runAllEquipped((class_1309)player, (traits, slot) -> {
            class_1799 itemStack = player.method_6118(slot);
            class_2960 texture = traits.getTexture();
            if (texture == null) {
                return;
            }
            pose.method_22903();
            ((class_591)this.method_17165()).field_3391.method_22703(pose);
            ViewableBackpack viewable = ViewableBackpack.get((class_1309)player);
            if (viewable.lastDelta > tick) {
                viewable.updateOpen();
            }
            float headPitch = class_3532.method_16439((float)tick, (float)viewable.lastPitch, (float)viewable.headPitch) * 0.25f;
            this.model().setOpenAngle(headPitch);
            viewable.lastDelta = tick;
            pose.method_46416(0.0f, 0.8125f, 0.0f);
            class_1799 chestStack = player.method_6118(class_1304.field_6174);
            if (((HashSet)CommonClass.CLIENT_CONFIG.elytra_model_equipment.get()).contains(chestStack.method_7909())) {
                float xRot = ((class_591)this.method_17165()).field_3391.field_3654;
                this.setUpWithWings(player, xRot, pose);
            } else {
                pose.method_46416(0.0f, player.method_18276() ? 0.0625f : 0.0f, 0.0f);
                if (!chestStack.method_7960()) {
                    pose.method_46416(0.0f, -0.0625f, 0.0625f);
                }
                this.renderCapeAbove(pose, pBufferSource, pCombinedLight, player, headPitch);
            }
            this.renderTexture(pose, pBufferSource, pCombinedLight, texture, itemStack, viewable);
            pose.method_22909();
        });
    }

    private void renderCapeAbove(class_4587 pose, class_4597 mbs, int light, class_742 player, float headPitch) {
        class_2960 cloakTexture = player.method_52814().comp_1627();
        if (cloakTexture != null) {
            float fallDistance = player.field_6017;
            float fallPitch = player.method_6128() ? 0.0f : (float)Math.log(fallDistance * 3.0f + 1.0f) * -0.05f;
            this.capeModel.cape.field_3675 = (float)Math.PI * 2;
            this.capeModel.cape.field_3654 = -headPitch;
            this.capeModel.cape.field_3656 = fallPitch * 6.0f - 11.0f;
            this.capeModel.cape.field_3655 = 2.0f;
            class_1921 renderType = class_1921.method_23572((class_2960)cloakTexture);
            class_4588 vertexConsumer = mbs.getBuffer(renderType);
            this.capeModel.cape.method_22699(pose, vertexConsumer, light, class_4608.field_21444, -1);
        }
    }

    private void setUpWithWings(class_742 player, float scale, class_4587 poseStack) {
        float wingSpread;
        boolean fallFlying = player.method_6128();
        if (fallFlying) {
            poseStack.method_46416(0.0f, 0.03125f, 0.0f);
            class_243 deltaMovement = player.method_18798();
            class_243 norm = deltaMovement.method_1029();
            wingSpread = norm.field_1351 > 0.0 ? 0.0f : (float)Math.pow(-norm.field_1351, 1.5);
        } else {
            wingSpread = 1.0f;
        }
        float xRot = 0.25f * wingSpread;
        float z = class_3532.method_16439((float)scale, (float)(fallFlying ? xRot : 0.25f), (float)-0.09375f);
        float y = class_3532.method_16439((float)scale, (float)(fallFlying ? -0.0625f : 0.0f), (float)0.1875f);
        poseStack.method_46416(0.0f, y, z);
        poseStack.method_22907(new Quaternionf().rotationXYZ(class_3532.method_16439((float)scale, (float)xRot, (float)0.0f), 0.0f, 0.0f));
    }

    private void renderModel(class_4587 pose, class_4597 pBufferSource, int pCombinedLight, class_742 player, class_1304 slot, EquipmentModel model, class_1799 itemStack) {
        model.attachments().forEach((attachment, location) -> {
            pose.method_22903();
            switch (attachment) {
                case HEAD: {
                    ((class_591)this.method_17165()).field_3398.method_22703(pose);
                    pose.method_46416(0.0f, -0.75f, 0.0f);
                    break;
                }
                case BODY: {
                    ((class_591)this.method_17165()).field_3391.method_22703(pose);
                    break;
                }
                case BACK: {
                    ((class_591)this.method_17165()).field_3391.method_22703(pose);
                    if (player.method_18276()) {
                        pose.method_46416(0.0f, 0.0625f, 0.0f);
                    }
                    if (player.method_6118(class_1304.field_6174).method_7960()) break;
                    pose.method_46416(0.0f, -0.0625f, 0.0625f);
                    break;
                }
                case L_ARM: {
                    ((class_591)this.method_17165()).field_27433.method_22703(pose);
                    pose.method_46416(0.0625f, -0.125f, 0.0f);
                    break;
                }
                case R_ARM: {
                    ((class_591)this.method_17165()).field_3401.method_22703(pose);
                    pose.method_46416(-0.0625f, -0.125f, 0.0f);
                    break;
                }
                case L_LEG: {
                    ((class_591)this.method_17165()).field_3397.method_22703(pose);
                    break;
                }
                case R_LEG: {
                    ((class_591)this.method_17165()).field_3392.method_22703(pose);
                }
            }
            this.renderBackpack(pose, pBufferSource, pCombinedLight, (class_2960)location, itemStack, (class_1309)player, player.field_17892, player.method_5628());
            pose.method_22909();
        });
    }
}

