/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.client.renderer.BackpackModel;
import com.beansgalaxy.backpacks.client.renderer.RenderBackpack;
import com.beansgalaxy.backpacks.traits.IEntityTraits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class EntityRender
extends class_897<BackpackEntity>
implements RenderBackpack {
    class_5601 BACKPACK_MODEL = new class_5601(class_2960.method_60654((String)"beansbackpacks:backpack_model"), "main");
    class_2960 TEXTURE = class_2960.method_60654((String)"beansbackpacks:textures/entity/backpack/null.png");
    public final BackpackModel<BackpackEntity> model;
    private final class_918 itemRenderer;
    private final class_776 blockDispatcher;

    public EntityRender(class_5617.class_5618 ctx) {
        super(ctx);
        this.model = new BackpackModel(ctx.method_32167(this.BACKPACK_MODEL));
        this.itemRenderer = ctx.method_32168();
        this.blockDispatcher = ctx.method_43337();
    }

    @Override
    public BackpackModel<?> model() {
        return this.model;
    }

    @Override
    public class_918 itemRenderer() {
        return this.itemRenderer;
    }

    @Override
    public class_776 blockRenderer() {
        return this.blockDispatcher;
    }

    public void render(@NotNull BackpackEntity backpack, float yaw, float tick, @NotNull class_4587 pose, @NotNull class_4597 source, int light) {
        if (backpack.method_31481()) {
            return;
        }
        double breakTime = backpack.viewable.wobble;
        class_1799 stack = (class_1799)backpack.method_5841().method_12789(BackpackEntity.ITEM_STACK);
        pose.method_22903();
        pose.method_22907(class_7833.field_40715.rotationDegrees((yaw += (float)(breakTime * (double)0.8f * Math.sin(breakTime / Math.PI * 3.0))) + 180.0f));
        IEntityTraits<?> traits = backpack.getTraits();
        class_2960 texture = traits.getTexture();
        pose.method_22903();
        pose.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        pose.method_46416(0.0f, -0.625f, -0.25f);
        ViewableBackpack viewable = backpack.viewable;
        if (viewable.lastDelta > tick) {
            viewable.updateOpen();
        }
        float headPitch = class_3532.method_16439((float)tick, (float)viewable.lastPitch, (float)viewable.headPitch) * 0.25f;
        this.model().setOpenAngle(headPitch);
        viewable.lastDelta = tick;
        pose.method_46416(0.0f, 0.8125f, 0.0f);
        this.renderTexture(pose, source, light, texture, stack, viewable);
        pose.method_22909();
        pose.method_22909();
        this.renderNameAndHitbox(pose, source, backpack, yaw, light);
    }

    public class_2960 getTextureLocation(BackpackEntity var1) {
        return this.TEXTURE;
    }

    public void renderNameAndHitbox(class_4587 pose, class_4597 mbs, BackpackEntity entity, float yaw, int light) {
        class_3966 hitResult;
        class_239 class_2392;
        class_310 minecraft = class_310.method_1551();
        if (!minecraft.field_1690.field_1842 && (class_2392 = minecraft.field_1765) instanceof class_3966 && (hitResult = (class_3966)class_2392).method_17782() == entity) {
            class_238 box;
            class_2561 displayName;
            if (this.method_3921(entity) && !Constants.isEmpty(displayName = entity.method_5476())) {
                pose.method_22903();
                double $$5 = this.field_4676.method_23168((class_1297)entity);
                if (!($$5 > 4096.0)) {
                    class_2350 direction = entity.method_5735();
                    double y = entity.method_23318() + 1.0;
                    double yOff = entity.method_23320() - this.field_4676.field_4686.method_19326().field_1351;
                    pose.method_22904((double)(direction.method_10148() * 5) / 16.0, y -= yOff / 16.0, (double)(direction.method_10165() * 5) / 16.0);
                    pose.method_22907(this.field_4676.method_24197());
                    pose.method_22905(-0.02f, -0.02f, 1.0f);
                    Matrix4f $$9 = pose.method_23760().method_23761();
                    float $$10 = class_310.method_1551().field_1690.method_19343(0.25f);
                    int $$11 = (int)($$10 * 255.0f) << 24;
                    class_327 $$12 = this.method_3932();
                    float $$13 = -$$12.method_27525((class_5348)displayName) / 2;
                    $$12.method_30882(displayName, $$13, 0.0f, 0x20FFFFFF, false, $$9, mbs, class_327.class_6415.field_33994, $$11, light);
                    $$12.method_30882(displayName, $$13, 0.0f, -1, false, $$9, mbs, class_327.class_6415.field_33993, 0, light);
                }
                pose.method_22909();
            }
            pose.method_22903();
            if (!entity.method_5735().method_10166().method_10179()) {
                double h = 0.5625;
                double w = 0.25;
                double d = 0.125;
                box = new class_238(w, 0.0, d, -w, h, -d);
                box.method_989(-entity.method_23317(), -entity.method_23318(), -entity.method_23321());
            } else {
                box = entity.method_5829().method_989(-entity.method_23317(), -entity.method_23318(), -entity.method_23321());
                float yRot = entity.method_5735().method_10144();
                yaw += yRot;
            }
            pose.method_22907(class_7833.field_40715.rotationDegrees(yaw));
            class_4588 vertices = mbs.getBuffer(class_1921.method_23594());
            class_761.method_22982((class_4587)pose, (class_4588)vertices, (class_238)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            pose.method_22909();
        }
    }
}

