/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_918;

public interface RenderUtilities {
    public class_918 itemRenderer();

    public class_776 blockRenderer();

    default public void tryRenderUtilities(class_4587 pose, class_4597 pBufferSource, int pCombinedLight, class_1799 itemStack, ViewableBackpack viewable) {
        UtilityComponent utilities = (UtilityComponent)itemStack.method_57824(ITraitData.UTILITIES);
        if (utilities != null && !utilities.isBlank()) {
            class_1799 first = utilities.get(0);
            class_1799 second = utilities.get(1);
            this.renderUtilities(pose, pBufferSource, pCombinedLight, first, viewable, true);
            this.renderUtilities(pose, pBufferSource, pCombinedLight, second, viewable, false);
        }
    }

    default public void renderUtilities(class_4587 pose, class_4597 pBufferSource, int pCombinedLight, class_1799 stack, ViewableBackpack viewable, boolean rightSide) {
        if (stack.method_7960()) {
            return;
        }
        UtilityComponent.Type type = UtilityComponent.getType(stack);
        switch (type) {
            case OMINOUS: {
                String path = "ominous_banner";
                class_1087 model = this.getCustomModel(path);
                this.renderItemModel(pose, pBufferSource, pCombinedLight, viewable, rightSide, model);
                break;
            }
            case CAULDRON: {
                String path = "cauldron";
                class_1087 model = this.getCustomModel(path);
                this.renderItemModel(pose, pBufferSource, pCombinedLight, viewable, rightSide, model);
                this.blockRenderer().method_3353(class_2246.field_10382.method_9564(), pose, pBufferSource, pCombinedLight, class_4608.field_21444);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                class_1087 model = this.getCustomModel(stack, viewable);
                this.renderItemModel(pose, pBufferSource, pCombinedLight, viewable, rightSide, model);
            }
        }
    }

    private class_1087 getCustomModel(class_1799 stack, ViewableBackpack viewable) {
        class_2960 key = class_7923.field_41178.method_10221((Object)stack.method_7909());
        class_1092 modelmanager = this.itemRenderer().method_4012().method_3303();
        class_1091 modelLocation = Services.PLATFORM.getModelVariant(class_2960.method_60655((String)"beansbackpacks", (String)("utilities/" + key.method_12832())));
        class_1087 resolve = modelmanager.method_4742(modelLocation);
        class_1297 entity = viewable.entity();
        stack.method_27320(entity);
        class_638 level = (class_638)entity.method_37908();
        return resolve.method_4710().method_3495(resolve, stack, level, null, viewable.getId());
    }

    private class_1087 getCustomModel(String path) {
        class_1092 modelmanager = this.itemRenderer().method_4012().method_3303();
        class_1091 modelLocation = Services.PLATFORM.getModelVariant(class_2960.method_60655((String)"beansbackpacks", (String)("utilities/" + path)));
        return modelmanager.method_4742(modelLocation);
    }

    private void renderItemModel(class_4587 pose, class_4597 pBufferSource, int pCombinedLight, ViewableBackpack viewable, boolean rightSide, class_1087 model) {
        if (model == null) {
            return;
        }
        pose.method_22903();
        class_811 displayContext = class_811.field_4319;
        model.method_4709().method_3503(displayContext).method_23075(!rightSide, pose);
        pose.method_22905(0.5f, 0.5f, 0.5f);
        if (rightSide) {
            pose.method_46416(1.03125f, -1.1875f, -1.0f);
            pose.method_22907(class_7833.field_40715.rotationDegrees(90.0f));
        } else {
            pose.method_46416(-1.03125f, -1.1875f, 0.0f);
            pose.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        }
        float fallDistance = viewable.fallDistance();
        boolean isFallFlying = false;
        float fallPitch = isFallFlying ? 0.0f : (float)(-Math.log(fallDistance * 2.0f + 1.0f));
        double y = (double)fallPitch * 0.02;
        pose.method_22904(0.0, y, (double)(-fallPitch) * 0.004);
        pose.method_22907(class_7833.field_40714.rotationDegrees(fallPitch * 2.0f));
        class_4588 buffer = pBufferSource.getBuffer(class_4722.method_24074());
        this.blockRenderer().method_3350().method_3367(pose.method_23760(), buffer, null, model, 1.0f, 1.0f, 1.0f, pCombinedLight, class_4608.field_21444);
        pose.method_22909();
    }
}

