/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components;

import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public record FilterComponent(Iterable<class_6880<class_1792>> items, @Nullable class_6862<class_1792> tag) {
    public static final String NAME = "filter";
    public static final FilterComponent EMPTY = new FilterComponent(List.of(), null);
    public static final Codec<FilterComponent> CODEC = new Codec<FilterComponent>(){

        public <T> DataResult<Pair<FilterComponent, T>> decode(DynamicOps<T> ops, T input) {
            DataResult decodeTag = class_6862.method_40093((class_5321)class_7924.field_41197).decode(ops, input);
            if (decodeTag.isSuccess()) {
                return decodeTag.map(pair -> pair.mapFirst(FilterComponent::new));
            }
            DataResult decodeItem = class_1799.field_47312.listOf().decode(ops, input);
            if (decodeItem.isSuccess()) {
                return decodeItem.map(pair -> pair.mapFirst(FilterComponent::new));
            }
            return DataResult.error(() -> "Neither item nor tag was parsed correctly; item=" + String.valueOf(decodeItem.error().get()) + "; tag=" + String.valueOf(decodeTag.error().get()));
        }

        public <T> DataResult<T> encode(FilterComponent input, DynamicOps<T> ops, T prefix) {
            if (input.tag == null) {
                return class_1799.field_47312.listOf().encode((Object)Lists.newArrayList(input.items.iterator()), ops, prefix);
            }
            return class_6862.method_40093((class_5321)class_7924.field_41197).encode(input.tag, ops, prefix);
        }
    };
    public static final class_9139<class_9129, FilterComponent> STREAM_CODEC = class_9139.method_56437((buf, filter) -> {
        ArrayList items = Lists.newArrayList(filter.items.iterator());
        int size = items.size();
        buf.method_53002(size);
        for (class_6880 item : items) {
            class_9135.method_56383((class_5321)class_7924.field_41197).encode(buf, (Object)item);
        }
    }, buf -> {
        int size = buf.readInt();
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            class_6880 item = (class_6880)class_9135.method_56383((class_5321)class_7924.field_41197).decode(buf);
            items.add(item);
        }
        return new FilterComponent(items);
    });

    public FilterComponent(class_6862<class_1792> tag) {
        this(class_7923.field_41178.method_40286(tag), tag);
    }

    public FilterComponent(List<class_6880<class_1792>> items) {
        this(items, null);
    }

    public boolean isEmpty() {
        return this == EMPTY || !this.items.iterator().hasNext();
    }

    public boolean test(class_1799 stack) {
        for (class_6880<class_1792> item : this.items) {
            if (!stack.method_41406(item)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static FilterComponent get(ComponentHolder stack) {
        FilterComponent component = stack.get(Traits.FILTER);
        if (component != null) {
            return component;
        }
        ReferenceTrait reference = stack.get(Traits.REFERENCE);
        if (reference == null) {
            return null;
        }
        return reference.getFilter().orElse(null);
    }
}

