/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.components.reference.ReferenceRegistry;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderEntry;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class EnderStorage {
    public static final class_2960 LEGACY_ENDER_LOCATION = class_2960.method_60655((String)"beansbackpacks", (String)"legacy_ender");
    private final HashMap<UUID, PlayerEntry> storage = new HashMap();
    public static final class_9139<class_9129, Reference2ObjectOpenHashMap<class_9331<?>, Object>> ENTRY_MAP_STREAM_CODEC = class_9139.method_56437((buf, map) -> {
        int size = map.size();
        buf.method_53002(size);
        map.forEach((key, value) -> EnderStorage.encodeMap(buf, key, value));
    }, buf -> {
        Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            class_9331 key = (class_9331)class_9331.field_49601.decode(buf);
            Object decode = key.method_57878().decode(buf);
            map.put((Object)key, decode);
        }
        return map;
    });

    public static EnderStorage get(class_1937 level) {
        MinecraftServer server = level.method_8503();
        if (server == null) {
            return CommonClient.getEnderStorage();
        }
        return ServerSave.getSave((MinecraftServer)server, (boolean)true).enderStorage;
    }

    public PlayerEntry get(UUID uuid) {
        return this.storage.computeIfAbsent(uuid, key -> new PlayerEntry());
    }

    public GenericTraits getTrait(UUID uuid, class_2960 location) {
        return this.get((UUID)uuid).get((class_2960)location).trait;
    }

    public Reference2ObjectOpenHashMap<class_9331<?>, Object> get(UUID uuid, class_2960 location) {
        return this.get((UUID)uuid).get((class_2960)location).data;
    }

    public Reference2ObjectOpenHashMap<class_9331<?>, Object> get(class_1657 player, class_2960 location) {
        PlayerEntry entry = this.get(player.method_5667());
        entry.displayName = player.method_5477();
        return entry.get((class_2960)location).data;
    }

    public <T> T remove(UUID uuid, class_2960 location, class_9331<? extends T> type) {
        return (T)this.get((UUID)uuid).get((class_2960)location).data.remove(type);
    }

    public <T> void set(UUID uuid, class_2960 location, class_9331<? super T> type, T trait) {
        TraitEntry entry = this.get((UUID)uuid).traits.computeIfAbsent(location, PlayerEntry::newMapFromLocation);
        if (entry != null) {
            entry.data.put(type, trait);
        }
    }

    public <T extends GenericTraits> void set(UUID uuid, class_2960 location, TraitComponentKind<T> kind, T trait, Reference2ObjectOpenHashMap<class_9331<?>, Object> data, class_2561 name) {
        PlayerEntry entry = this.get(uuid);
        TraitEntry<T> newEntry = new TraitEntry<T>(kind, trait, data);
        entry.traits.put(location, newEntry);
        entry.displayName = name;
    }

    public void set(UUID uuid, class_2960 location, Reference2ObjectOpenHashMap<class_9331<?>, Object> traits, class_2561 name) {
        PlayerEntry entry = this.get(uuid);
        TraitEntry traitEntry = entry.traits.get(location);
        if (traitEntry != null) {
            TraitEntry newEntry = new TraitEntry(traitEntry, traits);
            entry.traits.put(location, newEntry);
            entry.displayName = name;
        }
    }

    public void set(UUID uuid, class_2960 location, Reference2ObjectOpenHashMap<class_9331<?>, Object> traits) {
        PlayerEntry entry = this.get(uuid);
        TraitEntry traitEntry = entry.traits.get(location);
        if (traitEntry != null) {
            TraitEntry newEntry = new TraitEntry(traitEntry, traits);
            entry.traits.put(location, newEntry);
        }
    }

    public void setLegacyEnder(UUID uuid, List<class_1799> itemStacks) {
        PlayerEntry playerEntry = this.get(uuid);
        playerEntry.traits.computeIfAbsent(LEGACY_ENDER_LOCATION, location -> {
            ReferenceRegistry reference = ReferenceRegistry.get(location);
            GenericTraits traits = reference.traits();
            Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
            map.put(ITraitData.ITEM_STACKS, (Object)itemStacks);
            return new TraitEntry<GenericTraits>(traits.kind(), traits, map);
        });
    }

    public void save(class_2487 tag) {
        this.storage.forEach((uuid, entry) -> {
            DataResult encodedStart = PlayerEntry.ENTRY_CODEC.encodeStart((DynamicOps)class_2509.field_11560, entry);
            encodedStart.ifSuccess(entryTag -> tag.method_10566(uuid.toString(), entryTag));
        });
    }

    public void load(class_2487 tag) {
        for (String key : tag.method_10541()) {
            UUID uuid = UUID.fromString(key);
            class_2487 entryTag = tag.method_10562(key);
            PlayerEntry.ENTRY_CODEC.decode((DynamicOps)class_2509.field_11560, (Object)entryTag).ifSuccess(pair -> this.storage.put(uuid, (PlayerEntry)pair.getFirst()));
        }
    }

    public HashSet<class_3222> getListeners(UUID uuid) {
        return this.get((UUID)uuid).listeners;
    }

    public class_2561 getDisplayName(UUID uuid) {
        return this.get((UUID)uuid).displayName;
    }

    public static void sendEntry(class_3222 serverPlayer, UUID uuid, class_2960 location) {
        PlayerEntry entry = EnderStorage.get(serverPlayer.method_37908()).get(uuid);
        TraitEntry traitEntry = entry.get(location);
        SendEnderEntry.send(serverPlayer, uuid, location, traitEntry.kind, traitEntry.trait, traitEntry.data, entry.displayName);
    }

    private static <T> void encodeMap(class_9129 buf, class_9331<T> key, Object value) {
        class_9331.field_49601.encode((Object)buf, key);
        key.method_57878().encode((Object)buf, value);
    }

    private static final class PlayerEntry {
        private final HashMap<class_2960, TraitEntry> traits = new HashMap();
        private final HashSet<class_3222> listeners = new HashSet();
        private class_2561 displayName = class_2561.method_43473();
        private static final MapCodec<GenericTraits> DISPATCHED_TRAIT_CODEC = TraitComponentKind.CODEC.dispatchMap("kind", GenericTraits::kind, kind -> kind.method_57875().fieldOf("trait"));
        private static final Codec<Pair<class_2960, TraitEntry>> START_CODEC = RecordCodecBuilder.create(in -> in.group((App)class_2960.field_25139.fieldOf("location").forGetter(Pair::first), (App)DISPATCHED_TRAIT_CODEC.forGetter(pair -> ((TraitEntry)pair.second()).trait), (App)class_9331.field_50237.fieldOf("data").forGetter(pair -> ((TraitEntry)pair.second()).data)).apply((Applicative)in, (location, traits, data) -> {
            Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap(data);
            TraitEntry<GenericTraits> traitEntry = new TraitEntry<GenericTraits>((TraitComponentKind<GenericTraits>)traits.kind(), (GenericTraits)traits, (Reference2ObjectOpenHashMap<class_9331<?>, Object>)map);
            return Pair.of((Object)location, traitEntry);
        }));
        private static final Codec<PlayerEntry> ENTRY_CODEC = RecordCodecBuilder.create(in -> in.group((App)START_CODEC.listOf().fieldOf("entries").forGetter(entry -> entry.traits.entrySet().stream().map(e -> Pair.of((Object)((class_2960)e.getKey()), (Object)((TraitEntry)e.getValue()))).toList()), (App)class_8824.field_46597.fieldOf("name").forGetter(entry -> entry.displayName)).apply((Applicative)in, (trait, name) -> {
            PlayerEntry entry = new PlayerEntry();
            entry.displayName = name;
            trait.forEach(reference -> entry.traits.put((class_2960)reference.first(), (TraitEntry)reference.second()));
            return entry;
        }));

        private PlayerEntry() {
        }

        private TraitEntry get(class_2960 location) {
            return this.traits.computeIfAbsent(location, PlayerEntry::newMapFromLocation);
        }

        @Nullable
        private static TraitEntry newMapFromLocation(class_2960 key) {
            ReferenceRegistry reference = ReferenceRegistry.get(key);
            if (reference == null) {
                return null;
            }
            GenericTraits fields = reference.traits();
            Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
            return new TraitEntry<GenericTraits>(fields.kind(), fields, map);
        }
    }

    private record TraitEntry<T extends GenericTraits>(TraitComponentKind<T> kind, T trait, Reference2ObjectOpenHashMap<class_9331<?>, Object> data) {
        public TraitEntry(TraitEntry<T> entry, Reference2ObjectOpenHashMap<class_9331<?>, Object> traits) {
            this(entry.kind, entry.trait, traits);
        }
    }
}

