/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config.screen;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.data.config.ClientConfig;
import com.beansgalaxy.backpacks.data.config.ClientConfigRows;
import com.beansgalaxy.backpacks.data.config.CommonConfig;
import com.beansgalaxy.backpacks.data.config.CommonConfigRows;
import com.beansgalaxy.backpacks.data.config.TraitConfig;
import com.beansgalaxy.backpacks.data.config.TraitConfigRows;
import com.beansgalaxy.backpacks.data.config.screen.ConfigRows;
import com.beansgalaxy.backpacks.data.config.screen.IConfig;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7077;

public class ConfigScreen
extends class_437 {
    private final Map<IConfig, Function<ConfigScreen, ConfigRows>> pageConstructor;
    private final class_437 lastScreen;
    private final IConfig[] pages;
    private ConfigRows[] rows;
    private ConfigRows currentPage;

    public ConfigScreen(class_437 lastScreen, Map<IConfig, Function<ConfigScreen, ConfigRows>> pageConstructor) {
        super((class_2561)class_2561.method_43473());
        this.pageConstructor = pageConstructor;
        this.lastScreen = lastScreen;
        for (IConfig page : this.pages = pageConstructor.keySet().toArray(new IConfig[0])) {
            page.read();
        }
    }

    public static void buildPageMap(class_310 minecraft, ImmutableMap.Builder<IConfig, Function<ConfigScreen, ConfigRows>> map) {
        CommonConfig common = new CommonConfig();
        map.put((Object)common, configScreen -> new CommonConfigRows((ConfigScreen)((Object)configScreen), minecraft, common));
        ClientConfig client = CommonClass.CLIENT_CONFIG;
        map.put((Object)client, configScreen -> new ClientConfigRows((ConfigScreen)((Object)configScreen), minecraft, client));
        TraitConfig traits = new TraitConfig();
        map.put((Object)traits, configScreen -> new TraitConfigRows((ConfigScreen)((Object)configScreen), minecraft, traits));
    }

    public List<? extends class_364> method_25396() {
        List<class_364> children = super.method_25396().stream().filter(in -> in == this.currentPage || !(in instanceof ConfigRows)).toList();
        return children;
    }

    protected void method_25426() {
        super.method_25426();
        ArrayList<ConfigRows> rows = new ArrayList<ConfigRows>();
        ArrayList<PageTab> tabs = new ArrayList<PageTab>();
        int totalWidth = -20;
        for (IConfig page : this.pages) {
            ConfigRows row = this.pageConstructor.get(page).apply(this);
            rows.add(row);
            String path = row.config.getPath();
            class_5250 title = class_2561.method_48321((String)("screen.beansbackpacks.config.title-" + path), (String)path);
            int titleWidth = this.field_22787.field_1772.method_27525((class_5348)title);
            totalWidth += 20 + titleWidth;
            tabs.add(new PageTab(row, (class_2561)title, titleWidth));
        }
        this.rows = (ConfigRows[])rows.toArray(ConfigRows[]::new);
        ServerSave.CONFIG.read(false);
        this.currentPage = this.rows[0];
        this.addWidgets();
        int x = (this.field_22789 - totalWidth) / 2;
        for (final PageTab tab : tabs) {
            this.method_25429((class_364)tab.row);
            this.method_37063((class_364)new class_7077(x, 20, tab.width, 20, tab.title, in -> {
                this.currentPage = tab.row;
            }, this.field_22787.field_1772){

                public boolean method_25370() {
                    return ConfigScreen.this.currentPage == tab.row;
                }
            });
            x += tab.width + 20;
        }
    }

    private void addWidgets() {
        int center = this.field_22789 / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.beansbackpacks.config.main.reset_all"), $$0 -> this.currentPage.resetToDefault()).method_46434(center - 165, this.field_22790 - 26, 70, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.beansbackpacks.config.main.undo_all"), $$0 -> {
            for (IConfig page : this.pages) {
                page.read(false);
            }
        }).method_46434(center - 80, this.field_22790 - 26, 70, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.beansbackpacks.config.main.save_and_exit"), $$0 -> {
            for (ConfigRows row : this.rows) {
                row.onSave();
                row.config.write();
            }
            this.field_22787.method_1507(this.lastScreen);
        }).method_46434(center + 5, this.field_22790 - 26, 160, 20).method_46431());
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
    }

    public void method_25394(class_332 gui, int x, int y, float delta) {
        super.method_25394(gui, x, y, delta);
        class_5250 title = class_2561.method_43470((String)"Beans' Backpacks").method_27692(class_124.field_1067);
        gui.method_27534(this.field_22793, (class_2561)title, this.field_22787.method_22683().method_4486() / 2, 6, -3351041);
        if (this.currentPage != null) {
            this.currentPage.method_25394(gui, x, y, delta);
        }
    }

    private record PageTab(ConfigRows row, class_2561 title, int width) {
    }
}

