/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.access.ViewableAccessor;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1531.class})
public abstract class ArmorStandMixin
extends class_1309
implements ViewableAccessor {
    @Unique
    public final class_1531 instance = (class_1531)this;
    private class_1799 backItem = class_1799.field_8037;
    @Unique
    private static final class_2940<Boolean> IS_OPEN = class_2945.method_12791(class_1531.class, (class_2941)class_2943.field_13323);
    private final ViewableBackpack viewable = new ViewableBackpack(){

        @Override
        public void setOpen(boolean isOpen) {
            ArmorStandMixin.this.instance.method_5841().method_12778(IS_OPEN, (Object)isOpen);
        }

        @Override
        public boolean isOpen() {
            return (Boolean)ArmorStandMixin.this.instance.method_5841().method_12789(IS_OPEN);
        }

        @Override
        public void playSound(ModSound.Type type) {
            Traits.get(this.toStack()).ifPresent(traits -> traits.sound().at((class_1297)ArmorStandMixin.this.instance, type));
        }

        @Override
        @NotNull
        public class_1297 entity() {
            return ArmorStandMixin.this.instance;
        }

        @Override
        protected ComponentHolder holder() {
            return ComponentHolder.of(this.toStack());
        }

        @Override
        public class_1799 toStack() {
            return ArmorStandMixin.this.instance.method_6118(class_1304.field_48824);
        }

        @Override
        public void onOpen(class_1657 player) {
            super.onOpen(player);
        }

        @Override
        public boolean shouldClose() {
            if (ArmorStandMixin.this.instance.method_31481()) {
                return true;
            }
            class_1799 stack = ArmorStandMixin.this.viewable.toStack();
            if (stack.method_7960()) {
                return true;
            }
            return Traits.get(stack).isEmpty();
        }

        @Override
        public float fallDistance() {
            return ArmorStandMixin.this.field_6017;
        }
    };

    protected ArmorStandMixin(class_1299<? extends class_1309> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    protected abstract class_1304 method_6916(class_243 var1);

    @Shadow
    protected abstract boolean method_6904(class_1657 var1, class_1304 var2, class_1799 var3, class_1268 var4);

    @Shadow
    public abstract void method_5773();

    @Shadow
    public abstract boolean method_6912();

    @Inject(method={"interactAt"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="HEAD")})
    private void backpackInteractAt(class_1657 pPlayer, class_243 pVec, class_1268 pHand, CallbackInfoReturnable<class_1269> cir) {
        if (this.method_6912()) {
            return;
        }
        if (!pPlayer.method_7325() && BackData.get(pPlayer).isActionKeyDown()) {
            class_1269 result = CommonClass.swapBackWith(this.instance, pPlayer);
            if (result.method_23665()) {
                cir.setReturnValue((Object)result);
            }
        } else if (!this.method_6118(class_1304.field_48824).method_7960()) {
            this.interactWithBackpack((class_1309)this.instance, pPlayer, pVec, cir);
        }
    }

    @Inject(method={"interactAt"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/ArmorStand;getEquipmentSlotForItem(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/EquipmentSlot;")})
    private void backpackInteractAt(class_1657 pPlayer, class_243 pVec, class_1268 pHand, CallbackInfoReturnable<class_1269> cir, class_1799 itemstack) {
        BackpackTraits traits = BackpackTraits.get(itemstack);
        if (traits == null) {
            return;
        }
        class_1304 equipmentSlot = null;
        for (class_1304 slot : traits.slots().getValues()) {
            if (class_1304.field_48824.equals((Object)slot)) continue;
            equipmentSlot = slot;
            class_1799 armor = this.method_6118(slot);
            if (!armor.method_7960()) continue;
            break;
        }
        if (equipmentSlot == null) {
            class_1304 clickedSlot = this.method_6916(pVec);
            if (traits.slots().test(clickedSlot) && this.method_6904(pPlayer, clickedSlot, itemstack, pHand)) {
                cir.setReturnValue((Object)class_1269.field_5812);
            }
            return;
        }
        if (this.method_6904(pPlayer, equipmentSlot, itemstack, pHand)) {
            cir.setReturnValue((Object)class_1269.field_5812);
        }
    }

    @Unique
    private void interactWithBackpack(class_1309 owner, class_1657 viewer, class_243 pVec, CallbackInfoReturnable<class_1269> cir) {
        double maxRadius;
        double radius;
        boolean looking;
        boolean yawMatches;
        class_1799 backpack = owner.method_6118(class_1304.field_48824);
        if (backpack.method_7960()) {
            return;
        }
        double yaw = Math.abs(viewer.field_6241 - owner.field_6283) % 360.0f - 180.0f;
        boolean bl = yawMatches = Math.abs(yaw) > 90.0;
        if (!yawMatches) {
            return;
        }
        Optional<GenericTraits> optional = Traits.get(backpack);
        if (optional.isEmpty()) {
            return;
        }
        double angleRadians = Math.toRadians(owner.field_6283);
        double offset = -0.3;
        double x = owner.method_23317();
        double z = owner.method_23321();
        double offsetX = Math.cos(angleRadians) * offset;
        double offsetZ = Math.sin(angleRadians) * offset;
        double newX = x - offsetZ;
        double newY = owner.method_23320() - 0.45;
        double newZ = z + offsetX;
        class_243 vec3d = viewer.method_5828(1.0f).method_1029();
        class_243 vec3d2 = new class_243(newX - viewer.method_23317(), newY - viewer.method_23320(), newZ - viewer.method_23321());
        double d = -vec3d2.method_1033() + 5.65;
        double e = vec3d.method_1026(vec3d2.method_1029());
        boolean bl2 = looking = e > 1.0 - (radius = d * d * d * d / 625.0) * (maxRadius = 0.05) && viewer.method_6057((class_1297)owner);
        if (!looking) {
            return;
        }
        GenericTraits traits = optional.get();
        traits.onPlayerInteract(owner, viewer, backpack, cir);
    }

    @Inject(method={"getItemBySlot"}, cancellable=true, at={@At(value="HEAD")})
    private void backpackGetItemBySlot(class_1304 pSlot, CallbackInfoReturnable<class_1799> cir) {
        if (class_1304.field_48824.equals((Object)pSlot)) {
            cir.setReturnValue((Object)this.backItem);
        }
    }

    @Inject(method={"setItemSlot"}, cancellable=true, at={@At(value="HEAD")})
    private void backpackGetItemBySlot(class_1304 pSlot, class_1799 pStack, CallbackInfo ci) {
        if (class_1304.field_48824.equals((Object)pSlot)) {
            this.method_37410(pStack);
            this.method_6116(pSlot, this.backItem, pStack);
            this.backItem = pStack;
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void backpackAddSaveData(class_2487 pCompound, CallbackInfo ci) {
        class_2520 backTag = this.backItem.method_57375((class_7225.class_7874)this.method_56673());
        pCompound.method_10566("BackItem", backTag);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void backpackReadSaveData(class_2487 pCompound, CallbackInfo ci) {
        if (pCompound.method_10573("BackItem", 10)) {
            this.backItem = class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)pCompound.method_10562("BackItem"));
        }
    }

    @Inject(method={"brokenByAnything"}, at={@At(value="TAIL")})
    private void backpackBrokenByAnything(class_3218 pLevel, class_1282 pDamageSource, CallbackInfo ci) {
        class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515().method_10084(), (class_1799)this.backItem);
        this.backItem = class_1799.field_8037;
    }

    @Override
    public ViewableBackpack beans_Backpacks_3$getViewable() {
        return this.viewable;
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void backpackSyncedData(class_2945.class_9222 pBuilder, CallbackInfo ci) {
        pBuilder.method_56912(IS_OPEN, (Object)false);
    }
}

