/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.common;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.access.PlayerAccessor;
import com.beansgalaxy.backpacks.access.ViewableAccessor;
import com.beansgalaxy.backpacks.components.SlotSelection;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.traits.quiver.QuiverTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.ModSound;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309
implements ViewableAccessor,
PlayerAccessor {
    @Shadow
    @Final
    private class_1661 field_7514;
    @Unique
    public final class_1657 instance = (class_1657)this;
    @Unique
    private static final class_2940<Boolean> IS_OPEN = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13323);
    private final ViewableBackpack viewable = new ViewableBackpack(){
        class_243 openedPos = null;
        float openedYaw = 0.0f;

        @Override
        public void setOpen(boolean isOpen) {
            PlayerMixin.this.instance.method_5841().method_12778(IS_OPEN, (Object)isOpen);
        }

        @Override
        public boolean isOpen() {
            return (Boolean)PlayerMixin.this.instance.method_5841().method_12789(IS_OPEN);
        }

        @Override
        public void playSound(ModSound.Type type) {
            Traits.get(this.toStack()).ifPresent(traits -> traits.sound().at((class_1297)PlayerMixin.this.instance, type));
        }

        @Override
        @NotNull
        public class_1297 entity() {
            return PlayerMixin.this.instance;
        }

        @Override
        protected ComponentHolder holder() {
            return ComponentHolder.of(this.toStack());
        }

        @Override
        public class_1799 toStack() {
            return PlayerMixin.this.instance.method_6118(class_1304.field_48824);
        }

        @Override
        public void onOpen(class_1657 player) {
            this.openedPos = PlayerMixin.this.instance.method_19538();
            this.openedYaw = PlayerMixin.this.instance.field_6241;
            super.onOpen(player);
        }

        @Override
        public boolean shouldClose() {
            if (PlayerMixin.this.instance.method_31481()) {
                return true;
            }
            class_1799 stack = PlayerMixin.this.viewable.toStack();
            if (stack.method_7960()) {
                return true;
            }
            if (Traits.get(stack).isEmpty()) {
                return true;
            }
            if (this.openedPos == null) {
                return false;
            }
            if (PlayerMixin.this.instance.method_5707(this.openedPos) > 0.5) {
                return true;
            }
            double yaw = Math.abs(PlayerMixin.this.instance.field_6241 - this.openedYaw) % 360.0f - 180.0f;
            boolean yawMatches = Math.abs(yaw) > 90.0;
            return !yawMatches;
        }

        @Override
        public float fallDistance() {
            return PlayerMixin.this.field_6017;
        }
    };
    @Deprecated(since="0.9-beta")
    @Unique
    @Nullable
    private class_2487 legacyShorthandItems = null;
    @Deprecated(since="0.9-beta")
    @Unique
    private boolean legacyShouldSendShorthandWarning = false;
    @Unique
    private boolean utilitiesScope = false;

    protected PlayerMixin(class_1299<? extends class_1309> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract void method_5673(class_1304 var1, class_1799 var2);

    @Shadow
    public abstract class_1661 method_31548();

    @Shadow
    public abstract void method_7353(class_2561 var1, boolean var2);

    @Shadow
    public abstract void method_5650(class_1297.class_5529 var1);

    @Shadow
    public abstract void method_6091(class_243 var1);

    @Override
    public ViewableBackpack beans_Backpacks_3$getViewable() {
        return this.viewable;
    }

    @Inject(method={"getItemBySlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBackSlotItem(class_1304 equipmentSlot, CallbackInfoReturnable<class_1799> cir) {
        if (equipmentSlot == class_1304.field_48824) {
            BackData access = (BackData)this.instance.method_31548();
            cir.setReturnValue((Object)((class_1799)access.beans_Backpacks_3$getBody().getFirst()));
        }
    }

    @Inject(method={"setItemSlot"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/player/Player;verifyEquippedItem(Lnet/minecraft/world/item/ItemStack;)V")})
    private void setBackSlotItem(class_1304 pSlot, class_1799 pStack, CallbackInfo ci) {
        if (class_1304.field_48824.equals((Object)pSlot)) {
            BackData access = (BackData)this.instance.method_31548();
            this.instance.method_6116(class_1304.field_48824, (class_1799)access.beans_Backpacks_3$getBody().set(0, (Object)pStack), pStack);
            ci.cancel();
        }
    }

    @Inject(method={"getProjectile"}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/item/ProjectileWeaponItem;getHeldProjectile(Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Lnet/minecraft/world/item/ItemStack;")})
    private void getBackpackProjectile(class_1799 pShootable, CallbackInfoReturnable<class_1799> cir, Predicate<class_1799> predicate) {
        QuiverTraits.runIfPresent(this.instance, (Function4<QuiverTraits, Integer, class_1799, ComponentHolder, Boolean>)((Function4)(proTrait, slot, quiver, holder) -> {
            List<class_1799> stacks = holder.get(ITraitData.ITEM_STACKS);
            if (stacks == null || stacks.isEmpty()) {
                return false;
            }
            int selectedSlot = proTrait.getSelectedSlot((ComponentHolder)holder, this.instance);
            class_1799 stack = stacks.get(selectedSlot);
            if (predicate.test(stack)) {
                cir.setReturnValue((Object)stack);
                return true;
            }
            return false;
        }));
    }

    @Inject(method={"interactOn"}, cancellable=true, at={@At(value="HEAD")})
    private void backpackInteractOn(class_1297 pEntityToInteractOn, class_1268 pHand, CallbackInfoReturnable<class_1269> cir) {
        if (pEntityToInteractOn instanceof class_1657) {
            class_1657 player = (class_1657)pEntityToInteractOn;
            CommonClass.interactEquippedBackpack((class_1309)player, this.instance, cir);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void backpackAddSaveData(class_2487 pCompound, CallbackInfo ci) {
        class_5455 access = this.instance.method_56673();
        class_1799 backStack = this.method_6118(class_1304.field_48824);
        class_2487 backpacks = new class_2487();
        class_6903 serializationContext = access.method_57093((DynamicOps)class_2509.field_11560);
        DataResult dataResult = class_1799.field_49266.encodeStart((DynamicOps)serializationContext, (Object)backStack);
        dataResult.ifSuccess(back -> backpacks.method_10566("back", back));
        class_1661 inventory = this.method_31548();
        class_2487 selectedSlots = new class_2487();
        PlayerMixin.saveSelectedSlots("items", (List<class_1799>)inventory.field_7547, this.instance, selectedSlots);
        PlayerMixin.saveSelectedSlots("armor", (List<class_1799>)inventory.field_7548, this.instance, selectedSlots);
        class_1799 offhand = (class_1799)inventory.field_7544.getFirst();
        PlayerMixin.saveSelectedSlots("offhand", offhand, this.instance, selectedSlots);
        class_1799 back2 = (class_1799)BackData.get(this.instance).beans_Backpacks_3$getBody().getFirst();
        PlayerMixin.saveSelectedSlots("back", back2, this.instance, selectedSlots);
        backpacks.method_10566("slot_selection", (class_2520)selectedSlots);
        this.legacySaveShorthandBackup(backpacks);
        pCompound.method_10566("beansbackpacks", (class_2520)backpacks);
    }

    @Unique
    private static void saveSelectedSlots(String name, List<class_1799> items, class_1657 instance, class_2487 tag) {
        int size = items.size();
        class_2487 slots = new class_2487();
        for (int i = 0; i < size; ++i) {
            class_1799 item = items.get(i);
            PlayerMixin.saveSelectedSlots(String.valueOf(i), item, instance, slots);
        }
        tag.method_10566(name, (class_2520)slots);
    }

    @Unique
    private static void saveSelectedSlots(String name, class_1799 item, class_1657 instance, class_2487 tag) {
        SlotSelection slotSelection = (SlotSelection)item.method_57824(ITraitData.SLOT_SELECTION);
        if (slotSelection == null) {
            return;
        }
        int selectedSlot = slotSelection.get(instance);
        if (selectedSlot == 0) {
            return;
        }
        tag.method_10569(name, selectedSlot);
    }

    @Unique
    private static int getMaxSelection(class_1799 item) {
        List stacks = (List)item.method_57824(ITraitData.ITEM_STACKS);
        if (stacks == null || stacks.isEmpty()) {
            return 0;
        }
        return stacks.size() - 1;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void backpackReadSaveData(class_2487 pCompound, CallbackInfo ci) {
        DataResult back;
        class_2487 backpacks = pCompound.method_10562("beansbackpacks");
        class_5455 access = this.instance.method_56673();
        if (backpacks.method_10545("back")) {
            class_2520 backSlot = backpacks.method_10580("back");
            class_6903 serializationContext = access.method_57093((DynamicOps)class_2509.field_11560);
            back = class_1799.field_49266.parse((DynamicOps)serializationContext, (Object)backSlot);
            back.ifSuccess(stack -> this.method_5673(class_1304.field_48824, (class_1799)stack));
        }
        class_2487 slotSelection = backpacks.method_10562("slot_selection");
        PlayerMixin.readSlotSelection("items", (List<class_1799>)this.field_7514.field_7547, this.instance, slotSelection);
        PlayerMixin.readSlotSelection("armor", (List<class_1799>)this.field_7514.field_7548, this.instance, slotSelection);
        class_1799 offhand = (class_1799)this.field_7514.field_7544.getFirst();
        PlayerMixin.readSlotSelection("offhand", offhand, this.instance, slotSelection);
        back = (class_1799)BackData.get(this.instance).beans_Backpacks_3$getBody().getFirst();
        PlayerMixin.readSlotSelection("back", (class_1799)back, this.instance, slotSelection);
        this.legacyReadShorthandBackup(backpacks);
    }

    @Deprecated(since="0.9-beta")
    @Unique
    private void legacySaveShorthandBackup(class_2487 backpacks) {
        if (this.legacyShorthandItems != null) {
            backpacks.method_10566("shorthand", (class_2520)this.legacyShorthandItems);
        }
    }

    @Deprecated(since="0.9-beta")
    @Unique
    private void legacyReadShorthandBackup(class_2487 backpacks) {
        if (!Services.PLATFORM.isModLoaded("beanstoolbelt") && backpacks.method_10545("shorthand")) {
            class_2487 shorthand;
            this.legacyShorthandItems = shorthand = backpacks.method_10562("shorthand");
            this.legacyShouldSendShorthandWarning = true;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    @Deprecated(since="0.9-beta")
    private void legacySendWarningMessage(CallbackInfo ci) {
        if (this.legacyShouldSendShorthandWarning && this.method_5682() != null && this.method_5682().method_3787() != null) {
            class_5250 literal = class_2561.method_43470((String)"THE SHORTHAND IS NO LONGER INCLUDED IN THIS VERSION OF BEANS' BACKPACKS;");
            class_5250 literal2 = class_2561.method_43470((String)"QUIT THE GAME AND INSTALL \"BEANS' TOOLBELT\" IMMEDIATELY TO KEEP YOUR TOOLS!!");
            this.method_7353((class_2561)literal, false);
            this.method_7353((class_2561)literal2, false);
            this.legacyShouldSendShorthandWarning = false;
        }
    }

    @Unique
    private static void readSlotSelection(String name, List<class_1799> items, class_1657 instance, class_2487 slotSelection) {
        class_2487 tag = slotSelection.method_10562(name);
        for (String key : tag.method_10541()) {
            int slot = Integer.parseInt(key);
            class_1799 stack = items.get(slot);
            PlayerMixin.readSlotSelection(key, stack, instance, tag);
        }
    }

    @Unique
    private static void readSlotSelection(String name, class_1799 item, class_1657 instance, class_2487 slotSelection) {
        int selection = slotSelection.method_10550(name);
        if (selection == 0) {
            return;
        }
        SlotSelection slotSelection1 = (SlotSelection)item.method_57825(ITraitData.SLOT_SELECTION, (Object)new SlotSelection());
        int max = PlayerMixin.getMaxSelection(item);
        slotSelection1.set(instance, Math.min(selection, max));
        item.method_57379(ITraitData.SLOT_SELECTION, (Object)slotSelection1);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void backpackSyncedData(class_2945.class_9222 pBuilder, CallbackInfo ci) {
        pBuilder.method_56912(IS_OPEN, (Object)false);
    }

    @Inject(method={"dropEquipment"}, at={@At(value="HEAD")})
    private void backpackDropEquipment(CallbackInfo ci) {
        if (!ServerSave.CONFIG.keepBackpack(this.method_37908())) {
            BackpackEntity.drop(this.instance);
        }
    }

    @Override
    public boolean isUtilityScoped() {
        return this.utilitiesScope;
    }

    @Override
    public void setUtilityScoped(boolean isScoped) {
        this.utilitiesScope = isScoped;
    }

    @Inject(method={"isScoping"}, cancellable=true, at={@At(value="TAIL")})
    private void backpacks_isScoping(CallbackInfoReturnable<Boolean> cir) {
        if (this.utilitiesScope) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public void setItemUsed(class_1799 itemstack) {
        if (!itemstack.method_7960() && !this.method_6115()) {
            this.field_6277 = itemstack;
            this.field_6222 = itemstack.method_7935((class_1309)this);
            if (!this.method_37908().field_9236) {
                this.method_6085(1, true);
                this.method_6085(2, false);
                this.method_32876((class_6880)class_5712.field_28145);
            }
        }
    }
}

