/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.screen;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.network.serverbound.TinyMenuInteract;
import com.beansgalaxy.backpacks.screen.TinyClickType;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1041;
import net.minecraft.class_1144;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_485;
import net.minecraft.class_490;
import net.minecraft.class_5348;
import net.minecraft.class_5630;
import net.minecraft.class_6382;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BackpackScreen
extends class_485<class_1723> {
    protected final List<TraitSlot> slots = new ArrayList<TraitSlot>();
    protected int traitX = 0;
    protected int traitY = 0;
    protected int traitW = 0;
    protected int traitH = 0;
    protected final ViewableBackpack backpack;

    public BackpackScreen(class_1723 pMenu, class_1661 pPlayerInventory, ViewableBackpack backpack) {
        super((class_1703)pMenu, pPlayerInventory, (class_2561)class_2561.method_43471((String)"container.crafting"));
        this.backpack = backpack;
        this.field_25267 = 97;
    }

    protected void method_25426() {
        super.method_25426();
        class_1041 window = this.field_22787.method_22683();
        int scaledHeight = window.method_4502();
        int scaledWidth = window.method_4486();
        this.field_2776 = scaledWidth / 2 - 12;
        this.field_2800 = scaledHeight / 2 - 83;
    }

    public void method_25419() {
        this.field_22787.method_1507(null);
        TinyMenuInteract.send(this.backpack.getId(), false);
    }

    protected abstract void tinyMenuClick(int var1, TinyClickType var2, class_5630 var3, class_746 var4);

    protected abstract void tinyHotbarClick(TinyClickType var1, class_1723 var2, class_746 var3, int var4);

    protected static TinyClickType getClickType(class_310 minecraft, int button, class_1657 player) {
        boolean eitherShiftDown;
        BackData backData = BackData.get(player);
        if (backData.isMenuKeyDown() && backData.getTinySlot() == -1) {
            return TinyClickType.ACTION;
        }
        boolean bl = eitherShiftDown = class_3675.method_15987((long)minecraft.method_22683().method_4490(), (int)340) || class_3675.method_15987((long)minecraft.method_22683().method_4490(), (int)344);
        if (eitherShiftDown) {
            return TinyClickType.SHIFT;
        }
        if (button == 1) {
            return TinyClickType.RIGHT;
        }
        return TinyClickType.LEFT;
    }

    protected void method_2383(@NotNull class_1735 pSlot, int pSlotId, int pMouseButton, @NotNull class_1713 pType) {
        class_746 player = this.field_22787.field_1724;
        if (pSlot == null) {
            this.field_22787.field_1761.method_2906(((class_1723)this.field_2797).field_7763, pSlotId, pMouseButton, pType, (class_1657)player);
            return;
        }
        switch (pType) {
            case field_7794: {
                this.tinyHotbarClick(TinyClickType.SHIFT, (class_1723)this.field_2797, player, pSlot.field_7874);
                break;
            }
            default: {
                this.field_22787.field_1761.method_2906(((class_1723)this.field_2797).field_7763, pSlot.field_7874, pMouseButton, pType, (class_1657)player);
            }
        }
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return Stream.concat(super.method_25396().stream(), this.slots.stream()).toList();
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        TraitSlot slot = this.getHoveredSlot();
        if (slot != null) {
            class_315 options = this.field_22787.field_1690;
            if (options.field_1869.method_1417(pKeyCode, pScanCode)) {
                slot.dropItem();
                return true;
            }
            class_304[] hotbarSlots = options.field_1852;
            for (int i = 0; i < hotbarSlots.length; ++i) {
                class_304 hotbarSlot = hotbarSlots[i];
                if (!hotbarSlot.method_1417(pKeyCode, pScanCode)) continue;
                slot.hotbarClick(i);
                return true;
            }
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    @Nullable
    private TraitSlot getHoveredSlot() {
        class_312 mouseHandler = this.field_22787.field_1729;
        double x = mouseHandler.method_1603() * (double)this.field_22787.method_22683().method_4486() / (double)this.field_22787.method_22683().method_4480();
        double y = mouseHandler.method_1604() * (double)this.field_22787.method_22683().method_4502() / (double)this.field_22787.method_22683().method_4507();
        for (TraitSlot slot : this.slots) {
            if (!slot.method_25405(x, y)) continue;
            return slot;
        }
        return null;
    }

    public void method_25394(@NotNull class_332 gui, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.backpack.shouldClose()) {
            this.method_25419();
        }
        this.repopulateSlots(gui, pMouseX, pMouseY, pPartialTick);
        super.method_25394(gui, pMouseX, pMouseY, pPartialTick);
        List tooltipFromItem = class_437.method_25408((class_310)this.field_22787, (class_1799)this.backpack.toStack());
        int width = 0;
        for (class_2561 line : tooltipFromItem) {
            int i = this.field_22793.method_27525((class_5348)line);
            if (i <= width) continue;
            width = i;
        }
        gui.method_51437(this.field_22793, tooltipFromItem, Optional.empty(), this.field_2776 - (width += 56) + 19, this.traitY - 12 * tooltipFromItem.size() + 9);
        this.method_2380(gui, pMouseX, pMouseY);
    }

    protected abstract void repopulateSlots(class_332 var1, int var2, int var3, float var4);

    public void addSlot(TraitSlot widget) {
        this.slots.add(widget);
    }

    public void clearSlots() {
        this.slots.clear();
    }

    public class_1799 getCarried() {
        return ((class_1723)this.field_2797).method_34255();
    }

    protected void method_2388(class_332 pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
    }

    protected boolean method_2381(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        if (pMouseX > (double)(this.traitX - this.traitW) && pMouseY > (double)this.traitY && pMouseX < (double)this.traitX && pMouseY < (double)(this.traitY + this.traitH)) {
            return false;
        }
        return super.method_2381(pMouseX, pMouseY, pGuiLeft, pGuiTop, pMouseButton);
    }

    protected void method_2389(class_332 gui, float v, int pMouseX, int pMouseY) {
        int left = this.field_2776;
        int top = this.field_2800;
        gui.method_25302(field_2801, left, top, 0, 0, this.field_2792, this.field_2779);
        class_490.method_2486((class_332)gui, (int)(left + 26), (int)(top + 8), (int)(left + 75), (int)(top + 78), (int)30, (float)0.0625f, (float)pMouseX, (float)pMouseY, (class_1309)this.field_22787.field_1724);
        CommonClient.renderSlots(gui, this.field_2776, this.field_2800, this.field_2792, this.field_2779, this.field_22787.field_1724);
    }

    public abstract class TraitSlot
    extends class_339 {
        protected final int index;

        public TraitSlot(int pX, int pY, int index) {
            super(pX, pY, 18, 18, (class_2561)class_2561.method_43473());
            this.index = index;
        }

        public abstract class_1799 getItem();

        public boolean method_25402(double pMouseX, double pMouseY, int button) {
            if (this.field_22763 && this.field_22764 && this.method_25361(pMouseX, pMouseY)) {
                class_746 player = ((BackpackScreen)BackpackScreen.this).field_22787.field_1724;
                TinyClickType clickType = BackpackScreen.getClickType(BackpackScreen.this.field_22787, button, (class_1657)player);
                final class_1703 menu = player.field_7512;
                class_5630 carriedAccess = new class_5630(){

                    public class_1799 method_32327() {
                        return menu.method_34255();
                    }

                    public boolean method_32332(class_1799 p_150452_) {
                        menu.method_34254(p_150452_);
                        return true;
                    }
                };
                BackpackScreen.this.tinyMenuClick(this.index, clickType, carriedAccess, player);
                return true;
            }
            return false;
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }

        public void method_25354(class_1144 pHandler) {
        }

        public void hotbarClick(int hotbarSlot) {
            class_746 player = ((BackpackScreen)BackpackScreen.this).field_22787.field_1724;
            final class_1703 menu = player.field_7512;
            class_5630 carriedAccess = new class_5630(){

                public class_1799 method_32327() {
                    return menu.method_34255();
                }

                public boolean method_32332(class_1799 p_150452_) {
                    menu.method_34254(p_150452_);
                    return true;
                }
            };
            TinyClickType clickType = TinyClickType.getHotbar(hotbarSlot);
            BackpackScreen.this.tinyMenuClick(this.index, clickType, carriedAccess, player);
        }

        public void dropItem() {
            class_746 player = ((BackpackScreen)BackpackScreen.this).field_22787.field_1724;
            final class_1703 menu = player.field_7512;
            class_5630 carriedAccess = new class_5630(){

                public class_1799 method_32327() {
                    return menu.method_34255();
                }

                public boolean method_32332(class_1799 p_150452_) {
                    menu.method_34254(p_150452_);
                    return true;
                }
            };
            BackpackScreen.this.tinyMenuClick(this.index, TinyClickType.DROP, carriedAccess, player);
        }
    }
}

