/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.screen;

import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.traits.IClientTraits;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class TraitMenu<T extends GenericTraits> {
    protected final class_310 minecraft;
    public final class_1735 slot;
    public final ComponentHolder holder;
    public final T traits;
    protected final int slotX;
    protected final int slotY;
    public final long timeOpened;
    private final int screenWidth;
    private final int screenHeight;
    protected int leftPos;
    protected int topPos;

    public TraitMenu(class_310 minecraft, int screenLeft, int screenTop, int screenHeight, int screenWidth, class_1735 slot, ComponentHolder holder, T traits) {
        this(minecraft, slot, holder, traits, screenLeft + slot.field_7873, screenTop + slot.field_7872, screenHeight, screenWidth);
    }

    public TraitMenu(class_310 minecraft, class_1735 slot, ComponentHolder holder, T traits, int slotX, int slotY, int screenHeight, int screenWidth) {
        this.minecraft = minecraft;
        this.slot = slot;
        this.holder = holder;
        this.traits = traits;
        this.slotX = slotX;
        this.slotY = slotY;
        this.leftPos = slotX + 14;
        this.topPos = slotY - 2;
        this.screenHeight = screenHeight;
        this.screenWidth = screenWidth;
        this.timeOpened = class_156.method_658();
    }

    @Nullable
    public static TraitMenu<?> create(class_310 minecraft, int leftPos, int topPos, int imageHeight, int imageWidth, class_1735 slot) {
        ComponentHolder holder;
        GenericTraits traits;
        if (slot == null) {
            return null;
        }
        class_1799 stack = slot.method_7677();
        Optional<GenericTraits> optional = Traits.get(stack);
        if (optional.isEmpty()) {
            Optional<EnderTraits> oEnderTraits = EnderTraits.get(stack);
            if (oEnderTraits.isEmpty()) {
                return null;
            }
            EnderTraits enderTraits = oEnderTraits.get();
            traits = enderTraits.getTrait((class_1937)class_310.method_1551().field_1687);
            holder = enderTraits;
        } else {
            traits = optional.get();
            holder = ComponentHolder.of(slot);
        }
        IClientTraits<GenericTraits> client = traits.client();
        return client.createTooltip(minecraft, leftPos, topPos, imageHeight, imageWidth, slot, holder, traits);
    }

    public void render(class_465<?> screen, class_332 gui, int mouseX, int mouseY) {
        if (this.isHoveringSlot(mouseX, mouseY)) {
            int x = this.slot.field_7873;
            int y = this.slot.field_7872;
            RenderSystem.enableBlend();
            class_2960 location = class_2960.method_60655((String)"beansbackpacks", (String)"exit_trait_menu");
            gui.method_52709(location, 16, 16, 0, 0, x, y, 310, 16, 16);
            RenderSystem.disableBlend();
        }
        class_4587 pose = gui.method_51448();
        pose.method_22903();
        pose.method_46416((float)(this.slot.field_7873 - this.slotX + this.leftPos), (float)(this.slot.field_7872 - this.slotY + this.topPos), 301.0f);
        this.menuRender(screen, gui, mouseX - this.leftPos, mouseY - this.topPos);
        pose.method_22909();
    }

    public boolean isHovering(int mouseX, int mouseY) {
        return this.isHoveringSlot(mouseX, mouseY) || this.isHoveringMenu(mouseX, mouseY);
    }

    public boolean isHoveringSlot(int mouseX, int mouseY) {
        if (mouseX < this.slotX - 1) {
            return false;
        }
        return mouseY >= this.slotY - 1 && mouseY <= this.slotY + 16 && mouseX <= this.slotX + 18;
    }

    public void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        this.menuClicked(mouseX - (double)this.leftPos, mouseY - (double)this.topPos, button, cir);
    }

    protected void menuRender(class_465<?> screen, class_332 gui, int mouseX, int mouseY) {
        String name = this.traits.getClass().getSimpleName();
        class_5250 component = class_2561.method_43470((String)name);
        gui.method_51434(this.minecraft.field_1772, List.of(component), 0, this.getHeight());
    }

    public void menuClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
    }

    private boolean isHoveringMenu(int mouseX, int mouseY) {
        if ((mouseX -= this.leftPos) < 0 || (mouseY -= this.topPos) < 0) {
            return false;
        }
        return this.getWidth() > mouseX && this.getHeight() > mouseY;
    }

    protected int getWidth() {
        String name = this.traits.getClass().getSimpleName();
        class_5250 component = class_2561.method_43470((String)name);
        int width = this.minecraft.field_1772.method_27525((class_5348)component);
        return width + 16;
    }

    protected int getHeight() {
        return 16;
    }

    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
    }
}

