/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.traits;

import com.beansgalaxy.backpacks.components.reference.NonTrait;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.ITraitCodec;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.generic.ItemStorageTraits;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;

public class TraitComponentKind<T extends GenericTraits>
implements class_9331<T> {
    public static final List<TraitComponentKind<? extends GenericTraits>> TRAITS = Lists.newArrayList();
    public static final List<TraitComponentKind<? extends ItemStorageTraits>> STORAGE_TRAITS = Lists.newArrayList();
    public static final List<TraitComponentKind<? extends BundleLikeTraits>> BUNDLE_TRAITS = Lists.newArrayList();
    public static final class_9139<class_9129, TraitComponentKind<? extends GenericTraits>> STREAM_CODEC = class_9139.method_56437((buf, type) -> buf.method_53002(type.i), buf -> {
        int integer = buf.readInt();
        return TraitComponentKind.get(integer);
    });
    public static final Codec<TraitComponentKind<? extends GenericTraits>> CODEC = PrimitiveCodec.INT.comapFlatMap(integer -> {
        TraitComponentKind<GenericTraits> type = TraitComponentKind.get(integer);
        return type == null ? DataResult.error(() -> "failure to parse TraitComponentType") : DataResult.success(type);
    }, type -> type.i);
    public final int i;
    private final String name;
    private final ITraitCodec<T> codecs;

    public static TraitComponentKind<? extends GenericTraits> get(int integer) {
        for (TraitComponentKind<? extends GenericTraits> trait : TRAITS) {
            if (trait.i != integer) continue;
            return trait;
        }
        return NonTrait.KIND;
    }

    public static TraitComponentKind<? extends GenericTraits> get(String kind) {
        for (TraitComponentKind<? extends GenericTraits> trait : TRAITS) {
            if (!Objects.equals(trait.name, kind)) continue;
            return trait;
        }
        return NonTrait.KIND;
    }

    public TraitComponentKind(int i, String name, ITraitCodec<T> codecs) {
        this.i = i;
        this.name = name;
        this.codecs = codecs;
    }

    public static <T extends GenericTraits> TraitComponentKind<T> register(String name, ITraitCodec<T> codecs) {
        int i = TRAITS.size();
        TraitComponentKind<T> componentType = new TraitComponentKind<T>(i, name, codecs);
        TRAITS.add(componentType);
        Services.PLATFORM.register(name, componentType);
        return componentType;
    }

    public static <T extends ItemStorageTraits> TraitComponentKind<T> registerItemStorage(String name, ITraitCodec<T> codecs) {
        TraitComponentKind<T> kind = TraitComponentKind.register(name, codecs);
        STORAGE_TRAITS.add(kind);
        return kind;
    }

    public static <T extends BundleLikeTraits> TraitComponentKind<T> registerBundleLike(String name, ITraitCodec<T> codecs) {
        TraitComponentKind<T> kind = TraitComponentKind.registerItemStorage(name, codecs);
        BUNDLE_TRAITS.add(kind);
        return kind;
    }

    @NotNull
    public Codec<T> method_57875() {
        return this.codecs.codec();
    }

    public class_9139<? super class_9129, T> method_57878() {
        return this.codecs.streamCodec();
    }

    public String toString() {
        return "TraitComponentKind[" + this.name + "]";
    }

    public static <T extends GenericTraits> void encode(class_9129 buf, T traits) {
        TraitComponentKind<? extends GenericTraits> kind = traits.kind();
        kind.method_57878().encode((Object)buf, traits);
    }

    public static <T extends GenericTraits, A> RecordBuilder<A> encode(T traits, DynamicOps<A> ops, RecordBuilder<A> prefix) {
        TraitComponentKind<? extends GenericTraits> kind = traits.kind();
        return kind.method_57875().fieldOf("trait").encode(traits, ops, prefix);
    }
}

